/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Polynomial;
import jasymca.Unexakt;
import jasymca.Zahl;

class LambdaLOG
extends LambdaAlgebraic {
    public LambdaLOG() {
        this.diffrule = "1/x";
        this.intrule = "x*log(x)-x";
    }

    @Override
    Zahl f(Zahl x) {
        Unexakt z = x.unexakt();
        if (z.real < 0.0 || z.imag != 0.0) {
            return new Unexakt(Math.log(z.real * z.real + z.imag * z.imag) / 2.0, Math.atan2(z.imag, z.real));
        }
        return new Unexakt(Math.log(z.real));
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x.equals(Zahl.ONE)) {
            return Zahl.ZERO;
        }
        if (x.equals(Zahl.MINUS)) {
            return Zahl.PI.mult(Zahl.IONE);
        }
        if (x instanceof Polynomial && ((Polynomial)x).degree() == 1 && ((Polynomial)x).a[0].equals(Zahl.ZERO) && ((Polynomial)x).var instanceof FunctionVariable && ((FunctionVariable)((Polynomial)x).var).fname.equals("exp")) {
            return ((FunctionVariable)((Polynomial)x).var).arg.add(FunctionVariable.create("log", ((Polynomial)x).a[1]));
        }
        return null;
    }
}

