/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.ExpandConstants;
import jasymca.JH1D;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaPLOT2D;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Vektor;
import java.awt.Color;
import java.util.Stack;
import jhplot.F1D;
import jhplot.P1D;
import jmathlab.utils.UtilsOptions;

class LambdaDRAW2D
extends Lambda {
    LambdaDRAW2D() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        return this.drawArgs2D(st);
    }

    int drawArgs2D(Stack st) throws ParseException, JasymcaException {
        double[] y;
        double[] x;
        if (LambdaPLOT2D.pg == null) {
            return 0;
        }
        int narg = LambdaDRAW2D.getNarg(st);
        Object[] pargs = new Object[narg];
        String option = "";
        Polynomial pol = null;
        JH1D h1d = null;
        int k1 = 0;
        for (int i = 0; i < narg; ++i) {
            Object x2 = st.pop();
            if (x2 instanceof Vektor) {
                x2 = new ExpandConstants().f_exakt((Vektor)x2);
                pargs[k1] = ((Vektor)x2).getDouble();
                ++k1;
            }
            if (x2 instanceof String) {
                option = ((String)x2).trim();
            }
            if (x2 instanceof Polynomial) {
                pol = (Polynomial)x2;
            }
            if (!(x2 instanceof JH1D)) continue;
            h1d = (JH1D)x2;
        }
        if (k1 == 0 && option.length() > 1 && pol == null) {
            double x1 = LambdaPLOT2D.pg.getMinValue(0);
            double x2 = LambdaPLOT2D.pg.getMaxValue(0);
            F1D f1 = new F1D(option, x1, x2);
            LambdaPLOT2D.pg.draw(f1);
            return 0;
        }
        P1D p1 = null;
        F1D f1 = null;
        if (k1 == 2) {
            x = (double[])pargs[0];
            y = (double[])pargs[1];
            if (x.length != y.length) {
                throw new JasymcaException("X and Y must be same length");
            }
            p1 = new P1D("data", x, y);
            p1.setDimension(2);
        }
        if (k1 == 3) {
            x = (double[])pargs[0];
            y = (double[])pargs[1];
            double[] ey = (double[])pargs[2];
            if (x.length != y.length) {
                throw new JasymcaException("X and Y must be same length");
            }
            if (x.length != ey.length) {
                throw new JasymcaException("X and EY must be same length");
            }
            p1 = new P1D("data");
            p1.setDimension(4);
            for (int n = 0; n < x.length; ++n) {
                p1.add(x[n], y[n], ey[n], ey[n]);
            }
        }
        if (k1 == 4) {
            x = (double[])pargs[0];
            y = (double[])pargs[1];
            double[] eyU = (double[])pargs[2];
            double[] eyL = (double[])pargs[3];
            if (x.length != y.length) {
                throw new JasymcaException("X and Y must be same length");
            }
            if (x.length != eyU.length) {
                throw new JasymcaException("X and EY upper must be same length");
            }
            if (x.length != eyL.length) {
                throw new JasymcaException("X and EX lower must be same length");
            }
            p1 = new P1D("data");
            p1.setDimension(4);
            for (int n = 0; n < x.length; ++n) {
                p1.add(x[n], y[n], eyU[n], eyL[n]);
            }
        }
        if (k1 == 6) {
            x = (double[])pargs[0];
            y = (double[])pargs[1];
            double[] exL = (double[])pargs[2];
            double[] exR = (double[])pargs[3];
            double[] eyU = (double[])pargs[4];
            double[] eyL = (double[])pargs[5];
            if (x.length != y.length) {
                throw new JasymcaException("X and Y must be same length");
            }
            if (x.length != eyU.length) {
                throw new JasymcaException("X and EY upper must be same length");
            }
            if (x.length != eyL.length) {
                throw new JasymcaException("X and EX lower must be same length");
            }
            if (x.length != exL.length) {
                throw new JasymcaException("X and X left must be same length");
            }
            if (x.length != exR.length) {
                throw new JasymcaException("X and R right must be same length");
            }
            p1 = new P1D("data");
            p1.setDimension(6);
            for (int n = 0; n < x.length; ++n) {
                p1.add(x[n], y[n], exL[n], exR[n], eyU[n], eyL[n]);
            }
        }
        if (pol != null) {
            double x1 = LambdaPLOT2D.pg.getMinValue(0);
            double x2 = LambdaPLOT2D.pg.getMaxValue(0);
            f1 = new F1D(pol.toString(), x1, x2);
        }
        if (p1 == null && f1 == null && h1d == null) {
            return 0;
        }
        if (option.length() > 0 && p1 != null) {
            UtilsOptions uo = new UtilsOptions(option);
            p1.setTitle(uo.getStringValue("name", "data"));
            p1.setStyle(uo.getStringValue("style", "p"));
            p1.setSymbol(uo.getIntValue("symboltype", 4));
            p1.setPenWidth(uo.getIntValue("linewidth", 2));
            p1.setLineStyle(uo.getIntValue("linestyle", 1));
            p1.setSymbolSize(uo.getIntValue("symbolsize", 4));
            p1.setColor(uo.getColorValue("color", Color.blue));
        }
        if (option.length() > 0 && h1d != null) {
            UtilsOptions uo = new UtilsOptions(option);
            h1d.getH1D().setTitle(uo.getStringValue("name", "data"));
            h1d.getH1D().setStyle(uo.getStringValue("style", "p"));
            h1d.getH1D().setFill(uo.getBooleanValue("filled", true));
            h1d.getH1D().setPenWidth(uo.getIntValue("linewidth", 2));
            h1d.getH1D().setLineStyle(uo.getIntValue("linestyle", 1));
            h1d.getH1D().setColor(uo.getColorValue("color", Color.blue));
            h1d.getH1D().setFillColor(uo.getColorValue("fillcolor", Color.blue));
        }
        if (option.length() > 0 && f1 != null) {
            UtilsOptions uo = new UtilsOptions(option);
            f1.setTitle(uo.getStringValue("name", "data"));
            f1.setPenWidth(uo.getIntValue("linewidth", 2));
            f1.setLineStyle(uo.getIntValue("linestyle", 1));
            f1.setColor(uo.getColorValue("color", Color.black));
        }
        if (p1 != null) {
            LambdaPLOT2D.pg.draw(p1);
        }
        if (f1 != null) {
            LambdaPLOT2D.pg.draw(f1);
        }
        if (h1d != null) {
            LambdaPLOT2D.pg.draw(h1d.getH1D());
        }
        return 0;
    }
}

