/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Unexakt;
import jasymca.Zahl;

class LambdaATAN
extends LambdaAlgebraic {
    public LambdaATAN() {
        this.diffrule = "1/(1+x^2)";
        this.intrule = "x*atan(x)-1/2*log(1+x^2)";
        this.trigrule = "-i/2*log((1+i*x)/(1-i*x))";
    }

    @Override
    Zahl f(Zahl x) throws JasymcaException {
        Unexakt z = x.unexakt();
        if (z.imag == 0.0) {
            return new Unexakt(Math.atan(z.real));
        }
        return (Zahl)LambdaATAN.evalx(this.trigrule, z);
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x.equals(Zahl.ZERO)) {
            return Zahl.ZERO;
        }
        return null;
    }
}

