/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Unexakt;
import jasymca.Zahl;

class LambdaACOS
extends LambdaAlgebraic {
    public LambdaACOS() {
        this.diffrule = "-1/sqrt(1-x^2)";
        this.intrule = "x*acos(x)-sqrt(1-x^2)";
        this.trigrule = "-i*log(x+i*sqrt(1-x^2))";
    }

    @Override
    Zahl f(Zahl x) throws JasymcaException {
        Unexakt z = x.unexakt();
        if (z.imag == 0.0) {
            return new Unexakt(Math.acos(z.real));
        }
        return (Zahl)LambdaACOS.evalx(this.trigrule, z);
    }
}

