/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Environment;
import jasymca.MaximaParser;
import jasymca.NumFmt;
import jasymca.NumFmtVar;
import jasymca.OctaveParser;
import jasymca.Parser;
import jasymca.Processor;
import jasymca.XProcessor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

public class Jasymca
implements Runnable {
    static String JasymcaRC = "Jasymca.";
    public Environment env;
    public Processor proc = null;
    public Parser pars;
    String ui = "Octave";
    public PrintStream ps;
    public InputStream is;
    String welcome = "%Jasymca calculator. Type \"demo\" to show examples, \"help\" for help";
    static NumFmt fmt = new NumFmtVar(10, 5);
    Thread evalLoop = null;

    public static void main(String[] args) {
        String s = System.getProperty("JASYMCA_RC");
        if (s != null) {
            JasymcaRC = s;
        }
        String ui = "Octave";
        if (args.length > 0) {
            ui = args[0];
        }
        new Jasymca(ui).start(System.in, System.out);
    }

    public static InputStream getFileInputStream(String fname) throws IOException {
        return new FileInputStream(fname);
    }

    static OutputStream getFileOutputStream(String fname, boolean append) throws IOException {
        return new FileOutputStream(fname, append);
    }

    public void destroyApp(boolean a) {
    }

    public void pauseApp() {
    }

    public void interrupt() {
        if (this.proc != null) {
            this.proc.set_interrupt(true);
        }
    }

    public Jasymca() {
        this("Octave");
    }

    public Jasymca(String ui) {
        this.setup_ui(ui, true);
        this.welcome = this.welcome + "  " + ui + "-Mode.\n";
    }

    public void setup_ui(String ui, boolean clear_env) {
        if (clear_env) {
            this.env = new Environment();
        }
        if (ui != null) {
            this.ui = ui;
        }
        if (this.ui.equals("Maxima")) {
            this.proc = new XProcessor(this.env);
            this.pars = new MaximaParser(this.env);
        } else if (this.ui.equals("Octave")) {
            this.proc = new Processor(this.env);
            this.pars = new OctaveParser(this.env);
        } else {
            System.out.println("Mode " + this.ui + " not available.");
            System.exit(0);
        }
    }

    public void start(InputStream is, PrintStream ps) {
        this.is = is;
        this.ps = ps;
        this.proc.setPrintStream(ps);
    }

    @Override
    public void run() {
        while (true) {
            this.ps.print(this.pars.prompt());
            try {
                this.proc.set_interrupt(false);
                List code = this.pars.compile(this.is, this.ps);
                if (code == null) {
                    this.ps.println("");
                    continue;
                }
                if (this.proc.process_list(code, false) == 4) {
                    this.ps.println("\nGoodbye.");
                    return;
                }
                this.proc.printStack();
                continue;
            }
            catch (Exception e) {
                this.ps.println("\n from Jasymca class:\n" + e);
                this.proc.clearStack();
                continue;
            }
            break;
        }
    }
}

