/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Random;

public final class JMath {
    public static final double PI = Double.longBitsToDouble(4614256656552045848L);
    public static final double E = Math.E;
    private static Random random;
    private static final double huge = 1.0E300;
    private static final double tiny = 1.0E-300;
    private static final double[] TWO52;
    private static final double NEGATIVE_ZERO;
    private static final double[] halF;
    private static final double twom1000;
    private static final double o_threshold;
    private static final double u_threshold;
    private static final double[] ln2HI;
    private static final double[] ln2LO;
    private static final double invln2;
    private static final double P1;
    private static final double P2;
    private static final double P3;
    private static final double P4;
    private static final double P5;
    private static final double ln2_hi;
    private static final double ln2_lo;
    private static final double Lg1;
    private static final double Lg2;
    private static final double Lg3;
    private static final double Lg4;
    private static final double Lg5;
    private static final double Lg6;
    private static final double Lg7;
    private static double S1;
    private static double S2;
    private static double S3;
    private static double S4;
    private static double S5;
    private static double S6;
    private static final double one;
    private static final double C1;
    private static final double C2;
    private static final double C3;
    private static final double C4;
    private static final double C5;
    private static final double C6;
    private static final double pio4;
    private static final double pio4lo;
    private static final double[] T;
    private static final double pio2_hi;
    private static final double pio2_lo;
    private static final double pio4_hi;
    private static final double pS0;
    private static final double pS1;
    private static final double pS2;
    private static final double pS3;
    private static final double pS4;
    private static final double pS5;
    private static final double qS1;
    private static final double qS2;
    private static final double qS3;
    private static final double qS4;
    private static final double[] atanhi;
    private static final double[] atanlo;
    private static final double[] aT;
    private static final double pi_o_4;
    private static final double pi_o_2;
    private static final double pi_lo;
    private static final int[] two_over_pi;
    private static final int[] npio2_hw;
    private static final double zero = 0.0;
    private static final double half;
    private static final double two24;
    private static final double invpio2;
    private static final double pio2_1;
    private static final double pio2_1t;
    private static final double pio2_2;
    private static final double pio2_2t;
    private static final double pio2_3;
    private static final double pio2_3t;
    private static final double[] PIo2;
    private static final double twon24;
    private static final double[] bp;
    private static final double[] dp_h;
    private static final double[] dp_l;
    private static final double two53;
    private static final double L1;
    private static final double L2;
    private static final double L3;
    private static final double L4;
    private static final double L5;
    private static final double L6;
    private static final double lg2;
    private static final double lg2_h;
    private static final double lg2_l = -1.904654299957768E-9;
    private static final double ovt = 8.008566259537294E-17;
    private static final double cp;
    private static final double cp_h;
    private static final double cp_l;
    private static final double ivln2;
    private static final double ivln2_h;
    private static final double ivln2_l;
    private static final double two54;
    private static final double twom54;

    public static strictfp int abs(int x) {
        return x < 0 ? -x : x;
    }

    public static strictfp long abs(long x) {
        return x < 0L ? -x : x;
    }

    public static strictfp float abs(float x) {
        return x <= 0.0f ? 0.0f - x : x;
    }

    public static strictfp double abs(double x) {
        return x <= 0.0 ? 0.0 - x : x;
    }

    public static strictfp int min(int x, int y) {
        return x < y ? x : y;
    }

    public static strictfp long min(long x, long y) {
        return x < y ? x : y;
    }

    public static strictfp float min(float x, float y) {
        float ans;
        if (Float.isNaN(x)) {
            return x;
        }
        float f = ans = x <= y ? x : y;
        if (ans == 0.0f && Float.floatToIntBits(y) == Integer.MIN_VALUE) {
            ans = y;
        }
        return ans;
    }

    public static strictfp double min(double x, double y) {
        double ans;
        if (Double.isNaN(x)) {
            return x;
        }
        double d = ans = x <= y ? x : y;
        if (x == 0.0 && y == 0.0 && Double.doubleToLongBits(y) == Long.MIN_VALUE) {
            ans = y;
        }
        return ans;
    }

    public static strictfp int max(int x, int y) {
        return x > y ? x : y;
    }

    public static strictfp long max(long x, long y) {
        return x > y ? x : y;
    }

    public static strictfp float max(float x, float y) {
        float ans;
        if (Float.isNaN(x)) {
            return x;
        }
        float f = ans = x >= y ? x : y;
        if (ans == 0.0f && Float.floatToIntBits(x) == Integer.MIN_VALUE) {
            ans = y;
        }
        return ans;
    }

    public static strictfp double max(double x, double y) {
        double ans;
        if (Double.isNaN(x)) {
            return x;
        }
        double d = ans = x >= y ? x : y;
        if (x == 0.0 && y == 0.0 && Double.doubleToLongBits(x) == Long.MIN_VALUE) {
            ans = y;
        }
        return ans;
    }

    public static strictfp int round(float x) {
        return (int)JMath.floor(x + 0.5f);
    }

    public static strictfp long round(double x) {
        return (long)JMath.floor(x + 0.5);
    }

    public static synchronized strictfp double random() {
        if (random == null) {
            random = new Random();
        }
        return random.nextDouble();
    }

    public static double ceil(double x) {
        if (x == 0.0) {
            return x;
        }
        long ix = Double.doubleToLongBits(x);
        int sign = (int)(ix >> 63 & 1L);
        int exp = ((int)(ix >> 52) & 0x7FF) - 1023;
        if (exp < 0) {
            if (x < 0.0) {
                return NEGATIVE_ZERO;
            }
            if (x == 0.0) {
                return x;
            }
            return 1.0;
        }
        if (exp < 53) {
            long mask = 0xFFFFFFFFFFFFFL >>> exp;
            if ((mask & ix) == 0L) {
                return x;
            }
            if (x > 0.0) {
                ix += 0x10000000000000L >> exp;
            }
            ix &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (exp == 1024) {
            return x;
        }
        return Double.longBitsToDouble(ix);
    }

    public static double floor(double x) {
        if (x == 0.0) {
            return x;
        }
        long ix = Double.doubleToLongBits(x);
        int sign = (int)(ix >> 63 & 1L);
        int exp = ((int)(ix >> 52) & 0x7FF) - 1023;
        if (exp < 0) {
            if (x < 0.0) {
                return -1.0;
            }
            if (x == 0.0) {
                return x;
            }
            return 0.0;
        }
        if (exp < 53) {
            long mask = 0xFFFFFFFFFFFFFL >>> exp;
            if ((mask & ix) == 0L) {
                return x;
            }
            if (x < 0.0) {
                ix += 0x10000000000000L >> exp;
            }
            ix &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (exp == 1024) {
            return x;
        }
        return Double.longBitsToDouble(ix);
    }

    public static double rint(double x) {
        long mask;
        if (x == 0.0) {
            return x;
        }
        long ix = Double.doubleToLongBits(x);
        int sign = (int)(ix >> 63 & 1L);
        int exp = ((int)(ix >> 52) & 0x7FF) - 1023;
        if (exp < 0) {
            if (x < -0.5) {
                return -1.0;
            }
            if (x > 0.5) {
                return 1.0;
            }
            if (sign == 0) {
                return 0.0;
            }
            return NEGATIVE_ZERO;
        }
        if (exp < 53 ? ((mask = 0xFFFFFFFFFFFFFL >>> exp) & ix) == 0L : exp == 1024) {
            return x;
        }
        x = Double.longBitsToDouble(ix);
        double w = TWO52[sign] + x;
        return w - TWO52[sign];
    }

    public static double IEEEremainder(double x, double p) {
        int hx = JMath.__HI(x);
        int lx = JMath.__LO(x);
        int hp = JMath.__HI(p);
        int lp = JMath.__LO(p);
        int sx = hx & Integer.MIN_VALUE;
        hx &= Integer.MAX_VALUE;
        if (((hp &= Integer.MAX_VALUE) | lp) == 0) {
            return x * p / (x * p);
        }
        if (hx >= 0x7FF00000 || hp >= 0x7FF00000 && (hp - 0x7FF00000 | lp) != 0) {
            return x * p / (x * p);
        }
        if (hp <= 0x7FDFFFFF) {
            x %= p + p;
        }
        if ((hx - hp | lx - lp) == 0) {
            return 0.0 * x;
        }
        x = JMath.abs(x);
        p = JMath.abs(p);
        if (hp < 0x200000) {
            if (x + x > p && (x -= p) + x >= p) {
                x -= p;
            }
        } else {
            double p_half = 0.5 * p;
            if (x > p_half && (x -= p) >= p_half) {
                x -= p;
            }
        }
        lx = JMath.__HI(x);
        return JMath.setHI(x, lx ^= sx);
    }

    public static double sqrt(double x) {
        long ix = Double.doubleToLongBits(x);
        if ((ix & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            return x * x + x;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return x;
        }
        long m = ix >> 52;
        ix &= 0xFFFFFFFFFFFFFL;
        if (m != 0L) {
            ix |= 0x10000000000000L;
        }
        if (((m -= 1023L) & 1L) != 0L) {
            ix += ix;
        }
        m >>= 1;
        m += 1023L;
        ix += ix;
        long q = 0L;
        long s = 0L;
        for (long r = 0x20000000000000L; r != 0L; r >>= 1) {
            long t = s + r;
            if (t <= ix) {
                s = t + r;
                ix -= t;
                q += r;
            }
            ix += ix;
        }
        if (ix != 0L) {
            q += q & 1L;
        }
        ix = m << 52 | 0xFFFFFFFFFFFFFL & q >> 1;
        return Double.longBitsToDouble(ix);
    }

    public static double exp(double x) {
        double t;
        double hi = 0.0;
        double lo = 0.0;
        int k = 0;
        int hx = JMath.__HI(x);
        int xsb = hx >>> 31 & 1;
        if ((hx &= Integer.MAX_VALUE) >= 1082535490) {
            if (hx >= 0x7FF00000) {
                if ((hx & 0xFFFFF | JMath.__LO(x)) != 0) {
                    return x + x;
                }
                return xsb == 0 ? x : 0.0;
            }
            if (x > o_threshold) {
                return Double.POSITIVE_INFINITY;
            }
            if (x < u_threshold) {
                return twom1000 * twom1000;
            }
        }
        if (hx > 1071001154) {
            if (hx < 1072734898) {
                hi = x - ln2HI[xsb];
                lo = ln2LO[xsb];
                k = 1 - xsb - xsb;
            } else {
                k = (int)(invln2 * x + halF[xsb]);
                t = k;
                hi = x - t * ln2HI[0];
                lo = t * ln2LO[0];
            }
            x = hi - lo;
        } else if (hx < 0x3E300000) {
            if (1.0E300 + x > one) {
                return one + x;
            }
        } else {
            k = 0;
        }
        t = x * x;
        double c = x - t * (P1 + t * (P2 + t * (P3 + t * (P4 + t * P5))));
        if (k == 0) {
            return one - (x * c / (c - 2.0) - x);
        }
        double y = one - (lo - x * c / (2.0 - c) - hi);
        long iy = Double.doubleToLongBits(y);
        iy = k >= -1021 ? (iy += (long)k << 52) : (iy += (long)k + 1000L << 52);
        return Double.longBitsToDouble(iy);
    }

    public static double log(double x) {
        int hx = JMath.__HI(x);
        int lx = JMath.__LO(x);
        int k = 0;
        if (hx < 0x100000) {
            if ((hx & Integer.MAX_VALUE | lx) == 0) {
                return -two54 / 0.0;
            }
            if (hx < 0) {
                return (x - x) / 0.0;
            }
            k -= 54;
            hx = JMath.__HI(x *= two54);
        }
        if (hx >= 0x7FF00000) {
            return x + x;
        }
        k += (hx >> 20) - 1023;
        int i = (hx &= 0xFFFFF) + 614244 & 0x100000;
        x = JMath.setHI(x, hx | i ^ 0x3FF00000);
        k += i >> 20;
        double f = x - 1.0;
        if ((0xFFFFF & 2 + hx) < 3) {
            if (f == 0.0) {
                if (k == 0) {
                    return 0.0;
                }
                double dk = k;
                return dk * ln2_hi + dk * ln2_lo;
            }
            double R = f * f * (0.5 - 0.3333333333333333 * f);
            if (k == 0) {
                return f - R;
            }
            double dk = k;
            return dk * ln2_hi - (R - dk * ln2_lo - f);
        }
        double s = f / (2.0 + f);
        double dk = k;
        double z = s * s;
        i = hx - 398458;
        double w = z * z;
        int j = 440401 - hx;
        double t1 = w * (Lg2 + w * (Lg4 + w * Lg6));
        double t2 = z * (Lg1 + w * (Lg3 + w * (Lg5 + w * Lg7)));
        double R = t2 + t1;
        if ((i |= j) > 0) {
            double hfsq = 0.5 * f * f;
            if (k == 0) {
                return f - (hfsq - s * (hfsq + R));
            }
            return dk * ln2_hi - (hfsq - (s * (hfsq + R) + dk * ln2_lo) - f);
        }
        if (k == 0) {
            return f - s * (f - R);
        }
        return dk * ln2_hi - (s * (f - R) - dk * ln2_lo - f);
    }

    public static double sin(double x) {
        double[] y = new double[2];
        double z = 0.0;
        int ix = JMath.__HI(x);
        if ((ix &= Integer.MAX_VALUE) <= 1072243195) {
            return JMath.__kernel_sin(x, z, 0);
        }
        if (ix >= 0x7FF00000) {
            return x - x;
        }
        int n = JMath.__ieee754_rem_pio2(x, y);
        switch (n & 3) {
            case 0: {
                return JMath.__kernel_sin(y[0], y[1], 1);
            }
            case 1: {
                return JMath.__kernel_cos(y[0], y[1]);
            }
            case 2: {
                return -JMath.__kernel_sin(y[0], y[1], 1);
            }
        }
        return -JMath.__kernel_cos(y[0], y[1]);
    }

    static double __kernel_sin(double x, double y, int iy) {
        int ix = JMath.__HI(x) & Integer.MAX_VALUE;
        if (ix < 1044381696 && (int)x == 0) {
            return x;
        }
        double z = x * x;
        double v = z * x;
        double r = S2 + z * (S3 + z * (S4 + z * (S5 + z * S6)));
        if (iy == 0) {
            return x + v * (S1 + z * r);
        }
        return x - (z * (half * y - v * r) - y - v * S1);
    }

    public static double cos(double x) {
        double z = 0.0;
        double[] y = new double[2];
        int ix = JMath.__HI(x);
        if ((ix &= Integer.MAX_VALUE) <= 1072243195) {
            return JMath.__kernel_cos(x, z);
        }
        if (ix >= 0x7FF00000) {
            return x - x;
        }
        int n = JMath.__ieee754_rem_pio2(x, y);
        switch (n & 3) {
            case 0: {
                return JMath.__kernel_cos(y[0], y[1]);
            }
            case 1: {
                return -JMath.__kernel_sin(y[0], y[1], 1);
            }
            case 2: {
                return -JMath.__kernel_cos(y[0], y[1]);
            }
        }
        return JMath.__kernel_sin(y[0], y[1], 1);
    }

    private static double __kernel_cos(double x, double y) {
        double qx = 0.0;
        int ix = JMath.__HI(x) & Integer.MAX_VALUE;
        if (ix < 1044381696 && (int)x == 0) {
            return one;
        }
        double z = x * x;
        double r = z * (C1 + z * (C2 + z * (C3 + z * (C4 + z * (C5 + z * C6)))));
        if (ix < 0x3FD33333) {
            return one - (0.5 * z - (z * r - x * y));
        }
        qx = ix > 1072234496 ? 0.28125 : JMath.set(ix - 0x200000, 0);
        double hz = 0.5 * z - qx;
        double a = one - qx;
        return a - (hz - (z * r - x * y));
    }

    public static double tan(double x) {
        double z = 0.0;
        int ix = JMath.__HI(x);
        if ((ix &= Integer.MAX_VALUE) <= 1072243195) {
            return JMath.__kernel_tan(x, z, 1);
        }
        if (ix >= 0x7FF00000) {
            return x - x;
        }
        double[] y = new double[2];
        int n = JMath.__ieee754_rem_pio2(x, y);
        return JMath.__kernel_tan(y[0], y[1], 1 - ((n & 1) << 1));
    }

    private static double __kernel_tan(double x, double y, int iy) {
        double a;
        double w;
        double z;
        int hx = JMath.__HI(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix < 0x3E300000 && (int)x == 0) {
            if ((ix | JMath.__LO(x) | iy + 1) == 0) {
                return one / JMath.abs(x);
            }
            return iy == 1 ? x : -one / x;
        }
        if (ix >= 1072010280) {
            if (hx < 0) {
                x = -x;
                y = -y;
            }
            z = pio4 - x;
            w = pio4lo - y;
            x = z + w;
            y = 0.0;
        }
        z = x * x;
        w = z * z;
        double r = T[1] + w * (T[3] + w * (T[5] + w * (T[7] + w * (T[9] + w * T[11]))));
        double v = z * (T[2] + w * (T[4] + w * (T[6] + w * (T[8] + w * (T[10] + w * T[12])))));
        double s = z * x;
        r = y + z * (s * (r + v) + y);
        w = x + (r += T[0] * s);
        if (ix >= 1072010280) {
            v = iy;
            return (double)(1 - (hx >> 30 & 2)) * (v - 2.0 * (x - (w * w / (w + v) - r)));
        }
        if (iy == 1) {
            return w;
        }
        z = w;
        z = JMath.setLO(z, 0);
        v = r - (z - x);
        double t = a = -1.0 / w;
        t = JMath.setLO(t, 0);
        s = 1.0 + t * z;
        return t + a * (s + t * v);
    }

    public static double asin(double x) {
        double t = 0.0;
        int hx = JMath.__HI(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x3FF00000) {
            if ((ix - 0x3FF00000 | JMath.__LO(x)) == 0) {
                return x * pio2_hi + x * pio2_lo;
            }
            return (x - x) / (x - x);
        }
        if (ix < 1071644672) {
            if (ix < 1044381696) {
                if (1.0E300 + x > one) {
                    return x;
                }
            } else {
                t = x * x;
            }
            double p = t * (pS0 + t * (pS1 + t * (pS2 + t * (pS3 + t * (pS4 + t * pS5)))));
            double q = one + t * (qS1 + t * (qS2 + t * (qS3 + t * qS4)));
            double w = p / q;
            return x + x * w;
        }
        double w = one - JMath.abs(x);
        t = w * 0.5;
        double p = t * (pS0 + t * (pS1 + t * (pS2 + t * (pS3 + t * (pS4 + t * pS5)))));
        double q = one + t * (qS1 + t * (qS2 + t * (qS3 + t * qS4)));
        double s = JMath.sqrt(t);
        if (ix >= 0x3FEF3333) {
            w = p / q;
            t = pio2_hi - (2.0 * (s + s * w) - pio2_lo);
        } else {
            w = s;
            w = JMath.setLO(w, 0);
            double c = (t - w * w) / (s + w);
            double r = p / q;
            p = 2.0 * s * r - (pio2_lo - 2.0 * c);
            q = pio4_hi - 2.0 * w;
            t = pio4_hi - (p - q);
        }
        return hx > 0 ? t : -t;
    }

    public static double acos(double x) {
        double s;
        int hx = JMath.__HI(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x3FF00000) {
            if ((ix - 0x3FF00000 | JMath.__LO(x)) == 0) {
                if (hx > 0) {
                    return 0.0;
                }
                return PI + 2.0 * pio2_lo;
            }
            return (x - x) / (x - x);
        }
        if (ix < 1071644672) {
            if (ix <= 1012924416) {
                return pio2_hi + pio2_lo;
            }
            double z = x * x;
            double p = z * (pS0 + z * (pS1 + z * (pS2 + z * (pS3 + z * (pS4 + z * pS5)))));
            double q = one + z * (qS1 + z * (qS2 + z * (qS3 + z * qS4)));
            double r = p / q;
            return pio2_hi - (x - (pio2_lo - x * r));
        }
        if (hx < 0) {
            double z = (one + x) * 0.5;
            double p = z * (pS0 + z * (pS1 + z * (pS2 + z * (pS3 + z * (pS4 + z * pS5)))));
            double q = one + z * (qS1 + z * (qS2 + z * (qS3 + z * qS4)));
            double s2 = JMath.sqrt(z);
            double r = p / q;
            double w = r * s2 - pio2_lo;
            return PI - 2.0 * (s2 + w);
        }
        double z = (one - x) * 0.5;
        double df = s = JMath.sqrt(z);
        df = JMath.setLO(df, 0);
        double c = (z - df * df) / (s + df);
        double p = z * (pS0 + z * (pS1 + z * (pS2 + z * (pS3 + z * (pS4 + z * pS5)))));
        double q = one + z * (qS1 + z * (qS2 + z * (qS3 + z * qS4)));
        double r = p / q;
        double w = r * s + c;
        return 2.0 * (df + w);
    }

    public static double atan(double x) {
        int id;
        int hx = JMath.__HI(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x44100000) {
            if (ix > 0x7FF00000 || ix == 0x7FF00000 && JMath.__LO(x) != 0) {
                return x + x;
            }
            if (hx > 0) {
                return atanhi[3] + atanlo[3];
            }
            return -atanhi[3] - atanlo[3];
        }
        if (ix < 1071382528) {
            if (ix < 1042284544 && 1.0E300 + x > one) {
                return x;
            }
            id = -1;
        } else {
            x = JMath.abs(x);
            if (ix < 0x3FF30000) {
                if (ix < 1072037888) {
                    id = 0;
                    x = (2.0 * x - one) / (2.0 + x);
                } else {
                    id = 1;
                    x = (x - one) / (x + one);
                }
            } else if (ix < 1073971200) {
                id = 2;
                x = (x - 1.5) / (one + 1.5 * x);
            } else {
                id = 3;
                x = -1.0 / x;
            }
        }
        double z = x * x;
        double w = z * z;
        double s1 = z * (aT[0] + w * (aT[2] + w * (aT[4] + w * (aT[6] + w * (aT[8] + w * aT[10])))));
        double s2 = w * (aT[1] + w * (aT[3] + w * (aT[5] + w * (aT[7] + w * aT[9]))));
        if (id < 0) {
            return x - x * (s1 + s2);
        }
        z = atanhi[id] - (x * (s1 + s2) - atanlo[id] - x);
        return hx < 0 ? -z : z;
    }

    public static double atan2(double y, double x) {
        int hx = JMath.__HI(x);
        int ix = hx & Integer.MAX_VALUE;
        int lx = JMath.__LO(x);
        int hy = JMath.__HI(y);
        int iy = hy & Integer.MAX_VALUE;
        int ly = JMath.__LO(y);
        if ((ix | (lx | -lx) >>> 31) > 0x7FF00000 || (iy | (ly | -ly) >>> 31) > 0x7FF00000) {
            return x + y;
        }
        if ((hx - 0x3FF00000 | lx) == 0) {
            return JMath.atan(y);
        }
        int m = hy >> 31 & 1 | hx >> 30 & 2;
        if ((iy | ly) == 0) {
            switch (m) {
                case 0: 
                case 1: {
                    return y;
                }
                case 2: {
                    return PI + 1.0E-300;
                }
                case 3: {
                    return -PI - 1.0E-300;
                }
            }
        }
        if ((ix | lx) == 0) {
            return hy < 0 ? -pi_o_2 - 1.0E-300 : pi_o_2 + 1.0E-300;
        }
        if (ix == 0x7FF00000) {
            if (iy == 0x7FF00000) {
                switch (m) {
                    case 0: {
                        return pi_o_4 + 1.0E-300;
                    }
                    case 1: {
                        return -pi_o_4 - 1.0E-300;
                    }
                    case 2: {
                        return 3.0 * pi_o_4 + 1.0E-300;
                    }
                    case 3: {
                        return -3.0 * pi_o_4 - 1.0E-300;
                    }
                }
            } else {
                switch (m) {
                    case 0: {
                        return 0.0;
                    }
                    case 1: {
                        return -0.0;
                    }
                    case 2: {
                        return PI + 1.0E-300;
                    }
                    case 3: {
                        return -PI - 1.0E-300;
                    }
                }
            }
        }
        if (iy == 0x7FF00000) {
            return hy < 0 ? -pi_o_2 - 1.0E-300 : pi_o_2 + 1.0E-300;
        }
        int k = iy - ix >> 20;
        double z = k > 60 ? pi_o_2 + 0.5 * pi_lo : (hx < 0 && k < -60 ? 0.0 : JMath.atan(JMath.abs(y / x)));
        switch (m) {
            case 0: {
                return z;
            }
            case 1: {
                return JMath.setHI(z, JMath.__HI(z) ^ Integer.MIN_VALUE);
            }
            case 2: {
                return PI - (z - pi_lo);
            }
        }
        return z - pi_lo - PI;
    }

    private static int __ieee754_rem_pio2(double x, double[] y) {
        double z = 0.0;
        double[] tx = new double[3];
        int hx = JMath.__HI(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix <= 1072243195) {
            y[0] = x;
            y[1] = 0.0;
            return 0;
        }
        if (ix < 1073928572) {
            if (hx > 0) {
                z = x - pio2_1;
                if (ix != 1073291771) {
                    y[0] = z - pio2_1t;
                    y[1] = z - y[0] - pio2_1t;
                } else {
                    y[0] = (z -= pio2_2) - pio2_2t;
                    y[1] = z - y[0] - pio2_2t;
                }
                return 1;
            }
            z = x + pio2_1;
            if (ix != 1073291771) {
                y[0] = z + pio2_1t;
                y[1] = z - y[0] + pio2_1t;
            } else {
                y[0] = (z += pio2_2) + pio2_2t;
                y[1] = z - y[0] + pio2_2t;
            }
            return -1;
        }
        if (ix <= 1094263291) {
            double t = JMath.abs(x);
            int n = (int)(t * invpio2 + half);
            double fn = n;
            double r = t - fn * pio2_1;
            double w = fn * pio2_1t;
            if (n < 32 && ix != npio2_hw[n - 1]) {
                y[0] = r - w;
            } else {
                int j = ix >> 20;
                y[0] = r - w;
                int i = j - (JMath.__HI(y[0]) >> 20 & 0x7FF);
                if (i > 16) {
                    t = r;
                    w = fn * pio2_2;
                    r = t - w;
                    w = fn * pio2_2t - (t - r - w);
                    y[0] = r - w;
                    i = j - (JMath.__HI(y[0]) >> 20 & 0x7FF);
                    if (i > 49) {
                        t = r;
                        w = fn * pio2_3;
                        r = t - w;
                        w = fn * pio2_3t - (t - r - w);
                        y[0] = r - w;
                    }
                }
            }
            y[1] = r - y[0] - w;
            if (hx < 0) {
                y[0] = -y[0];
                y[1] = -y[1];
                return -n;
            }
            return n;
        }
        if (ix >= 0x7FF00000) {
            y[0] = y[1] = x - x;
            return 0;
        }
        long lx = Double.doubleToLongBits(x);
        long exp = (0x7FF0000000000000L & lx) >> 52;
        lx -= (exp -= 1046L) << 52;
        z = Double.longBitsToDouble(lx &= Long.MAX_VALUE);
        for (int i = 0; i < 2; ++i) {
            tx[i] = (int)z;
            z = (z - tx[i]) * two24;
        }
        tx[2] = z;
        int nx = 3;
        while (tx[nx - 1] == 0.0) {
            --nx;
        }
        int n = JMath.__kernel_rem_pio2(tx, y, (int)exp, nx);
        if (hx < 0) {
            y[0] = -y[0];
            y[1] = -y[1];
            return -n;
        }
        return n;
    }

    private static int __kernel_rem_pio2(double[] x, double[] y, int e0, int nx) {
        int k;
        int ih;
        int n;
        double z;
        double fw;
        int jk;
        double[] f = new double[20];
        double[] q = new double[20];
        double[] fq = new double[20];
        int[] iq = new int[20];
        int jp = jk = 4;
        int jx = nx - 1;
        int jv = (e0 - 3) / 24;
        if (jv < 0) {
            jv = 0;
        }
        int q0 = e0 - 24 * (jv + 1);
        int j = jv - jx;
        int m = jx + jk;
        int i = 0;
        while (i <= m) {
            f[i] = j < 0 ? 0.0 : (double)two_over_pi[j];
            ++i;
            ++j;
        }
        for (i = 0; i <= jk; ++i) {
            fw = 0.0;
            for (j = 0; j <= jx; ++j) {
                fw += x[j] * f[jx + i - j];
            }
            q[i] = fw;
        }
        int jz = jk;
        while (true) {
            i = 0;
            z = q[jz];
            for (j = jz; j > 0; --j) {
                fw = (int)(twon24 * z);
                iq[i] = (int)(z - two24 * fw);
                z = q[j - 1] + fw;
                ++i;
            }
            z = JMath.scalbn(z, q0);
            z -= 8.0 * JMath.floor(z * 0.125);
            n = (int)z;
            z -= (double)n;
            ih = 0;
            if (q0 > 0) {
                i = iq[jz - 1] >> 24 - q0;
                n += i;
                int n2 = jz - 1;
                iq[n2] = iq[n2] - (i << 24 - q0);
                ih = iq[jz - 1] >> 23 - q0;
            } else if (q0 == 0) {
                ih = iq[jz - 1] >> 23;
            } else if (z >= 0.5) {
                ih = 2;
            }
            if (ih > 0) {
                ++n;
                boolean carry = false;
                for (i = 0; i < jz; ++i) {
                    j = iq[i];
                    if (!carry) {
                        if (j == 0) continue;
                        carry = true;
                        iq[i] = 0x1000000 - j;
                        continue;
                    }
                    iq[i] = 0xFFFFFF - j;
                }
                if (q0 > 0) {
                    switch (q0) {
                        case 1: {
                            int n3 = jz - 1;
                            iq[n3] = iq[n3] & 0x7FFFFF;
                            break;
                        }
                        case 2: {
                            int n4 = jz - 1;
                            iq[n4] = iq[n4] & 0x3FFFFF;
                        }
                    }
                }
                if (ih == 2) {
                    z = one - z;
                    if (carry) {
                        z -= JMath.scalbn(one, q0);
                    }
                }
            }
            if (z != 0.0) break;
            j = 0;
            for (i = jz - 1; i >= jk; --i) {
                j |= iq[i];
            }
            if (j != 0) break;
            k = 1;
            while (iq[jk - k] == 0) {
                ++k;
            }
            for (i = jz + 1; i <= jz + k; ++i) {
                f[jx + i] = two_over_pi[jv + i];
                fw = 0.0;
                for (j = 0; j <= jx; ++j) {
                    fw += x[j] * f[jx + i - j];
                }
                q[i] = fw;
            }
            jz += k;
        }
        if (z == 0.0) {
            --jz;
            q0 -= 24;
            while (iq[jz] == 0) {
                --jz;
                q0 -= 24;
            }
        } else if ((z = JMath.scalbn(z, -q0)) >= two24) {
            fw = (int)(twon24 * z);
            iq[jz] = (int)(z - two24 * fw);
            q0 += 24;
            iq[++jz] = (int)fw;
        } else {
            iq[jz] = (int)z;
        }
        fw = JMath.scalbn(one, q0);
        for (i = jz; i >= 0; --i) {
            q[i] = fw * (double)iq[i];
            fw *= twon24;
        }
        for (i = jz; i >= 0; --i) {
            fw = 0.0;
            for (k = 0; k <= jp && k <= jz - i; ++k) {
                fw += PIo2[k] * q[i + k];
            }
            fq[jz - i] = fw;
        }
        fw = 0.0;
        for (i = jz; i >= 0; --i) {
            fw += fq[i];
        }
        y[0] = ih == 0 ? fw : -fw;
        fw = fq[0] - fw;
        for (i = 1; i <= jz; ++i) {
            fw += fq[i];
        }
        y[1] = ih == 0 ? fw : -fw;
        return n & 7;
    }

    public static double pow(double x, double y) {
        double p_l;
        double p_h;
        double r;
        double s;
        int n;
        double t2;
        double t1;
        double v;
        double u;
        double w;
        double t;
        int j;
        int k;
        int hx = JMath.__HI(x);
        int lx = JMath.__LO(x);
        int hy = JMath.__HI(y);
        int ly = JMath.__LO(y);
        int ix = hx & Integer.MAX_VALUE;
        int iy = hy & Integer.MAX_VALUE;
        if ((iy | ly) == 0) {
            return one;
        }
        if (ix > 0x7FF00000 || ix == 0x7FF00000 && lx != 0 || iy > 0x7FF00000 || iy == 0x7FF00000 && ly != 0) {
            return x + y;
        }
        int yisint = 0;
        if (hx < 0) {
            if (iy >= 0x43400000) {
                yisint = 2;
            } else if (iy >= 0x3FF00000) {
                k = (iy >> 20) - 1023;
                if (k > 20) {
                    j = ly >>> 52 - k;
                    if (j << 52 - k == ly) {
                        yisint = 2 - (j & 1);
                    }
                } else if (ly == 0 && (j = iy >> 20 - k) << 20 - k == iy) {
                    yisint = 2 - (j & 1);
                }
            }
        }
        if (ly == 0) {
            if (iy == 0x7FF00000) {
                if ((ix - 0x3FF00000 | lx) == 0) {
                    return y - y;
                }
                if (ix >= 0x3FF00000) {
                    return hy >= 0 ? y : 0.0;
                }
                return hy < 0 ? -y : 0.0;
            }
            if (iy == 0x3FF00000) {
                if (hy < 0) {
                    return one / x;
                }
                return x;
            }
            if (hy == 0x40000000) {
                return x * x;
            }
            if (hy == 1071644672 && hx >= 0) {
                return JMath.sqrt(x);
            }
        }
        double ax = JMath.abs(x);
        if (lx == 0 && (ix == 0x7FF00000 || ix == 0 || ix == 0x3FF00000)) {
            double z = ax;
            if (hy < 0) {
                z = one / z;
            }
            if (hx < 0) {
                if ((ix - 0x3FF00000 | yisint) == 0) {
                    z = (z - z) / (z - z);
                } else if (yisint == 1) {
                    z = -z;
                }
            }
            return z;
        }
        if (((hx >> 31) + 1 | yisint) == 0) {
            return (x - x) / (x - x);
        }
        if (iy > 1105199104) {
            if (iy > 1139802112) {
                if (ix <= 0x3FEFFFFF) {
                    return hy < 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
                if (ix >= 0x3FF00000) {
                    return hy > 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
            }
            if (ix < 0x3FEFFFFF) {
                return hy < 0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (ix > 0x3FF00000) {
                return hy > 0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            t = x - 1.0;
            w = t * t * (0.5 - t * (0.3333333333333333 - t * 0.25));
            u = ivln2_h * t;
            v = t * ivln2_l - w * ivln2;
            t1 = u + v;
            t1 = JMath.setLO(t1, 0);
            t2 = v - (t1 - u);
        } else {
            n = 0;
            if (ix < 0x100000) {
                n -= 53;
                ix = JMath.__HI(ax *= two53);
            }
            n += (ix >> 20) - 1023;
            j = ix & 0xFFFFF;
            ix = j | 0x3FF00000;
            if (j <= 235662) {
                k = 0;
            } else if (j < 767610) {
                k = 1;
            } else {
                k = 0;
                ++n;
                ix -= 0x100000;
            }
            ax = JMath.setHI(ax, ix);
            u = ax - bp[k];
            v = one / (ax + bp[k]);
            double s_h = s = u * v;
            s_h = JMath.setLO(s_h, 0);
            double t_h = 0.0;
            t_h = JMath.setHI(t_h, (ix >> 1 | 0x20000000) + 524288 + (k << 18));
            double t_l = ax - (t_h - bp[k]);
            double s_l = v * (u - s_h * t_h - s_h * t_l);
            double s2 = s * s;
            r = s2 * s2 * (L1 + s2 * (L2 + s2 * (L3 + s2 * (L4 + s2 * (L5 + s2 * L6)))));
            s2 = s_h * s_h;
            t_h = 3.0 + s2 + (r += s_l * (s_h + s));
            t_h = JMath.setLO(t_h, 0);
            t_l = r - (t_h - 3.0 - s2);
            u = s_h * t_h;
            v = s_l * t_h + t_l * s;
            p_h = u + v;
            p_h = JMath.setLO(p_h, 0);
            p_l = v - (p_h - u);
            double z_h = cp_h * p_h;
            double z_l = cp_l * p_h + p_l * cp + dp_l[k];
            t = n;
            t1 = z_h + z_l + dp_h[k] + t;
            t1 = JMath.setLO(t1, 0);
            t2 = z_l - (t1 - t - dp_h[k] - z_h);
        }
        s = one;
        if (((hx >> 31) + 1 | yisint - 1) == 0) {
            s = -one;
        }
        double y1 = y;
        y1 = JMath.setLO(y1, 0);
        p_l = (y - y1) * t1 + y * t2;
        p_h = y1 * t1;
        double z = p_l + p_h;
        j = JMath.__HI(z);
        int i = JMath.__LO(z);
        if (j >= 0x40900000) {
            if ((j - 0x40900000 | i) != 0) {
                return s * 1.0E300 * 1.0E300;
            }
            if (p_l + 8.008566259537294E-17 > z - p_h) {
                return s * 1.0E300 * 1.0E300;
            }
        } else if ((j & Integer.MAX_VALUE) >= 1083231232) {
            if ((j - -1064252416 | i) != 0) {
                return s * 1.0E-300 * 1.0E-300;
            }
            if (p_l <= z - p_h) {
                return s * 1.0E-300 * 1.0E-300;
            }
        }
        i = j & Integer.MAX_VALUE;
        k = (i >> 20) - 1023;
        n = 0;
        if (i > 1071644672) {
            n = j + (0x100000 >> k + 1);
            k = ((n & Integer.MAX_VALUE) >> 20) - 1023;
            t = 0.0;
            t = JMath.setHI(t, n & ~(1048575 >> k));
            n = (n & 0xFFFFF | 0x100000) >> 20 - k;
            if (j < 0) {
                n = -n;
            }
            p_h -= t;
        }
        t = p_l + p_h;
        t = JMath.setLO(t, 0);
        u = t * lg2_h;
        v = (p_l - (t - p_h)) * lg2 + t * -1.904654299957768E-9;
        z = u + v;
        w = v - (z - u);
        t = z * z;
        t1 = z - t * (P1 + t * (P2 + t * (P3 + t * (P4 + t * P5))));
        r = z * t1 / (t1 - 2.0) - (w + z * w);
        z = one - (r - z);
        j = JMath.__HI(z);
        if ((j += n << 20) >> 20 <= 0) {
            z = JMath.scalbn(z, n);
        } else {
            i = JMath.__HI(z);
            z = JMath.setHI(z, i += n << 20);
        }
        return s * z;
    }

    private static double copysign(double x, double y) {
        long ix = Double.doubleToLongBits(x);
        long iy = Double.doubleToLongBits(y);
        ix = Long.MAX_VALUE * ix | Long.MIN_VALUE & iy;
        return Double.longBitsToDouble(ix);
    }

    private static double scalbn(double x, int n) {
        int hx = JMath.__HI(x);
        int lx = JMath.__LO(x);
        int k = (hx & 0x7FF00000) >> 20;
        if (k == 0) {
            if ((lx | hx & Integer.MAX_VALUE) == 0) {
                return x;
            }
            hx = JMath.__HI(x *= two54);
            k = ((hx & 0x7FF00000) >> 20) - 54;
            if (n < -50000) {
                return 1.0E-300 * x;
            }
        }
        if (k == 2047) {
            return x + x;
        }
        if ((k += n) > 2046) {
            return 1.0E300 * JMath.copysign(1.0E300, x);
        }
        if (k > 0) {
            return JMath.setHI(x, hx & 0x800FFFFF | k << 20);
        }
        if (k <= -54) {
            if (n > 50000) {
                return 1.0E300 * JMath.copysign(1.0E300, x);
            }
        } else {
            return 1.0E-300 * JMath.copysign(1.0E-300, x);
        }
        return twom54 * JMath.setHI(x, hx & 0x800FFFFF | (k += 54) << 20);
    }

    private static double set(int newHiPart, int newLowPart) {
        return Double.longBitsToDouble((long)newHiPart << 32 | (long)newLowPart);
    }

    private static double setLO(double x, int newLowPart) {
        long lx = Double.doubleToLongBits(x);
        lx &= 0xFFFFFFFF00000000L;
        return Double.longBitsToDouble(lx |= (long)newLowPart);
    }

    private static double setHI(double x, int newHiPart) {
        long lx = Double.doubleToLongBits(x);
        lx &= 0xFFFFFFFFL;
        return Double.longBitsToDouble(lx |= (long)newHiPart << 32);
    }

    private static int __HI(double x) {
        return (int)(0xFFFFFFFFFFFFFFFFL & Double.doubleToLongBits(x) >> 32);
    }

    private static int __LO(double x) {
        return (int)(0xFFFFFFFFFFFFFFFFL & Double.doubleToLongBits(x));
    }

    static {
        TWO52 = new double[]{Double.longBitsToDouble(0x4330000000000000L), Double.longBitsToDouble(-4382002437431492608L)};
        NEGATIVE_ZERO = Double.longBitsToDouble(Long.MIN_VALUE);
        halF = new double[]{0.5, -0.5};
        twom1000 = Double.longBitsToDouble(0x170000000000000L);
        o_threshold = Double.longBitsToDouble(4649454530587146735L);
        u_threshold = Double.longBitsToDouble(-4573606559926636463L);
        ln2HI = new double[]{Double.longBitsToDouble(4604418534311723008L), Double.longBitsToDouble(-4618953502543052800L)};
        ln2LO = new double[]{Double.longBitsToDouble(4461442080421002358L), Double.longBitsToDouble(-4761929956433773450L)};
        invln2 = Double.longBitsToDouble(4609176140021203710L);
        P1 = Double.longBitsToDouble(4595172819793696062L);
        P2 = Double.longBitsToDouble(-4654820494858601069L);
        P3 = Double.longBitsToDouble(4544508515198557740L);
        P4 = Double.longBitsToDouble(-4702957295668925455L);
        P5 = Double.longBitsToDouble(4496342204012209360L);
        ln2_hi = Double.longBitsToDouble(4604418534311723008L);
        ln2_lo = Double.longBitsToDouble(4461442080421002358L);
        Lg1 = Double.longBitsToDouble(4604180019048437139L);
        Lg2 = Double.longBitsToDouble(4600877379321592324L);
        Lg3 = Double.longBitsToDouble(4598818590951641945L);
        Lg4 = Double.longBitsToDouble(4597174411056806063L);
        Lg5 = Double.longBitsToDouble(4595719342595441630L);
        Lg6 = Double.longBitsToDouble(4594685411790997151L);
        Lg7 = Double.longBitsToDouble(4594499633228436036L);
        S1 = -0.16666666666666632;
        S2 = 0.00833333333332249;
        S3 = -1.984126982985795E-4;
        S4 = 2.7557313707070068E-6;
        S5 = -2.5050760253406863E-8;
        S6 = 1.58969099521155E-10;
        one = Double.longBitsToDouble(0x3FF0000000000000L);
        C1 = Double.longBitsToDouble(4586165620538955084L);
        C2 = Double.longBitsToDouble(-4659324094485802633L);
        C3 = Double.longBitsToDouble(4537941361668330896L);
        C4 = Double.longBitsToDouble(-4714566979978243411L);
        C5 = Double.longBitsToDouble(4477121870137962948L);
        C6 = Double.longBitsToDouble(-4780295122622859052L);
        pio4 = Double.longBitsToDouble(4605249457297304856L);
        pio4lo = Double.longBitsToDouble(4359948597267291143L);
        T = new double[]{Double.longBitsToDouble(4599676419421066595L), Double.longBitsToDouble(4593971859893059194L), Double.longBitsToDouble(4587938466107703806L), Double.longBitsToDouble(4581960672245896759L), Double.longBitsToDouble(4576262931677611155L), Double.longBitsToDouble(4570429193025094440L), Double.longBitsToDouble(4564358403679355669L), Double.longBitsToDouble(4558562946408670465L), Double.longBitsToDouble(4553182066015801448L), Double.longBitsToDouble(4545397049192321702L), Double.longBitsToDouble(4544897349388904425L), Double.longBitsToDouble(-4687273268743220365L), Double.longBitsToDouble(4538267711989316308L)};
        pio2_hi = Double.longBitsToDouble(4609753056924675352L);
        pio2_lo = Double.longBitsToDouble(4364452196894661639L);
        pio4_hi = Double.longBitsToDouble(4605249457297304856L);
        pS0 = Double.longBitsToDouble(4595172819793696085L);
        pS1 = Double.longBitsToDouble(-4623835544539140227L);
        pS2 = Double.longBitsToDouble(4596417465768494165L);
        pS3 = Double.longBitsToDouble(-4637438604930937029L);
        pS4 = Double.longBitsToDouble(4560439845004096136L);
        pS5 = Double.longBitsToDouble(4540259411154564873L);
        qS1 = Double.longBitsToDouble(-4610777653840302773L);
        qS2 = Double.longBitsToDouble(4611733184086379208L);
        qS3 = Double.longBitsToDouble(-4618997306433404583L);
        qS4 = Double.longBitsToDouble(4590215604441354882L);
        atanhi = new double[]{Double.longBitsToDouble(4602023952714414927L), Double.longBitsToDouble(4605249457297304856L), Double.longBitsToDouble(4607027438436873883L), Double.longBitsToDouble(4609753056924675352L)};
        atanlo = new double[]{Double.longBitsToDouble(4357843414468748770L), Double.longBitsToDouble(4359948597267291143L), Double.longBitsToDouble(4354989122426817469L), Double.longBitsToDouble(4364452196894661639L)};
        aT = new double[]{Double.longBitsToDouble(4599676419421066509L), Double.longBitsToDouble(-4626998257160492092L), Double.longBitsToDouble(4594314991288484863L), Double.longBitsToDouble(-4630701217362536847L), Double.longBitsToDouble(4591215095208222830L), Double.longBitsToDouble(-4633165035261879699L), Double.longBitsToDouble(4589464229703073105L), Double.longBitsToDouble(-4634804155249132134L), Double.longBitsToDouble(4587333258118041067L), Double.longBitsToDouble(-4637946461342241745L), Double.longBitsToDouble(4580351289466214929L)};
        pi_o_4 = Double.longBitsToDouble(4605249457297304856L);
        pi_o_2 = Double.longBitsToDouble(4609753056924675352L);
        pi_lo = Double.longBitsToDouble(4368955796522032135L);
        two_over_pi = new int[]{10680707, 0x6E4E44, 1387004, 2578385, 16069853, 12639074, 9804092, 4427841, 16666979, 11263675, 12935607, 2387514, 0x424DD2, 14681673, 3074569, 13734428, 16653803, 1880361, 10960616, 8533493, 3062596, 8710556, 7349940, 6258241, 3772886, 3769171, 3798172, 8675211, 12450088, 3874808, 9961438, 366607, 15675153, 9132554, 7151469, 3571407, 2607881, 12013382, 4155038, 6285869, 7677882, 13102053, 15825725, 473591, 9065106, 15363067, 6271263, 9264392, 5636912, 4652155, 7056368, 13614112, 10155062, 1944035, 9527646, 15080200, 6658437, 6231200, 6832269, 16767104, 5075751, 3212806, 1398474, 7579849, 6349435, 12618859};
        npio2_hw = new int[]{1073291771, 1074340347, 1074977148, 1075388923, 1075800698, 1076025724, 1076231611, 1076437499, 1076643386, 1076849274, 1076971356, 1077074300, 1077177244, 1077280187, 1077383131, 1077486075, 1077589019, 1077691962, 1077794906, 1077897850, 1077968460, 1078019932, 1078071404, 1078122876, 1078174348, 1078225820, 1078277292, 1078328763, 1078380235, 1078431707, 1078483179, 1078534651};
        half = Double.longBitsToDouble(4602678819172646912L);
        two24 = Double.longBitsToDouble(4715268809856909312L);
        invpio2 = Double.longBitsToDouble(4603909380684499075L);
        pio2_1 = Double.longBitsToDouble(4609753056924401664L);
        pio2_1t = Double.longBitsToDouble(4454258360616903473L);
        pio2_2 = Double.longBitsToDouble(4454258360616747008L);
        pio2_2t = Double.longBitsToDouble(4297306550709743731L);
        pio2_3 = Double.longBitsToDouble(4297306550709518336L);
        pio2_3t = Double.longBitsToDouble(4142048980368378305L);
        PIo2 = new double[]{Double.longBitsToDouble(4609753056584663040L), Double.longBitsToDouble(4500296887714185216L), Double.longBitsToDouble(4393339057296375808L), Double.longBitsToDouble(4285399695318056960L), Double.longBitsToDouble(4174867106174599168L), Double.longBitsToDouble(4069606033725587456L), Double.longBitsToDouble(3955147982449410048L), Double.longBitsToDouble(3848874662444400640L)};
        twon24 = Double.longBitsToDouble(4499096027743125504L);
        bp = new double[]{1.0, 1.5};
        dp_h = new double[]{0.0, Double.longBitsToDouble(4603444093224222720L)};
        dp_l = new double[]{0.0, Double.longBitsToDouble(4489242115478376454L)};
        two53 = Double.longBitsToDouble(0x4340000000000000L);
        L1 = Double.longBitsToDouble(4603579539098120963L);
        L2 = Double.longBitsToDouble(4601392076422097919L);
        L3 = Double.longBitsToDouble(4599676419357746765L);
        L4 = Double.longBitsToDouble(4598584653024936193L);
        L5 = Double.longBitsToDouble(4597478449480325989L);
        L6 = Double.longBitsToDouble(4596625081194860271L);
        lg2 = Double.longBitsToDouble(4604418534313441775L);
        lg2_h = Double.longBitsToDouble(4604418534330597376L);
        cp = Double.longBitsToDouble(4606838314010018813L);
        cp_h = Double.longBitsToDouble(4606838314073325568L);
        cp_l = Double.longBitsToDouble(-4738297118486494731L);
        ivln2 = Double.longBitsToDouble(4609176140021203710L);
        ivln2_h = Double.longBitsToDouble(4609176139934466048L);
        ivln2_l = Double.longBitsToDouble(4491406094830001988L);
        two54 = Double.longBitsToDouble(4850376798678024192L);
        twom54 = Double.longBitsToDouble(4363988038922010624L);
    }
}

