/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.GetExpVars2;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaAlgebraic;
import jasymca.LambdaEXP;
import jasymca.Poly;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SubstExp;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Vector;

public class Exponential
extends Polynomial {
    public Variable expvar;
    public Algebraic exp_b;

    public Exponential(Algebraic a, Algebraic c, Variable x, Algebraic b) {
        this.a = new Algebraic[2];
        this.a[0] = c;
        this.a[1] = a;
        Algebraic[] z = new Algebraic[]{Zahl.ZERO, b};
        Object la = Lambda.pc.env.getValue("exp");
        if (!(la instanceof LambdaEXP)) {
            la = new LambdaEXP();
        }
        this.var = new FunctionVariable("exp", new Polynomial(x, z), (LambdaAlgebraic)la);
        this.expvar = x;
        this.exp_b = b;
    }

    public Exponential(Polynomial x) {
        super(x.var, x.a);
        this.expvar = ((Polynomial)((FunctionVariable)this.var).arg).var;
        this.exp_b = ((Polynomial)((FunctionVariable)this.var).arg).a[1];
    }

    public static Algebraic poly2exp(Algebraic x) {
        Algebraic arg;
        if (x instanceof Exponential) {
            return x;
        }
        if (x instanceof Polynomial && ((Polynomial)x).degree() == 1 && ((Polynomial)x).var instanceof FunctionVariable && ((FunctionVariable)((Polynomial)x).var).fname.equals("exp") && (arg = ((FunctionVariable)((Polynomial)x).var).arg) instanceof Polynomial && ((Polynomial)arg).degree() == 1 && ((Polynomial)arg).a[0].equals(Zahl.ZERO)) {
            return new Exponential((Polynomial)x);
        }
        return x;
    }

    @Override
    public Algebraic cc() throws JasymcaException {
        return new Exponential(this.a[1].cc(), this.a[0].cc(), this.expvar, this.exp_b.cc());
    }

    static boolean containsexp(Algebraic x) throws JasymcaException {
        if (x instanceof Zahl) {
            return false;
        }
        if (x instanceof Exponential) {
            return true;
        }
        if (x instanceof Polynomial) {
            for (int i = 0; i < ((Polynomial)x).a.length; ++i) {
                if (!Exponential.containsexp(((Polynomial)x).a[i])) continue;
                return true;
            }
            if (((Polynomial)x).var instanceof FunctionVariable) {
                return Exponential.containsexp(((FunctionVariable)((Polynomial)x).var).arg);
            }
            return false;
        }
        if (x instanceof Rational) {
            return Exponential.containsexp(((Rational)x).nom) || Exponential.containsexp(((Rational)x).den);
        }
        if (x instanceof Vektor) {
            for (int i = 0; i < ((Vektor)x).length(); ++i) {
                if (!Exponential.containsexp(((Vektor)x).get(i))) continue;
                return true;
            }
            return false;
        }
        throw new JasymcaException("containsexp not suitable for x");
    }

    @Override
    public Algebraic add(Algebraic x) throws JasymcaException {
        if (x instanceof Zahl) {
            return new Exponential(this.a[1], x.add(this.a[0]), this.expvar, this.exp_b);
        }
        if (x instanceof Exponential) {
            if (this.var.equals(((Exponential)x).var)) {
                return Exponential.poly2exp(super.add(x));
            }
            if (this.var.smaller(((Exponential)x).var)) {
                return x.add(this);
            }
            return new Exponential(this.a[1], x.add(this.a[0]), this.expvar, this.exp_b);
        }
        return Exponential.poly2exp(super.add(x));
    }

    @Override
    public Algebraic mult(Algebraic x) throws JasymcaException {
        if (x.equals(Zahl.ZERO)) {
            return x;
        }
        if (x instanceof Zahl) {
            return new Exponential(this.a[1].mult(x), this.a[0].mult(x), this.expvar, this.exp_b);
        }
        if (x instanceof Exponential && this.expvar.equals(((Exponential)x).expvar)) {
            Exponential xp = (Exponential)x;
            Algebraic r = Zahl.ZERO;
            Algebraic nex = this.exp_b.add(xp.exp_b);
            r = nex.equals(Zahl.ZERO) ? this.a[1].mult(xp.a[1]) : new Exponential(this.a[1].mult(xp.a[1]), Zahl.ZERO, this.expvar, nex);
            r = r.add(this.a[0].mult(xp));
            r = r.add(this.mult(xp.a[0]));
            r = r.reduce();
            return r;
        }
        return Exponential.poly2exp(super.mult(x));
    }

    @Override
    public Algebraic reduce() throws JasymcaException {
        if (this.a[1].reduce().equals(Zahl.ZERO)) {
            return this.a[0].reduce();
        }
        if (this.exp_b.equals(Zahl.ZERO)) {
            return this.a[0].add(this.a[1]).reduce();
        }
        return this;
    }

    @Override
    public Algebraic div(Algebraic x) throws JasymcaException {
        if (x instanceof Zahl) {
            return new Exponential((Polynomial)super.div(x));
        }
        return super.div(x);
    }

    @Override
    public Algebraic map(LambdaAlgebraic f) throws JasymcaException {
        return Exponential.poly2exp(super.map(f));
    }

    public static Zahl exp_gcd(Vector v, Variable x) throws JasymcaException {
        Zahl gcd = Zahl.ZERO;
        int k = 0;
        for (int i = 0; i < v.size(); ++i) {
            Algebraic c;
            Algebraic a = (Algebraic)v.elementAt(i);
            if (Poly.degree(a, x) != 1 || !((c = Poly.coefficient(a, x, 1)) instanceof Zahl)) continue;
            ++k;
            gcd = gcd.gcd((Zahl)c);
        }
        return k > 0 ? gcd : Zahl.ONE;
    }

    public static Algebraic reduce_exp(Algebraic p) throws JasymcaException {
        Algebraic[] a = new Algebraic[]{p};
        a = Exponential.reduce_exp(a);
        return a[0];
    }

    public static Algebraic[] reduce_exp(Algebraic[] p) throws JasymcaException {
        int i;
        Vector v = new Vector();
        Vector<Variable> vars = new Vector<Variable>();
        GetExpVars2 g = new GetExpVars2(v);
        for (i = 0; i < p.length; ++i) {
            g.f_exakt(p[i]);
        }
        for (i = 0; i < v.size(); ++i) {
            Algebraic a = (Algebraic)v.elementAt(i);
            Variable x = null;
            if (!(a instanceof Polynomial) || vars.contains(x = ((Polynomial)a).var)) continue;
            vars.addElement(x);
            Zahl gcd = Exponential.exp_gcd(v, x);
            if (gcd.equals(Zahl.ZERO) || gcd.equals(Zahl.ONE)) continue;
            SubstExp sb = new SubstExp(gcd, x);
            for (int k = 0; k < p.length; ++k) {
                p[k] = sb.f_exakt(p[k]);
            }
        }
        return p;
    }
}

