/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaAlgebraic;
import jasymca.LambdaRAT;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.StringFmt;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.io.PrintStream;

public abstract class Algebraic {
    String name = null;

    public abstract Algebraic add(Algebraic var1) throws JasymcaException;

    public Algebraic sub(Algebraic x) throws JasymcaException {
        return this.add(x.mult(Zahl.MINUS));
    }

    public abstract Algebraic mult(Algebraic var1) throws JasymcaException;

    public Algebraic div(Algebraic x) throws JasymcaException {
        if (x instanceof Polynomial) {
            return new Rational(this, (Polynomial)x).reduce();
        }
        if (x instanceof Rational) {
            return ((Rational)x).den.mult(this).div(((Rational)x).nom);
        }
        if (!x.scalarq()) {
            return new Matrix(this).div(x);
        }
        throw new JasymcaException("Can not divide " + this + " through " + x);
    }

    public Algebraic pow_n(int n) throws JasymcaException {
        Algebraic x = this;
        if (n <= 0) {
            if (n == 0 || this.equals(Zahl.ONE)) {
                return Zahl.ONE;
            }
            if (this.equals(Zahl.ZERO)) {
                throw new JasymcaException("Division by Zero.");
            }
            x = Zahl.ONE.div(x);
            n = -n;
        }
        Algebraic pow = Zahl.ONE;
        while (true) {
            if ((n & 1) != 0) {
                pow = pow.mult(x);
            }
            if ((n >>= 1) == 0) break;
            x = x.mult(x);
        }
        return pow;
    }

    public abstract Algebraic cc() throws JasymcaException;

    public Algebraic realpart() throws JasymcaException {
        return this.add(this.cc()).div(Zahl.TWO);
    }

    public Algebraic imagpart() throws JasymcaException {
        return this.sub(this.cc()).div(Zahl.TWO).div(Zahl.IONE);
    }

    public abstract Algebraic deriv(Variable var1) throws JasymcaException;

    public abstract Algebraic integrate(Variable var1) throws JasymcaException;

    public abstract double norm();

    public abstract Algebraic map(LambdaAlgebraic var1) throws JasymcaException;

    public Algebraic rat() throws JasymcaException {
        return this.map(new LambdaRAT());
    }

    public Algebraic reduce() throws JasymcaException {
        return this;
    }

    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        return this;
    }

    public boolean depends(Variable var) {
        return false;
    }

    public boolean ratfunc(Variable v) {
        return true;
    }

    public boolean depdir(Variable var) {
        return this.depends(var) && this.ratfunc(var);
    }

    public boolean constantq() {
        return false;
    }

    public abstract boolean equals(Object var1);

    public boolean komplexq() throws JasymcaException {
        return !this.imagpart().equals(Zahl.ZERO);
    }

    public boolean scalarq() {
        return true;
    }

    public boolean exaktq() {
        return false;
    }

    public Algebraic promote(Algebraic b) throws JasymcaException {
        if (b.scalarq()) {
            return this;
        }
        if (b instanceof Vektor) {
            Vektor bv = (Vektor)b;
            if (this instanceof Vektor && ((Vektor)this).length() == bv.length()) {
                return this;
            }
            if (this.scalarq()) {
                return new Vektor(this, bv.length());
            }
        }
        if (b instanceof Matrix) {
            Matrix bm = (Matrix)b;
            if (this instanceof Matrix && bm.equalsized((Matrix)this)) {
                return this;
            }
            if (this.scalarq()) {
                return new Matrix(this, bm.nrow(), bm.ncol());
            }
        }
        throw new JasymcaException("Wrong argument type.");
    }

    public void print(PrintStream p) {
        p.print(StringFmt.compact(this.toString()));
    }

    static void p(String s) {
        Lambda.p(s);
    }

    public Algebraic map_lambda(LambdaAlgebraic lambda, Algebraic arg2) throws ParseException, JasymcaException {
        if (arg2 == null) {
            Algebraic r = lambda.f_exakt(this);
            if (r != null) {
                return r;
            }
            String fname = lambda.getClass().getName();
            if (fname.startsWith("jasymca.Lambda")) {
                fname = fname.substring("jasymca.Lambda".length());
                fname = fname.toLowerCase();
                return FunctionVariable.create(fname, this);
            }
            throw new JasymcaException("Wrong type of arguments.");
        }
        return lambda.f_exakt(this, arg2);
    }
}

