/*
 * Decompiled with CFR 0.152.
 */
package processing.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PSurfaceNone;

public class PSurfaceAWT
extends PSurfaceNone {
    GraphicsDevice displayDevice;
    Frame frame;
    Rectangle screenRect;
    Insets currentInsets = new Insets(0, 0, 0, 0);
    Canvas canvas = new SmoothCanvas();
    int sketchWidth;
    int sketchHeight;
    List<Image> iconImages;
    int cursorType = 0;
    boolean cursorVisible = true;
    Cursor invisibleCursor;

    public PSurfaceAWT(PGraphics graphics) {
        super(graphics);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (!PSurfaceAWT.this.sketch.isLooping()) {
                    Dimension canvasSize = PSurfaceAWT.this.canvas.getSize();
                    if (canvasSize.width != PSurfaceAWT.this.sketch.sketchWidth() || canvasSize.height != PSurfaceAWT.this.sketch.sketchHeight()) {
                        PSurfaceAWT.this.sketch.redraw();
                    }
                }
            }
        });
        this.addListeners();
    }

    protected synchronized void render() {
        if (this.canvas.isDisplayable() && this.graphics.image != null) {
            BufferStrategy strategy;
            if (this.canvas.getBufferStrategy() == null) {
                this.canvas.createBufferStrategy(2);
            }
            if ((strategy = this.canvas.getBufferStrategy()) != null) {
                while (true) {
                    Graphics2D draw = (Graphics2D)strategy.getDrawGraphics();
                    draw.drawImage(this.graphics.image, 0, 0, this.sketchWidth, this.sketchHeight, null);
                    draw.dispose();
                    if (strategy.contentsRestored()) continue;
                    strategy.show();
                    if (!strategy.contentsLost()) break;
                }
            }
        }
    }

    @Override
    public void initOffscreen(PApplet sketch) {
        this.sketch = sketch;
    }

    @Override
    public void initFrame(final PApplet sketch) {
        this.sketch = sketch;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int displayNum = sketch.sketchDisplay();
        if (displayNum > 0) {
            GraphicsDevice[] devices = environment.getScreenDevices();
            if (displayNum <= devices.length) {
                this.displayDevice = devices[displayNum - 1];
            } else {
                System.err.format("Display %d does not exist, using the default display instead.%n", displayNum);
                for (int i = 0; i < devices.length; ++i) {
                    System.err.format("Display %d is %s%n", i + 1, devices[i]);
                }
            }
        }
        if (this.displayDevice == null) {
            this.displayDevice = environment.getDefaultScreenDevice();
        }
        boolean spanDisplays = sketch.sketchDisplay() == 0;
        this.screenRect = spanDisplays ? PSurfaceAWT.getDisplaySpan() : this.displayDevice.getDefaultConfiguration().getBounds();
        sketch.displayWidth = this.screenRect.width;
        sketch.displayHeight = this.screenRect.height;
        this.sketchWidth = sketch.sketchWidth();
        this.sketchHeight = sketch.sketchHeight();
        boolean fullScreen = sketch.sketchFullScreen();
        if (fullScreen || spanDisplays) {
            this.sketchWidth = this.screenRect.width;
            this.sketchHeight = this.screenRect.height;
        }
        this.frame = new JFrame(this.displayDevice.getDefaultConfiguration());
        Color windowColor = new Color(sketch.sketchWindowColor(), false);
        if (this.frame instanceof JFrame) {
            ((JFrame)this.frame).getContentPane().setBackground(windowColor);
        } else {
            this.frame.setBackground(windowColor);
        }
        this.setProcessingIcon(this.frame);
        this.frame.add(this.canvas);
        this.setSize(this.sketchWidth, this.sketchHeight);
        this.frame.setLayout(null);
        if (fullScreen) {
            this.frame.invalidate();
        }
        this.frame.setResizable(false);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                sketch.exit();
            }
        });
    }

    @Override
    public Object getNative() {
        return this.canvas;
    }

    @Override
    public void setTitle(String title) {
        this.frame.setTitle(title);
        if (this.cursorVisible && PApplet.platform == 2 && this.cursorType != 0) {
            this.hideCursor();
            this.showCursor();
        }
    }

    @Override
    public void setResizable(boolean resizable) {
        if (this.frame != null) {
            this.frame.setResizable(resizable);
        }
    }

    @Override
    public void setIcon(PImage image) {
        Image awtImage = (Image)image.getNative();
        if (PApplet.platform != 2) {
            this.frame.setIconImage(awtImage);
        } else {
            try {
                String td = "processing.core.ThinkDifferent";
                Class<?> thinkDifferent = Thread.currentThread().getContextClassLoader().loadClass("processing.core.ThinkDifferent");
                Method method = thinkDifferent.getMethod("setIconImage", Image.class);
                method.invoke(null, awtImage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setAlwaysOnTop(boolean always) {
        this.frame.setAlwaysOnTop(always);
    }

    @Override
    public void setLocation(int x, int y) {
        this.frame.setLocation(x, y);
    }

    protected void setProcessingIcon(Frame frame) {
        if (PApplet.platform != 2) {
            try {
                if (this.iconImages == null) {
                    int[] sizes;
                    this.iconImages = new ArrayList<Image>();
                    for (int sz : sizes = new int[]{16, 32, 48, 64, 128, 256, 512}) {
                        URL url = PApplet.class.getResource("/icon/icon-" + sz + ".png");
                        Image image = Toolkit.getDefaultToolkit().getImage(url);
                        this.iconImages.add(image);
                    }
                }
                frame.setIconImages(this.iconImages);
            }
            catch (Exception sizes) {}
        } else if (!this.dockIconSpecified()) {
            URL url = PApplet.class.getResource("/icon/icon-512.png");
            try {
                String td = "processing.core.ThinkDifferent";
                Class<?> thinkDifferent = Thread.currentThread().getContextClassLoader().loadClass("processing.core.ThinkDifferent");
                Method method = thinkDifferent.getMethod("setIconImage", Image.class);
                method.invoke(null, Toolkit.getDefaultToolkit().getImage(url));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean dockIconSpecified() {
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : jvmArgs) {
            if (!arg.startsWith("-Xdock:icon")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
        if (this.canvas != null) {
            this.canvas.requestFocus();
        }
    }

    @Override
    public void placePresent(int stopColor) {
        this.setFullFrame();
        this.canvas.setBounds((this.screenRect.width - this.sketchWidth) / 2, (this.screenRect.height - this.sketchHeight) / 2, this.sketchWidth, this.sketchHeight);
        if (stopColor != 0) {
            Label label = new Label("stop");
            label.setForeground(new Color(stopColor, false));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PSurfaceAWT.this.sketch.exit();
                }
            });
            this.frame.add(label);
            Dimension labelSize = label.getPreferredSize();
            labelSize = new Dimension(100, labelSize.height);
            label.setSize(labelSize);
            label.setLocation(20, this.screenRect.height - labelSize.height - 20);
        }
    }

    private void setCanvasSize() {
        int contentW = Math.max(this.sketchWidth, 128);
        int contentH = Math.max(this.sketchHeight, 128);
        this.canvas.setBounds((contentW - this.sketchWidth) / 2, (contentH - this.sketchHeight) / 2, this.sketchWidth, this.sketchHeight);
    }

    private Dimension setFrameSize() {
        this.frame.addNotify();
        this.currentInsets = this.frame.getInsets();
        int windowW = Math.max(this.sketchWidth, 128) + this.currentInsets.left + this.currentInsets.right;
        int windowH = Math.max(this.sketchHeight, 128) + this.currentInsets.top + this.currentInsets.bottom;
        this.frame.setSize(windowW, windowH);
        return new Dimension(windowW, windowH);
    }

    private void setFrameCentered() {
        this.frame.setLocation(this.screenRect.x + (this.screenRect.width - this.sketchWidth) / 2, this.screenRect.y + (this.screenRect.height - this.sketchHeight) / 2);
    }

    private void setFullFrame() {
        PApplet.hideMenuBar();
        this.frame.removeNotify();
        this.frame.setUndecorated(true);
        this.frame.addNotify();
        this.frame.setBounds(this.screenRect);
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
        Dimension window = this.setFrameSize();
        int contentW = Math.max(this.sketchWidth, 128);
        int contentH = Math.max(this.sketchHeight, 128);
        if (this.sketch.sketchFullScreen()) {
            this.setFullFrame();
        }
        if (!this.sketch.sketchFullScreen()) {
            if (location != null) {
                this.frame.setLocation(location[0], location[1]);
            } else if (editorLocation != null) {
                int locationX = editorLocation[0] - 20;
                int locationY = editorLocation[1];
                if (locationX - window.width > 10) {
                    this.frame.setLocation(locationX - window.width, locationY);
                } else {
                    locationX = (this.sketch.displayWidth - window.width) / 2;
                    locationY = (this.sketch.displayHeight - window.height) / 2;
                    this.frame.setLocation(locationX, locationY);
                }
            } else {
                this.setFrameCentered();
            }
            Point frameLoc = this.frame.getLocation();
            if (frameLoc.y < 0) {
                this.frame.setLocation(frameLoc.x, 30);
            }
        }
        this.canvas.setBounds((contentW - this.sketchWidth) / 2, (contentH - this.sketchHeight) / 2, this.sketchWidth, this.sketchHeight);
        this.setupFrameResizeListener();
    }

    @Override
    public void setSize(int wide, int high) {
        if (wide == this.sketch.width && high == this.sketch.height && (this.frame == null || this.currentInsets.equals(this.frame.getInsets()))) {
            return;
        }
        this.sketchWidth = wide;
        this.sketchHeight = high;
        if (this.frame != null) {
            this.setFrameSize();
        }
        this.setCanvasSize();
        this.sketch.setSize(wide, high);
        this.graphics.setSize(wide, high);
    }

    static Rectangle getDisplaySpan() {
        Rectangle bounds = new Rectangle();
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : environment.getScreenDevices()) {
            for (GraphicsConfiguration config : device.getConfigurations()) {
                Rectangle2D.union(bounds, config.getBounds(), bounds);
            }
        }
        return bounds;
    }

    @Override
    public void setupExternalMessages() {
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Point where = ((Frame)e.getSource()).getLocation();
                PSurfaceAWT.this.sketch.frameMoved(where.x, where.y);
            }
        });
    }

    private void setupFrameResizeListener() {
        this.frame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (6 == e.getNewState()) {
                    PSurfaceAWT.this.frame.addNotify();
                }
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Frame farm;
                if (PSurfaceAWT.this.frame.isResizable() && (farm = (Frame)e.getComponent()).isVisible()) {
                    Dimension windowSize = farm.getSize();
                    int x = farm.getX() + PSurfaceAWT.this.currentInsets.left;
                    int y = farm.getY() + PSurfaceAWT.this.currentInsets.top;
                    PSurfaceAWT.this.setSize(windowSize.width - PSurfaceAWT.this.currentInsets.left - PSurfaceAWT.this.currentInsets.right, windowSize.height - PSurfaceAWT.this.currentInsets.top - PSurfaceAWT.this.currentInsets.bottom);
                    PSurfaceAWT.this.setLocation(x - PSurfaceAWT.this.currentInsets.left, y - PSurfaceAWT.this.currentInsets.top);
                }
            }
        });
    }

    protected void nativeMouseEvent(MouseEvent nativeEvent) {
        int peCount = nativeEvent.getClickCount();
        int peAction = 0;
        switch (nativeEvent.getID()) {
            case 501: {
                peAction = 1;
                break;
            }
            case 502: {
                peAction = 2;
                break;
            }
            case 500: {
                peAction = 3;
                break;
            }
            case 506: {
                peAction = 4;
                break;
            }
            case 503: {
                peAction = 5;
                break;
            }
            case 504: {
                peAction = 6;
                break;
            }
            case 505: {
                peAction = 7;
                break;
            }
            case 507: {
                peAction = 8;
                peCount = ((MouseWheelEvent)nativeEvent).getWheelRotation();
            }
        }
        int modifiers = nativeEvent.getModifiers();
        int peModifiers = modifiers & 0xF;
        int peButton = 0;
        if ((modifiers & 0x10) != 0) {
            peButton = 37;
        } else if ((modifiers & 8) != 0) {
            peButton = 3;
        } else if ((modifiers & 4) != 0) {
            peButton = 39;
        }
        if (PApplet.platform == 2 && (modifiers & 2) != 0) {
            peButton = 39;
        }
        this.sketch.postEvent(new processing.event.MouseEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, nativeEvent.getX(), nativeEvent.getY(), peButton, peCount));
    }

    protected void nativeKeyEvent(KeyEvent event) {
        int peAction = 0;
        switch (event.getID()) {
            case 401: {
                peAction = 1;
                break;
            }
            case 402: {
                peAction = 2;
                break;
            }
            case 400: {
                peAction = 3;
            }
        }
        int peModifiers = event.getModifiers() & 0xF;
        this.sketch.postEvent(new processing.event.KeyEvent(event, event.getWhen(), peAction, peModifiers, event.getKeyChar(), event.getKeyCode()));
    }

    protected void addListeners() {
        this.canvas.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }
        });
        this.canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }
        });
        this.canvas.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                PSurfaceAWT.this.nativeMouseEvent(e);
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                PSurfaceAWT.this.nativeKeyEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PSurfaceAWT.this.nativeKeyEvent(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                PSurfaceAWT.this.nativeKeyEvent(e);
            }
        });
        this.canvas.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((PSurfaceAWT)PSurfaceAWT.this).sketch.focused = true;
                PSurfaceAWT.this.sketch.focusGained();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((PSurfaceAWT)PSurfaceAWT.this).sketch.focused = false;
                PSurfaceAWT.this.sketch.focusLost();
            }
        });
    }

    @Override
    public void setCursor(int kind) {
        if (PApplet.platform == 2 && kind == 13) {
            kind = 12;
        }
        this.canvas.setCursor(Cursor.getPredefinedCursor(kind));
        this.cursorVisible = true;
        this.cursorType = kind;
    }

    @Override
    public void setCursor(PImage img, int x, int y) {
        Cursor cursor = this.canvas.getToolkit().createCustomCursor((Image)img.getNative(), new Point(x, y), "custom");
        this.canvas.setCursor(cursor);
        this.cursorVisible = true;
    }

    @Override
    public void showCursor() {
        if (!this.cursorVisible) {
            this.cursorVisible = true;
            this.canvas.setCursor(Cursor.getPredefinedCursor(this.cursorType));
        }
    }

    @Override
    public void hideCursor() {
        if (this.invisibleCursor == null) {
            BufferedImage cursorImg = new BufferedImage(16, 16, 2);
            this.invisibleCursor = this.canvas.getToolkit().createCustomCursor(cursorImg, new Point(8, 8), "blank");
        }
        this.canvas.setCursor(this.invisibleCursor);
        this.cursorVisible = false;
    }

    @Override
    public Thread createThread() {
        return new PSurfaceNone.AnimationThread(){

            @Override
            public void callDraw() {
                PSurfaceAWT.this.sketch.handleDraw();
                PSurfaceAWT.this.render();
            }
        };
    }

    void debug(String format, Object ... args) {
        System.out.format(format + "%n", args);
    }

    public class SmoothCanvas
    extends Canvas {
        private Dimension oldSize = new Dimension(0, 0);
        private Dimension newSize = new Dimension(0, 0);

        public Frame getFrame() {
            return PSurfaceAWT.this.frame;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(PSurfaceAWT.this.sketchWidth, PSurfaceAWT.this.sketchHeight);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return PSurfaceAWT.this.frame.isResizable() ? super.getMaximumSize() : this.getPreferredSize();
        }

        @Override
        public void validate() {
            super.validate();
            this.newSize.width = this.getWidth();
            this.newSize.height = this.getHeight();
            if (!this.oldSize.equals(this.newSize)) {
                this.oldSize = this.newSize;
                PSurfaceAWT.this.sketch.setSize(this.newSize.width, this.newSize.height);
                PSurfaceAWT.this.render();
            }
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics screen) {
            PSurfaceAWT.this.render();
        }
    }
}

