/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.OTFAdvancedTypographicTableReader;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.fonts.truetype.TTFMtxEntry;
import org.apache.fop.fonts.truetype.TTFOutputStream;
import org.apache.fop.fonts.truetype.TTFTableName;
import org.apache.fop.fonts.truetype.TTFTableOutputStream;
import org.apache.xmlgraphics.fonts.Glyphs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTFFile {
    static final byte NTABS = 24;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    private static final String[] MAC_GLYPH_ORDERING = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    protected FontFileReader fontFile;
    public static final boolean TRACE_ENABLED = false;
    private final String encoding = "WinAnsiEncoding";
    private final short firstChar = 0;
    private boolean useKerning = false;
    private boolean isEmbeddable = true;
    private boolean hasSerifs = true;
    protected Map<TTFTableName, TTFDirTabEntry> dirTabs;
    private Map<Integer, Map<Integer, Integer>> kerningTab;
    private Map<Integer, Map<Integer, Integer>> ansiKerningTab;
    private List<CMapSegment> cmaps;
    private Set<UnicodeMapping> unicodeMappings;
    private int upem;
    private int nhmtx;
    private PostScriptVersion postScriptVersion;
    private int locaFormat;
    protected long lastLoca = 0L;
    private int numberOfGlyphs;
    protected TTFMtxEntry[] mtxTab;
    private String postScriptName = "";
    private String fullName = "";
    private String notice = "";
    private Set<String> familyNames = new HashSet<String>();
    private String subFamilyName = "";
    private long italicAngle = 0L;
    private long isFixedPitch = 0L;
    private int fontBBox1 = 0;
    private int fontBBox2 = 0;
    private int fontBBox3 = 0;
    private int fontBBox4 = 0;
    private int capHeight = 0;
    private int os2CapHeight = 0;
    private int underlinePosition = 0;
    private int underlineThickness = 0;
    private int xHeight = 0;
    private int os2xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private int hheaAscender = 0;
    private int hheaDescender = 0;
    private int os2Ascender = 0;
    private int os2Descender = 0;
    private int usWeightClass = 0;
    private short lastChar = 0;
    private int[] ansiWidth;
    private Map<Integer, List<Integer>> ansiIndex;
    private final Map<Integer, Integer> glyphToUnicodeMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> unicodeToGlyphMap = new HashMap<Integer, Integer>();
    private TTFDirTabEntry currentDirTab;
    private boolean isCFF;
    private boolean useAdvanced = false;
    private OTFAdvancedTypographicTableReader advancedTableReader;

    public TTFFile() {
        this(true, false);
    }

    public TTFFile(boolean useKerning, boolean useAdvanced) {
        this.useKerning = useKerning;
        this.useAdvanced = useAdvanced;
    }

    public TTFDirTabEntry getDirectoryEntry(TTFTableName name) {
        return this.dirTabs.get(name);
    }

    public boolean seekTab(FontFileReader in, TTFTableName tableName, long offset) throws IOException {
        TTFDirTabEntry dt = this.dirTabs.get(tableName);
        if (dt == null) {
            return false;
        }
        in.seekSet(dt.getOffset() + offset);
        this.currentDirTab = dt;
        return true;
    }

    public int convertTTFUnit2PDFUnit(int n) {
        int ret;
        if (n < 0) {
            long rest1 = n % this.upem;
            long storrest = 1000L * rest1;
            long ledd2 = storrest != 0L ? rest1 / storrest : 0L;
            ret = -(-1000 * n / this.upem - (int)ledd2);
        } else {
            ret = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return ret;
    }

    private boolean readCMAP() throws IOException {
        this.unicodeMappings = new TreeSet<UnicodeMapping>();
        this.seekTab(this.fontFile, TTFTableName.CMAP, 2L);
        int numCMap = this.fontFile.readTTFUShort();
        long cmapUniOffset = 0L;
        long symbolMapOffset = 0L;
        for (int i = 0; i < numCMap; ++i) {
            int cmapPID = this.fontFile.readTTFUShort();
            int cmapEID = this.fontFile.readTTFUShort();
            long cmapOffset = this.fontFile.readTTFLong();
            if (cmapPID == 3 && cmapEID == 1) {
                cmapUniOffset = cmapOffset;
            }
            if (cmapPID != 3 || cmapEID != 0) continue;
            symbolMapOffset = cmapOffset;
        }
        if (cmapUniOffset > 0L) {
            return this.readUnicodeCmap(cmapUniOffset, 1);
        }
        if (symbolMapOffset > 0L) {
            return this.readUnicodeCmap(symbolMapOffset, 0);
        }
        return false;
    }

    private boolean readUnicodeCmap(long cmapUniOffset, int encodingID) throws IOException {
        int mtxPtr = 0;
        this.seekTab(this.fontFile, TTFTableName.CMAP, cmapUniOffset);
        int cmapFormat = this.fontFile.readTTFUShort();
        this.fontFile.readTTFUShort();
        if (cmapFormat == 4) {
            int i;
            this.fontFile.skip(2L);
            int cmapSegCountX2 = this.fontFile.readTTFUShort();
            int cmapSearchRange = this.fontFile.readTTFUShort();
            int cmapEntrySelector = this.fontFile.readTTFUShort();
            int cmapRangeShift = this.fontFile.readTTFUShort();
            int[] cmapEndCounts = new int[cmapSegCountX2 / 2];
            int[] cmapStartCounts = new int[cmapSegCountX2 / 2];
            int[] cmapDeltas = new int[cmapSegCountX2 / 2];
            int[] cmapRangeOffsets = new int[cmapSegCountX2 / 2];
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapEndCounts[i] = this.fontFile.readTTFUShort();
            }
            this.fontFile.skip(2L);
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapStartCounts[i] = this.fontFile.readTTFUShort();
            }
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapDeltas[i] = this.fontFile.readTTFShort();
            }
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapRangeOffsets[i] = this.fontFile.readTTFUShort();
            }
            int glyphIdArrayOffset = this.fontFile.getCurrentPos();
            BitSet eightBitGlyphs = new BitSet(256);
            for (int i2 = 0; i2 < cmapStartCounts.length; ++i2) {
                for (int j = cmapStartCounts[i2]; j <= cmapEndCounts[i2]; ++j) {
                    int glyphIdx;
                    if (j < 256 && j > this.lastChar) {
                        this.lastChar = (short)j;
                    }
                    if (j < 256) {
                        eightBitGlyphs.set(j);
                    }
                    if (mtxPtr >= this.mtxTab.length) continue;
                    if (cmapRangeOffsets[i2] != 0 && j != 65535) {
                        int glyphOffset = glyphIdArrayOffset + (cmapRangeOffsets[i2] / 2 + (j - cmapStartCounts[i2]) + i2 - cmapSegCountX2 / 2) * 2;
                        this.fontFile.seekSet(glyphOffset);
                        glyphIdx = this.fontFile.readTTFUShort() + cmapDeltas[i2] & 0xFFFF;
                        this.unicodeMappings.add(new UnicodeMapping(glyphIdx, j));
                        this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                        List<Integer> v = this.ansiIndex.get(new Integer(j));
                        if (v != null) {
                            for (Integer aIdx : v) {
                                this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                            }
                        }
                    } else {
                        List<Integer> v;
                        glyphIdx = j + cmapDeltas[i2] & 0xFFFF;
                        if (glyphIdx < this.mtxTab.length) {
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                        }
                        this.unicodeMappings.add(new UnicodeMapping(glyphIdx, j));
                        if (glyphIdx < this.mtxTab.length) {
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                        }
                        if ((v = this.ansiIndex.get(new Integer(j))) != null) {
                            for (Integer aIdx : v) {
                                this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                            }
                        }
                    }
                    if (glyphIdx >= this.mtxTab.length || this.mtxTab[glyphIdx].getUnicodeIndex().size() >= 2) continue;
                    ++mtxPtr;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isInPrivateUseArea(int start, int end) {
        return this.isInPrivateUseArea(start) || this.isInPrivateUseArea(end);
    }

    private boolean isInPrivateUseArea(int unicode) {
        return unicode >= 57344 && unicode <= 63743;
    }

    private void printMaxMin() {
        int min = 255;
        int max = 0;
        for (int i = 0; i < this.mtxTab.length; ++i) {
            if (this.mtxTab[i].getIndex() < min) {
                min = this.mtxTab[i].getIndex();
            }
            if (this.mtxTab[i].getIndex() <= max) continue;
            max = this.mtxTab[i].getIndex();
        }
    }

    public void readFont(FontFileReader in) throws IOException {
        this.readFont(in, null);
    }

    private void initAnsiWidths() {
        int i;
        this.ansiWidth = new int[256];
        for (i = 0; i < 256; ++i) {
            this.ansiWidth[i] = this.mtxTab[0].getWx();
        }
        this.ansiIndex = new HashMap<Integer, List<Integer>>();
        for (i = 32; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            Integer ansi = new Integer(i);
            Integer uni = new Integer(Glyphs.WINANSI_ENCODING[i]);
            List<Integer> v = this.ansiIndex.get(uni);
            if (v == null) {
                v = new ArrayList<Integer>();
                this.ansiIndex.put(uni, v);
            }
            v.add(ansi);
        }
    }

    public boolean readFont(FontFileReader in, String name) throws IOException {
        this.fontFile = in;
        if (!this.checkTTC(name)) {
            if (name == null) {
                throw new IllegalArgumentException("For TrueType collection you must specify which font to select (-ttcname)");
            }
            throw new IOException("Name does not exist in the TrueType collection: " + name);
        }
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.initAnsiWidths();
        this.readPostScript();
        this.readOS2();
        this.determineAscDesc();
        if (!this.isCFF) {
            this.readIndexToLocation();
            this.readGlyf();
        }
        this.readName();
        boolean pcltFound = this.readPCLT();
        boolean valid = this.readCMAP();
        if (!valid) {
            return false;
        }
        this.createCMaps();
        if (this.useKerning) {
            this.readKerning();
        }
        if (this.useAdvanced) {
            try {
                OTFAdvancedTypographicTableReader atr = new OTFAdvancedTypographicTableReader(this, in);
                atr.readAll();
                this.advancedTableReader = atr;
            }
            catch (AdvancedTypographicTableFormatException e) {
                // empty catch block
            }
        }
        this.guessVerticalMetricsFromGlyphBBox();
        return true;
    }

    public void readFont(FontFileReader in, String name, Map<Integer, Integer> glyphs) throws IOException {
        this.readFont(in, name);
    }

    private void createCMaps() {
        int unicodeEnd;
        UnicodeMapping um;
        this.cmaps = new ArrayList<CMapSegment>();
        Iterator<UnicodeMapping> e = this.unicodeMappings.iterator();
        UnicodeMapping lastMapping = um = e.next();
        int unicodeStart = um.getUnicodeIndex();
        int glyphStart = um.getGlyphIndex();
        while (e.hasNext()) {
            um = e.next();
            if (lastMapping.getUnicodeIndex() + 1 != um.getUnicodeIndex() || lastMapping.getGlyphIndex() + 1 != um.getGlyphIndex()) {
                unicodeEnd = lastMapping.getUnicodeIndex();
                this.cmaps.add(new CMapSegment(unicodeStart, unicodeEnd, glyphStart));
                unicodeStart = um.getUnicodeIndex();
                glyphStart = um.getGlyphIndex();
            }
            lastMapping = um;
        }
        unicodeEnd = lastMapping.getUnicodeIndex();
        this.cmaps.add(new CMapSegment(unicodeStart, unicodeEnd, glyphStart));
    }

    public String getPostScriptName() {
        if (this.postScriptName.length() == 0) {
            return FontUtil.stripWhiteSpace(this.getFullName());
        }
        return this.postScriptName;
    }

    PostScriptVersion getPostScriptVersion() {
        return this.postScriptVersion;
    }

    public Set<String> getFamilyNames() {
        return this.familyNames;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCharSetName() {
        return "WinAnsiEncoding";
    }

    public int getCapHeight() {
        return this.convertTTFUnit2PDFUnit(this.capHeight);
    }

    public int getXHeight() {
        return this.convertTTFUnit2PDFUnit(this.xHeight);
    }

    protected int getPadSize(int currentPosition) {
        int padSize = 4 - currentPosition % 4;
        return padSize < 4 ? padSize : 0;
    }

    public int getFlags() {
        int flags = 32;
        if (this.italicAngle != 0L) {
            flags |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            flags |= 2;
        }
        if (this.hasSerifs) {
            flags |= 1;
        }
        return flags;
    }

    public int getWeightClass() {
        return this.usWeightClass;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String ia = Short.toString((short)(this.italicAngle / 65536L));
        return ia;
    }

    public int[] getFontBBox() {
        int[] fbb = new int[]{this.convertTTFUnit2PDFUnit(this.fontBBox1), this.convertTTFUnit2PDFUnit(this.fontBBox2), this.convertTTFUnit2PDFUnit(this.fontBBox3), this.convertTTFUnit2PDFUnit(this.fontBBox4)};
        return fbb;
    }

    public int getLowerCaseAscent() {
        return this.convertTTFUnit2PDFUnit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.convertTTFUnit2PDFUnit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return 0;
    }

    public int[] getWidths() {
        int[] wx = new int[this.mtxTab.length];
        for (int i = 0; i < wx.length; ++i) {
            wx[i] = this.convertTTFUnit2PDFUnit(this.mtxTab[i].getWx());
        }
        return wx;
    }

    public int getCharWidth(int idx) {
        return this.convertTTFUnit2PDFUnit(this.ansiWidth[idx]);
    }

    public Map<Integer, Map<Integer, Integer>> getKerning() {
        return this.kerningTab;
    }

    public Map<Integer, Map<Integer, Integer>> getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public boolean isCFF() {
        return this.isCFF;
    }

    protected void readDirTabs() throws IOException {
        int sfntVersion = this.fontFile.readTTFLong();
        switch (sfntVersion) {
            case 65536: {
                break;
            }
            case 0x4F54544F: {
                this.isCFF = true;
                break;
            }
            case 1953658213: {
                break;
            }
            case 1954115633: {
                break;
            }
        }
        int ntabs = this.fontFile.readTTFUShort();
        this.fontFile.skip(6L);
        this.dirTabs = new HashMap<TTFTableName, TTFDirTabEntry>();
        TTFDirTabEntry[] pd = new TTFDirTabEntry[ntabs];
        for (int i = 0; i < ntabs; ++i) {
            pd[i] = new TTFDirTabEntry();
            String tableName = pd[i].read(this.fontFile);
            this.dirTabs.put(TTFTableName.getValue(tableName), pd[i]);
        }
        this.dirTabs.put(TTFTableName.TABLE_DIRECTORY, new TTFDirTabEntry(0L, this.fontFile.getCurrentPos()));
    }

    protected void readFontHeader() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.HEAD, 16L);
        int flags = this.fontFile.readTTFUShort();
        this.upem = this.fontFile.readTTFUShort();
        this.fontFile.skip(16L);
        this.fontBBox1 = this.fontFile.readTTFShort();
        this.fontBBox2 = this.fontFile.readTTFShort();
        this.fontBBox3 = this.fontFile.readTTFShort();
        this.fontBBox4 = this.fontFile.readTTFShort();
        this.fontFile.skip(6L);
        this.locaFormat = this.fontFile.readTTFShort();
    }

    protected void getNumGlyphs() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.MAXP, 4L);
        this.numberOfGlyphs = this.fontFile.readTTFUShort();
    }

    protected void readHorizontalHeader() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.HHEA, 4L);
        this.hheaAscender = this.fontFile.readTTFShort();
        this.hheaDescender = this.fontFile.readTTFShort();
        this.fontFile.skip(26L);
        this.nhmtx = this.fontFile.readTTFUShort();
    }

    protected void readHorizontalMetrics() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.HMTX, 0L);
        int mtxSize = Math.max(this.numberOfGlyphs, this.nhmtx);
        this.mtxTab = new TTFMtxEntry[mtxSize];
        for (int i = 0; i < this.nhmtx; ++i) {
            this.mtxTab[i].setWx(this.fontFile.readTTFUShort());
            this.mtxTab[i].setLsb(this.fontFile.readTTFUShort());
        }
        if (this.nhmtx < mtxSize) {
            int lastWidth = this.mtxTab[this.nhmtx - 1].getWx();
            for (int i = this.nhmtx; i < mtxSize; ++i) {
                this.mtxTab[i].setWx(lastWidth);
                this.mtxTab[i].setLsb(this.fontFile.readTTFUShort());
            }
        }
    }

    private void readPostScript() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.POST, 0L);
        int postFormat = this.fontFile.readTTFLong();
        this.italicAngle = this.fontFile.readTTFULong();
        this.underlinePosition = this.fontFile.readTTFShort();
        this.underlineThickness = this.fontFile.readTTFShort();
        this.isFixedPitch = this.fontFile.readTTFULong();
        this.fontFile.skip(16L);
        switch (postFormat) {
            case 65536: {
                this.postScriptVersion = PostScriptVersion.V1;
                for (int i = 0; i < MAC_GLYPH_ORDERING.length; ++i) {
                    this.mtxTab[i].setName(MAC_GLYPH_ORDERING[i]);
                }
                break;
            }
            case 131072: {
                int i;
                this.postScriptVersion = PostScriptVersion.V2;
                int numGlyphStrings = 0;
                int l = this.fontFile.readTTFUShort();
                for (int i2 = 0; i2 < l; ++i2) {
                    this.mtxTab[i2].setIndex(this.fontFile.readTTFUShort());
                    if (this.mtxTab[i2].getIndex() <= 257) continue;
                    ++numGlyphStrings;
                }
                String[] psGlyphsBuffer = new String[numGlyphStrings];
                for (i = 0; i < psGlyphsBuffer.length; ++i) {
                    psGlyphsBuffer[i] = this.fontFile.readTTFString(this.fontFile.readTTFUByte());
                }
                for (i = 0; i < l; ++i) {
                    if (this.mtxTab[i].getIndex() < MAC_GLYPH_ORDERING.length) {
                        this.mtxTab[i].setName(MAC_GLYPH_ORDERING[this.mtxTab[i].getIndex()]);
                        continue;
                    }
                    if (this.mtxTab[i].isIndexReserved()) continue;
                    int k = this.mtxTab[i].getIndex() - MAC_GLYPH_ORDERING.length;
                    this.mtxTab[i].setName(psGlyphsBuffer[k]);
                }
                break;
            }
            case 196608: {
                this.postScriptVersion = PostScriptVersion.V3;
                break;
            }
            default: {
                this.postScriptVersion = PostScriptVersion.UNKNOWN;
            }
        }
    }

    private void readOS2() throws IOException {
        TTFDirTabEntry os2Entry = this.dirTabs.get(TTFTableName.OS2);
        if (os2Entry != null) {
            this.seekTab(this.fontFile, TTFTableName.OS2, 0L);
            int version = this.fontFile.readTTFUShort();
            this.fontFile.skip(2L);
            this.usWeightClass = this.fontFile.readTTFUShort();
            this.fontFile.skip(2L);
            int fsType = this.fontFile.readTTFUShort();
            this.isEmbeddable = fsType != 2;
            this.fontFile.skip(22L);
            this.fontFile.skip(10L);
            this.fontFile.skip(16L);
            this.fontFile.skip(4L);
            this.fontFile.skip(6L);
            this.os2Ascender = this.fontFile.readTTFShort();
            this.os2Descender = this.fontFile.readTTFShort();
            int v = this.fontFile.readTTFShort();
            v = this.fontFile.readTTFUShort();
            v = this.fontFile.readTTFUShort();
            if (os2Entry.getLength() >= 90L) {
                this.fontFile.skip(8L);
                this.os2xHeight = this.fontFile.readTTFShort();
                this.os2CapHeight = this.fontFile.readTTFShort();
            }
        } else {
            this.isEmbeddable = true;
        }
    }

    protected final void readIndexToLocation() throws IOException {
        if (!this.seekTab(this.fontFile, TTFTableName.LOCA, 0L)) {
            throw new IOException("'loca' table not found, happens when the font file doesn't contain TrueType outlines (trying to read an OpenType CFF font maybe?)");
        }
        for (int i = 0; i < this.numberOfGlyphs; ++i) {
            this.mtxTab[i].setOffset(this.locaFormat == 1 ? this.fontFile.readTTFULong() : (long)(this.fontFile.readTTFUShort() << 1));
        }
        this.lastLoca = this.locaFormat == 1 ? this.fontFile.readTTFULong() : (long)(this.fontFile.readTTFUShort() << 1);
    }

    private void readGlyf() throws IOException {
        TTFDirTabEntry dirTab = this.dirTabs.get(TTFTableName.GLYF);
        if (dirTab == null) {
            throw new IOException("glyf table not found, cannot continue");
        }
        for (int i = 0; i < this.numberOfGlyphs - 1; ++i) {
            if (this.mtxTab[i].getOffset() != this.mtxTab[i + 1].getOffset()) {
                this.fontFile.seekSet(dirTab.getOffset() + this.mtxTab[i].getOffset());
                this.fontFile.skip(2L);
                int[] bbox = new int[]{this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort()};
                this.mtxTab[i].setBoundingBox(bbox);
                continue;
            }
            this.mtxTab[i].setBoundingBox(this.mtxTab[0].getBoundingBox());
        }
        long n = this.dirTabs.get(TTFTableName.GLYF).getOffset();
        for (int i = 0; i < this.numberOfGlyphs; ++i) {
            if (i + 1 >= this.mtxTab.length || this.mtxTab[i].getOffset() != this.mtxTab[i + 1].getOffset()) {
                this.fontFile.seekSet(n + this.mtxTab[i].getOffset());
                this.fontFile.skip(2L);
                int[] bbox = new int[]{this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort()};
                this.mtxTab[i].setBoundingBox(bbox);
                continue;
            }
            int bbox0 = this.mtxTab[0].getBoundingBox()[0];
            int[] bbox = new int[]{bbox0, bbox0, bbox0, bbox0};
            this.mtxTab[i].setBoundingBox(bbox);
        }
    }

    private void readName() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.NAME, 2L);
        int i = this.fontFile.getCurrentPos();
        int n = this.fontFile.readTTFUShort();
        int j = this.fontFile.readTTFUShort() + i - 2;
        i += 4;
        while (n-- > 0) {
            this.fontFile.seekSet(i);
            int platformID = this.fontFile.readTTFUShort();
            int encodingID = this.fontFile.readTTFUShort();
            int languageID = this.fontFile.readTTFUShort();
            int k = this.fontFile.readTTFUShort();
            int l = this.fontFile.readTTFUShort();
            if (!(platformID != 1 && platformID != 3 || encodingID != 0 && encodingID != 1)) {
                this.fontFile.seekSet(j + this.fontFile.readTTFUShort());
                String txt = platformID == 3 ? this.fontFile.readTTFString(l, encodingID) : this.fontFile.readTTFString(l);
                switch (k) {
                    case 0: {
                        if (this.notice.length() != 0) break;
                        this.notice = txt;
                        break;
                    }
                    case 1: 
                    case 16: {
                        this.familyNames.add(txt);
                        break;
                    }
                    case 2: {
                        if (this.subFamilyName.length() != 0) break;
                        this.subFamilyName = txt;
                        break;
                    }
                    case 4: {
                        if (this.fullName.length() != 0 && (platformID != 3 || languageID != 1033)) break;
                        this.fullName = txt;
                        break;
                    }
                    case 6: {
                        if (this.postScriptName.length() != 0) break;
                        this.postScriptName = txt;
                        break;
                    }
                }
            }
            i += 12;
        }
    }

    private boolean readPCLT() throws IOException {
        TTFDirTabEntry dirTab = this.dirTabs.get(TTFTableName.PCLT);
        if (dirTab != null) {
            this.fontFile.seekSet(dirTab.getOffset() + 4L + 4L + 2L);
            this.xHeight = this.fontFile.readTTFUShort();
            this.fontFile.skip(4L);
            this.capHeight = this.fontFile.readTTFUShort();
            this.fontFile.skip(34L);
            int serifStyle = this.fontFile.readTTFUByte();
            serifStyle >>= 6;
            this.hasSerifs = (serifStyle &= 3) != 1;
            return true;
        }
        return false;
    }

    private void determineAscDesc() {
        int hheaBoxHeight = this.hheaAscender - this.hheaDescender;
        int os2BoxHeight = this.os2Ascender - this.os2Descender;
        if (this.os2Ascender > 0 && os2BoxHeight <= this.upem) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else if (this.hheaAscender > 0 && hheaBoxHeight <= this.upem) {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        } else if (this.os2Ascender > 0) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        }
    }

    private void guessVerticalMetricsFromGlyphBBox() {
        int localCapHeight = 0;
        int localXHeight = 0;
        int localAscender = 0;
        int localDescender = 0;
        for (int i = 0; i < this.mtxTab.length; ++i) {
            if ("H".equals(this.mtxTab[i].getName())) {
                localCapHeight = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if ("x".equals(this.mtxTab[i].getName())) {
                localXHeight = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if ("d".equals(this.mtxTab[i].getName())) {
                localAscender = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if ("p".equals(this.mtxTab[i].getName())) {
                localDescender = this.mtxTab[i].getBoundingBox()[1];
                continue;
            }
            List unicodeIndex = this.mtxTab[i].getUnicodeIndex();
            if (unicodeIndex.size() <= 0) continue;
            char ch = (char)((Integer)unicodeIndex.get(0)).intValue();
            if (ch == 'H') {
                localCapHeight = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if (ch == 'x') {
                localXHeight = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if (ch == 'd') {
                localAscender = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if (ch != 'p') continue;
            localDescender = this.mtxTab[i].getBoundingBox()[1];
        }
        if (this.ascender - this.descender > this.upem) {
            this.ascender = localAscender;
            this.descender = localDescender;
        }
        if (this.capHeight == 0) {
            this.capHeight = localCapHeight;
            if (this.capHeight == 0) {
                this.capHeight = this.os2CapHeight;
            }
            if (this.capHeight == 0) {
                // empty if block
            }
        }
        if (this.xHeight == 0) {
            this.xHeight = localXHeight;
            if (this.xHeight == 0) {
                this.xHeight = this.os2xHeight;
            }
            if (this.xHeight == 0) {
                // empty if block
            }
        }
    }

    private void readKerning() throws IOException {
        this.kerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        this.ansiKerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        TTFDirTabEntry dirTab = this.dirTabs.get(TTFTableName.KERN);
        if (dirTab != null) {
            this.seekTab(this.fontFile, TTFTableName.KERN, 2L);
            for (int n = this.fontFile.readTTFUShort(); n > 0; --n) {
                this.fontFile.skip(4L);
                int k = this.fontFile.readTTFUShort();
                if ((k & 1) == 0 || (k & 2) != 0 || (k & 4) != 0) {
                    return;
                }
                if (k >> 8 != 0) continue;
                k = this.fontFile.readTTFUShort();
                this.fontFile.skip(6L);
                while (k-- > 0) {
                    int i = this.fontFile.readTTFUShort();
                    int j = this.fontFile.readTTFUShort();
                    short kpx = this.fontFile.readTTFShort();
                    if (kpx == 0) continue;
                    Integer iObj = this.glyphToUnicode(i);
                    Integer u2 = this.glyphToUnicode(j);
                    if (iObj == null || u2 == null) continue;
                    Map<Integer, Integer> adjTab = this.kerningTab.get(iObj);
                    if (adjTab == null) {
                        adjTab = new HashMap<Integer, Integer>();
                    }
                    adjTab.put(u2, new Integer(this.convertTTFUnit2PDFUnit(kpx)));
                    this.kerningTab.put(iObj, adjTab);
                }
            }
            for (Integer unicodeKey1 : this.kerningTab.keySet()) {
                Integer cidKey1 = this.unicodeToGlyph(unicodeKey1);
                HashMap<Integer, Integer> akpx = new HashMap<Integer, Integer>();
                Map<Integer, Integer> ckpx = this.kerningTab.get(unicodeKey1);
                for (Integer unicodeKey2 : ckpx.keySet()) {
                    Integer cidKey2 = this.unicodeToGlyph(unicodeKey2);
                    Integer kern = ckpx.get(unicodeKey2);
                    ListIterator uniMap = this.mtxTab[cidKey2].getUnicodeIndex().listIterator();
                    while (uniMap.hasNext()) {
                        Integer unicodeKey = (Integer)uniMap.next();
                        Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                        for (int u = 0; u < ansiKeys.length; ++u) {
                            akpx.put(ansiKeys[u], kern);
                        }
                    }
                }
                if (akpx.size() <= 0) continue;
                ListIterator uniMap = this.mtxTab[cidKey1].getUnicodeIndex().listIterator();
                while (uniMap.hasNext()) {
                    Integer unicodeKey = (Integer)uniMap.next();
                    Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                    for (int u = 0; u < ansiKeys.length; ++u) {
                        this.ansiKerningTab.put(ansiKeys[u], akpx);
                    }
                }
            }
        }
    }

    public void stream(TTFOutputStream ttfOut) throws IOException {
        SortedSet<Map.Entry<TTFTableName, TTFDirTabEntry>> sortedDirTabs = this.sortDirTabMap(this.dirTabs);
        byte[] file = this.fontFile.getAllBytes();
        TTFTableOutputStream tableOut = ttfOut.getTableOutputStream();
        TTFGlyphOutputStream glyphOut = ttfOut.getGlyphOutputStream();
        ttfOut.startFontStream();
        for (Map.Entry entry : sortedDirTabs) {
            int offset = (int)((TTFDirTabEntry)entry.getValue()).getOffset();
            int paddedLength = (int)((TTFDirTabEntry)entry.getValue()).getLength();
            paddedLength += this.getPadSize(offset + paddedLength);
            if (((TTFTableName)entry.getKey()).equals(TTFTableName.GLYF)) {
                this.streamGlyf(glyphOut, file, offset, paddedLength);
                continue;
            }
            tableOut.streamTable(file, offset, paddedLength);
        }
        ttfOut.endFontStream();
    }

    private void streamGlyf(TTFGlyphOutputStream glyphOut, byte[] fontFile, int tableOffset, int tableLength) throws IOException {
        int glyphStart = 0;
        int glyphEnd = 0;
        glyphOut.startGlyphStream();
        for (int i = 0; i < this.mtxTab.length - 1; ++i) {
            glyphStart = (int)this.mtxTab[i].getOffset() + tableOffset;
            glyphEnd = (int)this.mtxTab[i + 1].getOffset() + tableOffset;
            glyphOut.streamGlyph(fontFile, glyphStart, glyphEnd - glyphStart);
        }
        glyphOut.streamGlyph(fontFile, glyphEnd, tableOffset + tableLength - glyphEnd);
        glyphOut.endGlyphStream();
    }

    SortedSet<Map.Entry<TTFTableName, TTFDirTabEntry>> sortDirTabMap(Map<TTFTableName, TTFDirTabEntry> directoryTabs) {
        TreeSet<Map.Entry<TTFTableName, TTFDirTabEntry>> sortedSet = new TreeSet<Map.Entry<TTFTableName, TTFDirTabEntry>>(new Comparator<Map.Entry<TTFTableName, TTFDirTabEntry>>(){

            @Override
            public int compare(Map.Entry<TTFTableName, TTFDirTabEntry> o1, Map.Entry<TTFTableName, TTFDirTabEntry> o2) {
                return (int)(o1.getValue().getOffset() - o2.getValue().getOffset());
            }
        });
        sortedSet.addAll(directoryTabs.entrySet());
        return sortedSet;
    }

    public List<CMapSegment> getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(String name) throws IOException {
        String tag = this.fontFile.readTTFString(4);
        if ("ttcf".equals(tag)) {
            this.fontFile.skip(4L);
            int numDirectories = (int)this.fontFile.readTTFULong();
            long[] dirOffsets = new long[numDirectories];
            for (int i = 0; i < numDirectories; ++i) {
                dirOffsets[i] = this.fontFile.readTTFULong();
            }
            boolean found = false;
            long dirTabOffset = 0L;
            for (int i = 0; i < numDirectories; ++i) {
                this.fontFile.seekSet(dirOffsets[i]);
                this.readDirTabs();
                this.readName();
                if (this.fullName.equals(name)) {
                    found = true;
                    dirTabOffset = dirOffsets[i];
                }
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            this.fontFile.seekSet(dirTabOffset);
            return found;
        }
        this.fontFile.seekSet(0L);
        return true;
    }

    public final List<String> getTTCnames(FontFileReader in) throws IOException {
        this.fontFile = in;
        ArrayList<String> fontNames = new ArrayList<String>();
        String tag = in.readTTFString(4);
        if ("ttcf".equals(tag)) {
            int i;
            in.skip(4L);
            int numDirectories = (int)in.readTTFULong();
            long[] dirOffsets = new long[numDirectories];
            for (i = 0; i < numDirectories; ++i) {
                dirOffsets[i] = in.readTTFULong();
            }
            for (i = 0; i < numDirectories; ++i) {
                in.seekSet(dirOffsets[i]);
                this.readDirTabs();
                this.readName();
                fontNames.add(this.fullName);
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            in.seekSet(0L);
            return fontNames;
        }
        return null;
    }

    private Integer[] unicodeToWinAnsi(int unicode) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 32; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            if (unicode != Glyphs.WINANSI_ENCODING[i]) continue;
            ret.add(new Integer(i));
        }
        return ret.toArray(new Integer[0]);
    }

    public void printStuff() {
        System.out.println("Font name:   " + this.postScriptName);
        System.out.println("Full name:   " + this.fullName);
        System.out.println("Family name: " + this.familyNames);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:      " + this.notice);
        System.out.println("xHeight:     " + this.convertTTFUnit2PDFUnit(this.xHeight));
        System.out.println("capheight:   " + this.convertTTFUnit2PDFUnit(this.capHeight));
        int italic = (int)(this.italicAngle >> 16);
        System.out.println("Italic:      " + italic);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.convertTTFUnit2PDFUnit(this.ascender));
        System.out.println("Descender:   " + this.convertTTFUnit2PDFUnit(this.descender));
        System.out.println("FontBBox:    [" + this.convertTTFUnit2PDFUnit(this.fontBBox1) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox2) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox3) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox4) + "]");
    }

    private String formatUnitsForDebug(int units) {
        return units + " -> " + this.convertTTFUnit2PDFUnit(units) + " internal units";
    }

    private Integer glyphToUnicode(int glyphIndex) {
        return this.glyphToUnicodeMap.get(new Integer(glyphIndex));
    }

    private Integer unicodeToGlyph(int unicodeIndex) throws IOException {
        Integer result = this.unicodeToGlyphMap.get(new Integer(unicodeIndex));
        if (result == null) {
            throw new IOException("Glyph index not found for unicode value " + unicodeIndex);
        }
        return result;
    }

    String getGlyphName(int glyphIndex) {
        return this.mtxTab[glyphIndex].getName();
    }

    public boolean hasAdvancedTable() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.hasAdvancedTable();
        }
        return false;
    }

    public GlyphDefinitionTable getGDEF() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGDEF();
        }
        return null;
    }

    public GlyphSubstitutionTable getGSUB() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGSUB();
        }
        return null;
    }

    public GlyphPositioningTable getGPOS() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGPOS();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            boolean useKerning = true;
            boolean useAdvanced = true;
            TTFFile ttfFile = new TTFFile(useKerning, useAdvanced);
            FontFileReader reader = new FontFileReader(args[0]);
            String name = null;
            if (args.length >= 2) {
                name = args[1];
            }
            ttfFile.readFont(reader, name);
            ttfFile.printStuff();
        }
        catch (IOException ioe) {
            System.err.println("Problem reading font: " + ioe.toString());
            ioe.printStackTrace(System.err);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostScriptVersion {
        V1,
        V2,
        V3,
        UNKNOWN;

    }

    final class UnicodeMapping
    implements Comparable {
        private final int unicodeIndex;
        private final int glyphIndex;

        UnicodeMapping(int glyphIndex, int unicodeIndex) {
            this.unicodeIndex = unicodeIndex;
            this.glyphIndex = glyphIndex;
            TTFFile.this.glyphToUnicodeMap.put(new Integer(glyphIndex), new Integer(unicodeIndex));
            TTFFile.this.unicodeToGlyphMap.put(new Integer(unicodeIndex), new Integer(glyphIndex));
        }

        public int getGlyphIndex() {
            return this.glyphIndex;
        }

        public int getUnicodeIndex() {
            return this.unicodeIndex;
        }

        public int hashCode() {
            int hc = this.unicodeIndex;
            hc = 19 * hc + (hc ^ this.glyphIndex);
            return hc;
        }

        public boolean equals(Object o) {
            if (o instanceof UnicodeMapping) {
                UnicodeMapping m = (UnicodeMapping)o;
                if (this.unicodeIndex != m.unicodeIndex) {
                    return false;
                }
                return this.glyphIndex == m.glyphIndex;
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof UnicodeMapping) {
                UnicodeMapping m = (UnicodeMapping)o;
                if (this.unicodeIndex > m.unicodeIndex) {
                    return 1;
                }
                if (this.unicodeIndex < m.unicodeIndex) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }
}

