/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.StdIn;
import edu.princeton.cs.algs4.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Queue<Item>
implements Iterable<Item> {
    private Node<Item> first = null;
    private Node<Item> last = null;
    private int n = 0;

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.n;
    }

    public Item peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        return (Item)((Node)this.first).item;
    }

    public void enqueue(Item item) {
        Node<Item> oldlast = this.last;
        this.last = new Node();
        ((Node)this.last).item = item;
        ((Node)this.last).next = null;
        if (this.isEmpty()) {
            this.first = this.last;
        } else {
            ((Node)oldlast).next = (Node)this.last;
        }
        ++this.n;
    }

    public Item dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        Object item = ((Node)this.first).item;
        this.first = ((Node)this.first).next;
        --this.n;
        if (this.isEmpty()) {
            this.last = null;
        }
        return (Item)item;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Item item : this) {
            s.append(item);
            s.append(' ');
        }
        return s.toString();
    }

    @Override
    public Iterator<Item> iterator() {
        return new ListIterator<Item>(this.first);
    }

    public static void main(String[] args) {
        Queue<String> queue = new Queue<String>();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) {
                queue.enqueue(item);
                continue;
            }
            if (queue.isEmpty()) continue;
            StdOut.print((String)queue.dequeue() + " ");
        }
        StdOut.println("(" + queue.size() + " left on queue)");
    }

    private class ListIterator<Item>
    implements Iterator<Item> {
        private Node<Item> current;

        public ListIterator(Node<Item> first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = ((Node)this.current).item;
            this.current = ((Node)this.current).next;
            return (Item)item;
        }
    }

    private static class Node<Item> {
        private Item item;
        private Node<Item> next;

        private Node() {
        }
    }
}

