/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class Paraboloid
extends SurfaceParametric {
    private RealParamAnimateable xRadius = new RealParamAnimateable("vmm3d.surface.parametric.Paraboloid.xRadius", 1.0, 1.0, 1.5);
    private RealParamAnimateable yRadius = new RealParamAnimateable("vmm3d.surface.parametric.Paraboloid.yRadius", 1.0, 1.5, 0.5);
    private RealParamAnimateable height = new RealParamAnimateable("vmm3d.surface.parametric.Paraboloid.height", 2.5, 2.5, 2.5);

    public Paraboloid() {
        this.umin.reset(0.0);
        this.umax.reset("2 * pi");
        this.vmin.reset(0.0);
        this.vmax.reset(1.0);
        this.addParameter(this.height);
        this.addParameter(this.yRadius);
        this.addParameter(this.xRadius);
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.setDefaultViewpoint(new Vector3D(20.0, 3.0, 7.0));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double x = this.xRadius.getValue() * v * Math.cos(u);
        double y = this.yRadius.getValue() * v * Math.sin(u);
        double z = this.height.getValue() * v * v - this.height.getValue() / 2.0;
        return new Vector3D(x, y, z);
    }
}

