/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.event.ActionEvent;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Complex;
import vmm3d.core.I18n;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.SurfaceView;
import vmm3d.surface.parametric.SurfaceParametric;

public class BoyBryantKusner
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0.5", "0.5", "0.5");

    public BoyBryantKusner() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(32);
        this.umin.reset(-1.45, -0.2, -1.449);
        this.umax.reset(0.0);
        this.vmin.reset(0.0);
        this.vmax.reset("2*pi");
        this.setDefaultOrientation(2);
        this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 17.3));
        this.setDefaultWindow(-2.1, 2.1, -2.1, 2.1);
        this.addParameter(this.aa);
    }

    @Override
    public View getDefaultView() {
        SurfaceView view = (SurfaceView)super.getDefaultView();
        return view;
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("common.AlternativeMorph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(1);
                animation.setUseFilmstrip(BoyBryantKusner.this.getUseFilmstripForMorphing());
                animation.setFrames(BoyBryantKusner.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                animation.addWithCustomValue(BoyBryantKusner.this.uPatchCount, 24);
                animation.addWithCustomValue(BoyBryantKusner.this.vPatchCount, 6);
                animation.addWithCustomValue(BoyBryantKusner.this.umin, -1.45);
                animation.addWithCustomValue(BoyBryantKusner.this.umax, 1.45);
                animation.addWithCustomLimits(BoyBryantKusner.this.vmin, 0.0, 5.583185307179586);
                animation.addWithCustomLimits(BoyBryantKusner.this.vmax, 0.7, Math.PI * 2);
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        Complex One_C = new Complex(1.0, 0.0);
        Complex I_C = new Complex(0.0, 1.0);
        double uu = Math.exp(Math.tan(u));
        Complex z = new Complex(uu * Math.cos(v), uu * Math.sin(v));
        Complex zSquare = new Complex(z.times(z));
        Complex zCube = new Complex(z.times(zSquare));
        Complex OneOverZsquare = new Complex(One_C.dividedBy(zSquare));
        Complex OneOverZCube = new Complex(One_C.dividedBy(zCube));
        Complex zSquarePlusOneOverZsquare = new Complex(zSquare.plus(OneOverZsquare));
        Complex zSquareMinusOneOverZsquare = new Complex(zSquare.minus(OneOverZsquare));
        Complex zCubePlusOneOverZCube = new Complex(zCube.plus(OneOverZCube));
        Complex zCubeMinusOneOverZCube = new Complex(zCube.minus(OneOverZCube));
        Complex multiplier = new Complex(One_C.dividedBy(zCubeMinusOneOverZCube.plus(Math.sqrt(5.0))));
        Complex Wx = new Complex(zSquareMinusOneOverZsquare.times(I_C).times(multiplier));
        Complex Wy = new Complex(multiplier.times(zSquarePlusOneOverZsquare));
        Complex Wz = new Complex(zCubePlusOneOverZCube.times(I_C).times(0.6666666666666666));
        Wz = multiplier.times(Wz);
        double x = Wx.re;
        double y = Wy.re;
        double zz = Wz.re + this.aa.getValue();
        double denom = 1.0 / Math.max(1.0E-5, x * x + y * y + zz * zz);
        return new Vector3D(denom * x, denom * y, denom * zz);
    }
}

