/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.implicit.SurfaceImplicit;

public class DupinCyclides
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm3d.surface.implicit.DupinCyclides.a", 2.0, 2.0, 2.0);
    private RealParamAnimateable b = new RealParamAnimateable("vmm3d.surface.implicit.DupinCyclides.b", 1.8, 1.8, 1.8);
    private RealParamAnimateable d = new RealParamAnimateable("vmm3d.surface.implicit.DupinCyclides.d", 1.0, 0.7, 2.5);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double dd = this.d.getValue();
        double bb = this.b.getValue();
        double aa = this.a.getValue();
        double xsqr = DupinCyclides.sqr(x);
        double ysqr = DupinCyclides.sqr(y);
        double zsqr = DupinCyclides.sqr(z);
        if (Math.abs(bb) > Math.abs(aa)) {
            bb = Math.signum(bb) * Math.abs(aa);
        }
        double height = DupinCyclides.sqr(xsqr + ysqr + zsqr - dd * dd + bb * bb) - 4.0 * DupinCyclides.sqr(aa * x + Math.sqrt(aa * aa - bb * bb) * dd) - 4.0 * bb * bb * ysqr;
        return height;
    }

    public DupinCyclides() {
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.setDefaultViewpoint(new Vector3D(0.0, 10.0, 10.0));
        this.searchRadius.reset(4.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(0.0, 0.0, 0.0);
        this.setFramesForMorphing(11);
    }
}

