/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.spacecurve.parametric;

import vmm3d.core3D.Vector3D;
import vmm3d.spacecurve.parametric.SpaceCurveParametric;

public class SquareKnot
extends SpaceCurveParametric {
    public SquareKnot() {
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.tResolution.setValueAndDefault(300);
        this.setDefaultViewpoint(new Vector3D(28.0, -150.0, 0.0));
        this.setDefaultWindow(-2.0, 2.0, -1.5, 1.5);
        this.tubeSize.setValueAndDefault(0.15);
    }

    @Override
    protected Vector3D value(double t) {
        return new Vector3D((-22.0 * Math.cos(t) - 128.0 * Math.sin(t) - 44.0 * Math.cos(3.0 * t) - 78.0 * Math.sin(3.0 * t)) / 100.0, (11.0 * Math.cos(t) - 43.0 * Math.sin(3.0 * t) + 34.0 * Math.cos(5.0 * t) - 39.0 * Math.sin(5.0 * t)) / 100.0, (70.0 * Math.cos(3.0 * t) - 40.0 * Math.sin(3.0 * t) + 18.0 * Math.cos(5.0 * t) - 9.0 * Math.sin(5.0 * t)) / 100.0);
    }

    @Override
    protected Vector3D deriv1(double t) {
        return new Vector3D((22.0 * Math.sin(t) - 128.0 * Math.cos(t) + 44.0 * Math.sin(3.0 * t) * 3.0 - 78.0 * Math.cos(3.0 * t) * 3.0) / 100.0, (-11.0 * Math.sin(t) - 43.0 * Math.cos(3.0 * t) * 3.0 - 34.0 * Math.sin(5.0 * t) * 5.0 - 39.0 * Math.cos(5.0 * t) * 5.0) / 100.0, (-70.0 * Math.sin(3.0 * t) * 3.0 - 40.0 * Math.cos(3.0 * t) * 3.0 - 18.0 * Math.sin(5.0 * t) * 5.0 - 9.0 * Math.cos(5.0 * t) * 5.0) / 100.0);
    }

    @Override
    protected Vector3D deriv2(double t) {
        return new Vector3D((22.0 * Math.cos(t) + 128.0 * Math.sin(t) + 44.0 * Math.cos(3.0 * t) * 3.0 * 3.0 + 78.0 * Math.sin(3.0 * t) * 3.0 * 3.0) / 100.0, (-11.0 * Math.cos(t) + 43.0 * Math.sin(3.0 * t) * 9.0 - 34.0 * Math.cos(5.0 * t) * 25.0 + 39.0 * Math.sin(5.0 * t) * 25.0) / 100.0, (-70.0 * Math.cos(3.0 * t) * 3.0 * 3.0 + 40.0 * Math.sin(3.0 * t) * 3.0 * 3.0 - 18.0 * Math.cos(5.0 * t) * 25.0 + 9.0 * Math.sin(5.0 * t) * 25.0) / 100.0);
    }
}

