/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve;

import java.awt.geom.Point2D;
import java.util.Random;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Exhibit;
import vmm3d.core.Transform;
import vmm3d.core.View;

public abstract class PlaneCurve
extends Exhibit {
    protected Point2D[] points;
    protected Point2D[] randomSquare;
    protected Point2D[] movingSquare;

    protected abstract void makePoints();

    public int getPointCount() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length;
    }

    public Point2D getPoint(int index) {
        return this.points[index];
    }

    @Override
    protected void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
        if (exhibitNeedsRedraw || this.points == null) {
            this.makePoints();
        }
    }

    @Override
    protected void doDraw(VectorGraphics g, View view, Transform transform) {
        view.drawCurve(this.points);
    }

    public Point2D[] fillRandomSquare(int numPoints) {
        Random random = new Random(42L);
        Point2D[] randSquare = new Point2D[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            randSquare[i] = new Point2D.Double(2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0);
        }
        return randSquare;
    }

    public Point2D[] initializeMovingSquare(int numPoints) {
        this.movingSquare = new Point2D[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            this.movingSquare[i] = new Point2D.Double();
        }
        return this.movingSquare;
    }

    protected Point2D[] moveSquare(int numPoints, double xm, double ym, double ex, double ey, double ll) {
        for (int i = 0; i < numPoints; ++i) {
            double x = ll * this.randomSquare[i].getX();
            double y = ll * this.randomSquare[i].getY();
            this.movingSquare[i].setLocation(xm + x * ex - y * ey, ym + x * ey + y * ex);
        }
        return this.movingSquare;
    }
}

