/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.ode.secondorder3D;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.ode.secondorder3D.ChargedParticles;

public class MagneticDipole
extends ChargedParticles {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.0);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 0.0, 0.0, 1.4142);
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", 1.4142, 1.4142, 0.0);

    public MagneticDipole() {
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.initialDataDefault = new double[]{-0.7, -0.7, 0.0, 0.0, 0.0, -0.2, 0.02, 100.0};
        this.setDefaultWindow(-1.0, 1.0, -1.0, 1.0);
        this.setDefaultViewpoint(new Vector3D(11.6, -8.1, 10.0));
    }

    @Override
    protected void magneticField(double x, double y, double z, Vector3D answer) {
        double a = this.aa.getValue();
        double b = this.bb.getValue();
        double c = this.cc.getValue();
        double rsquare = x * x + y * y + z * z;
        double rcube = rsquare * Math.sqrt(rsquare);
        double eDOTp = a * x + b * y + c * z;
        answer.x = (3.0 * eDOTp * x / rsquare - a) / rcube;
        answer.y = (3.0 * eDOTp * y / rsquare - b) / rcube;
        answer.z = (3.0 * eDOTp * z / rsquare - c) / rcube;
    }
}

