/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.fractals;

import vmm3d.core.Complex;
import vmm3d.fractals.RepeatedSegmentFractal;

public class Koch
extends RepeatedSegmentFractal {
    @Override
    protected Complex[] computeNextLevel(Complex[] kochCurve, int computedLevel) {
        Complex[] newKochCurve;
        double sqrt3Over6 = Math.sqrt(3.0) / 6.0;
        if (computedLevel == 0) {
            newKochCurve = new Complex[]{new Complex(-2.0 * sqrt3Over6, 0.0), new Complex(sqrt3Over6, 0.5), new Complex(sqrt3Over6, -0.5), newKochCurve[0]};
        } else {
            newKochCurve = new Complex[4 * kochCurve.length - 3];
            double aa = Math.min(0.5, Math.max(this.fractality.getValue(), 0.25));
            double aaVertical = Math.sqrt(aa - 0.25) / aa;
            Complex aaVerticalI = new Complex(0.0, aaVertical);
            int ct = 0;
            for (int i = 0; i < kochCurve.length - 1; ++i) {
                Complex p1 = kochCurve[i];
                Complex p2 = kochCurve[i + 1];
                Complex midpoint = p1.plus(p2);
                midpoint.re /= 2.0;
                midpoint.im /= 2.0;
                Complex theDirection = p2.minus(p1).times(aa);
                newKochCurve[ct++] = p1;
                newKochCurve[ct++] = p1.plus(theDirection);
                newKochCurve[ct++] = midpoint.plus(aaVerticalI.times(theDirection));
                newKochCurve[ct++] = p2.minus(theDirection);
            }
            newKochCurve[ct] = kochCurve[kochCurve.length - 1];
        }
        return newKochCurve;
    }
}

