/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vmm3d.core.Util;

public class Vector3D {
    public double x;
    public double y;
    public double z;
    public static final Vector3D ORIGIN = new Vector3D(0.0, 0.0, 0.0);
    public static final Vector3D UNIT_X = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D UNIT_Y = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D UNIT_Z = new Vector3D(0.0, 0.0, 1.0);

    public Vector3D() {
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(Vector3D v) {
        if (v == null) {
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
        } else {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(Vector3D.class)) {
            return false;
        }
        Vector3D v = (Vector3D)obj;
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        double lengthRecip = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (Double.isNaN(lengthRecip) || Double.isInfinite(lengthRecip)) {
            this.z = Double.NaN;
            this.y = Double.NaN;
            this.x = Double.NaN;
        } else {
            this.x *= lengthRecip;
            this.y *= lengthRecip;
            this.z *= lengthRecip;
        }
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Vector3D normalized() {
        Vector3D v = new Vector3D(this.x, this.y, this.z);
        v.normalize();
        return v;
    }

    public Vector3D negated() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D plus(Vector3D v) {
        return new Vector3D(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3D linComb(double c, double d, Vector3D v) {
        return new Vector3D(c * this.x + d * v.x, c * this.y + d * v.y, c * this.z + d * v.z);
    }

    public void assign(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void assignPlus(Vector3D v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void assignSum(Vector3D v, Vector3D w) {
        this.x = v.x + w.x;
        this.y = v.y + w.y;
        this.z = v.z + w.z;
    }

    public void assignLinComb(double c, double d, Vector3D v) {
        this.x = c * this.x + d * v.x;
        this.y = c * this.y + d * v.y;
        this.z = c * this.z + d * v.z;
    }

    public void assignLinComb(double c, Vector3D v, double d, Vector3D w) {
        this.x = c * v.x + d * w.x;
        this.y = c * v.y + d * w.y;
        this.z = c * v.z + d * w.z;
    }

    public void assignPlus_SumTimes(Vector3D u, Vector3D v, Vector3D w, Vector3D ww, double d) {
        this.x += d * (u.x + v.x + w.x + ww.x);
        this.y += d * (u.y + v.y + w.y + ww.y);
        this.z += d * (u.z + v.z + w.z + ww.z);
    }

    public Vector3D minus(Vector3D v) {
        return new Vector3D(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public void assignMinus(Vector3D v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void assignMinus(Vector3D v, Vector3D w) {
        this.x = v.x - w.x;
        this.y = v.y - w.y;
        this.z = v.z - w.z;
    }

    public Vector3D times(double d) {
        return new Vector3D(d * this.x, d * this.y, d * this.z);
    }

    public void assignTimes(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public void assignTimes(double d, Vector3D v) {
        this.x = d * v.x;
        this.y = d * v.y;
        this.z = d * v.z;
    }

    public void assignSumTimes(Vector3D v, Vector3D w, double d) {
        this.x = d * (v.x + w.x);
        this.y = d * (v.y + w.y);
        this.z = d * (v.z + w.z);
    }

    public void assignSumTimes(Vector3D v, Vector3D w, Vector3D vv, Vector3D ww, double d) {
        this.x = d * (v.x + w.x + vv.x + ww.x);
        this.y = d * (v.y + w.y + vv.y + ww.y);
        this.z = d * (v.z + w.z + vv.z + ww.z);
    }

    public double dot(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector3D cross(Vector3D v) {
        double x1 = this.y * v.z - v.y * this.z;
        double y1 = -(this.x * v.z) + v.x * this.z;
        double z1 = this.x * v.y - v.x * this.y;
        return new Vector3D(x1, y1, z1);
    }

    public Vector3D reflectInAxis(Vector3D axis) {
        double s = 2.0 * (axis.x * this.x + axis.y * this.y + axis.z * this.z);
        Vector3D destination = new Vector3D(s * axis.x - this.x, s * axis.y - this.y, s * axis.z - this.z);
        return destination;
    }

    public String toString() {
        String xStr = Util.toExternalString(this.x);
        String yStr = Util.toExternalString(this.y);
        String zStr = Util.toExternalString(this.z);
        return "(" + xStr + "," + yStr + "," + zStr + ")";
    }

    public static Vector3D fromString(String str) throws NumberFormatException {
        try {
            Matcher matcher = Pattern.compile("\\((.*),(.*),(.*)\\)").matcher(str);
            if (!matcher.matches() && !(matcher = Pattern.compile("(.*) (.*) (.*)").matcher(str.trim())).matches()) {
                throw new Exception();
            }
            String xStr = matcher.group(1);
            String yStr = matcher.group(2);
            String zStr = matcher.group(3);
            double x = (Double)Util.externalStringToValue(xStr, Double.TYPE);
            double y = (Double)Util.externalStringToValue(yStr, Double.TYPE);
            double z = (Double)Util.externalStringToValue(zStr, Double.TYPE);
            return new Vector3D(x, y, z);
        }
        catch (Exception e) {
            throw new NumberFormatException("Can't convert string to Vector3D");
        }
    }
}

