/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.Color;
import vmm3d.core3D.DirectionalLight;
import vmm3d.core3D.Vector3D;

public class LightSettings {
    public static final int DEFAULTS = 0;
    public static final int DISTICTLY_COLORED_SIDES_DEFAULT = 1;
    public static final int WHITE_LIGHT = 2;
    public static final int HIGH_SPECULARITY_DEFAULT = 3;
    private Color light0;
    private DirectionalLight directionalLight1;
    private DirectionalLight directionalLight2;
    private DirectionalLight directionalLight3;
    private Color ambientLight;
    private float specularRatio;
    private int specularExponent;

    public LightSettings(float R0, float G0, float B0, float R1, float G1, float B1, float R2, float G2, float B2, float R3, float G3, float B3, float RA, float GA, float BA, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, float specRatio, int specExponent) {
        this.light0 = new Color(R0, G0, B0);
        this.directionalLight1 = new DirectionalLight(R1, G1, B1, x1, y1, z1);
        this.directionalLight2 = new DirectionalLight(R2, G2, B2, x2, y2, z2);
        this.directionalLight3 = new DirectionalLight(R3, G3, B3, x3, y3, z3);
        this.ambientLight = new Color(RA, GA, BA);
        this.specularRatio = specRatio;
        this.specularExponent = specExponent;
    }

    public LightSettings() {
        this(0.25f, 0.25f, 0.25f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 0.1f, 0.1f, -0.7071, 0.0, -0.7071, -0.5774, -0.5774, -0.5774, 0.0, -0.7071, -0.7071, 0.3f, 25);
    }

    public LightSettings(int code) {
        this();
        switch (code) {
            case 3: {
                this.specularExponent = 150;
                this.specularRatio = 0.85f;
                this.ambientLight = new Color(0.22f, 0.22f, 0.22f);
                break;
            }
            case 1: {
                this.light0 = new Color(0.3f, 0.3f, 0.3f);
                this.directionalLight1.setItsColor(new Color(1.0f, 1.0f, 0.25f));
                this.directionalLight2.setItsColor(new Color(0.5f, 0.5f, 0.5f));
                this.directionalLight3.setItsColor(new Color(0.25f, 0.25f, 1.0f));
                this.directionalLight3.setItsDirection(new Vector3D(-1.0, 0.0, -1.0).normalized());
                break;
            }
            case 2: {
                this.light0 = Color.WHITE;
                this.directionalLight1.setItsColor(Color.BLACK);
                this.directionalLight2.setItsColor(Color.BLACK);
                this.directionalLight3.setItsColor(Color.BLACK);
                this.ambientLight = new Color(0.3f, 0.3f, 0.3f);
                this.specularRatio = 0.0f;
            }
        }
    }

    public Color getAmbientLight() {
        return this.ambientLight;
    }

    public void setAmbientLight(Color ambientLight) {
        this.ambientLight = ambientLight;
    }

    public DirectionalLight getDirectionalLight1() {
        return this.directionalLight1;
    }

    public void setDirectionalLight1(DirectionalLight directionalLight1) {
        this.directionalLight1 = directionalLight1;
    }

    public DirectionalLight getDirectionalLight2() {
        return this.directionalLight2;
    }

    public void setDirectionalLight2(DirectionalLight directionalLight2) {
        this.directionalLight2 = directionalLight2;
    }

    public DirectionalLight getDirectionalLight3() {
        return this.directionalLight3;
    }

    public void setDirectionalLight3(DirectionalLight directionalLight3) {
        this.directionalLight3 = directionalLight3;
    }

    public Color getLight0() {
        return this.light0;
    }

    public void setLight0(Color light0) {
        this.light0 = light0;
    }

    public int getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(int specularExponent) {
        this.specularExponent = specularExponent;
    }

    public float getSpecularRatio() {
        return this.specularRatio;
    }

    public void setSpecularRatio(float specularRatio) {
        this.specularRatio = specularRatio;
    }
}

