/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import vmm3d.core.Animateable;
import vmm3d.core.Complex;
import vmm3d.core.ComplexParam;
import vmm3d.core.Util;

public class ComplexParamAnimateable
extends ComplexParam
implements Animateable {
    private Complex animationStart;
    private Complex animationEnd;
    private Complex defaultAnimationStart;
    private Complex defaultAnimationEnd;
    private String animationStartString;
    private String animationEndString;
    private String defaultStartString;
    private String defaultEndString;

    public ComplexParamAnimateable() {
        this(null, (Complex)null);
    }

    public ComplexParamAnimateable(String name, Complex value) {
        this(name, value, value, value);
    }

    public ComplexParamAnimateable(String name, Complex value, Complex start, Complex end) {
        super(name, value);
        this.animationStart = this.defaultAnimationStart = new Complex(start);
        this.animationEnd = this.defaultAnimationEnd = new Complex(end);
    }

    public ComplexParamAnimateable(String name, String valueAsString) {
        this(name, valueAsString, valueAsString, valueAsString);
    }

    public ComplexParamAnimateable(String name, String valueAsString, String startString, String endString) {
        super(name, valueAsString);
        this.setAnimationStartFromString(startString);
        this.setAnimationEndFromString(endString);
        this.setDefaultAnimationStartFromString(startString);
        this.setDefaultAnimationEndFromString(endString);
    }

    @Override
    public void reset(Complex value) {
        value = new Complex(value);
        super.reset(value);
        this.setAnimationLimitsAndDefaults(value, value);
    }

    public void reset(Complex value, Complex animationStart, Complex animationEnd) {
        super.reset(new Complex(value));
        this.setAnimationLimitsAndDefaults(new Complex(animationStart), new Complex(animationEnd));
    }

    @Override
    public void reset(String valueAsString) {
        this.reset(valueAsString, valueAsString, valueAsString);
    }

    public void reset(String valueAsString, String animationStartAsString, String animationEndAsString) {
        super.reset(valueAsString);
        this.setAnimationStartFromString(animationStartAsString);
        this.setAnimationEndFromString(animationEndAsString);
        this.setDefaultAnimationStartFromString(animationStartAsString);
        this.setDefaultAnimationEndFromString(animationEndAsString);
    }

    public Complex getDefaultAnimationStart() {
        return this.defaultAnimationStart;
    }

    public Complex getDefaultAnimationEnd() {
        return this.defaultAnimationEnd;
    }

    public void setDefaultAnimationLimits(Complex defaultStart, Complex defaultEnd) {
        this.defaultAnimationStart = new Complex(defaultStart);
        this.defaultAnimationEnd = new Complex(defaultEnd);
        this.defaultEndString = null;
        this.defaultStartString = null;
    }

    @Override
    public String getDefaultAnimationStartAsString() {
        return this.defaultStartString != null ? this.defaultStartString : Util.toExternalString(this.defaultAnimationStart);
    }

    @Override
    public String getDefaultAnimationEndAsString() {
        return this.defaultEndString != null ? this.defaultEndString : Util.toExternalString(this.defaultAnimationEnd);
    }

    @Override
    public void setDefaultAnimationStartFromString(String startString) {
        Complex d;
        this.defaultAnimationStart = d = (Complex)this.stringToValueObject(startString);
        this.defaultStartString = startString;
    }

    @Override
    public void setDefaultAnimationEndFromString(String endString) {
        Complex d;
        this.defaultAnimationEnd = d = (Complex)this.stringToValueObject(endString);
        this.defaultEndString = endString;
    }

    public void setAnimationLimits(Complex start, Complex end) {
        this.animationStart = new Complex(start);
        this.animationEnd = new Complex(end);
    }

    public void setAnimationLimitsAndDefaults(Complex start, Complex end) {
        this.setAnimationLimits(start, end);
        this.setDefaultAnimationLimits(start, end);
    }

    public void setAnimationStart(Complex x) {
        this.animationStart = new Complex(x);
        this.animationStartString = null;
    }

    public void setAnimationEnd(Complex x) {
        this.animationEnd = new Complex(x);
        this.animationEndString = null;
    }

    public Complex getAnimationStart() {
        return this.animationStart;
    }

    public Complex getAnimationEnd() {
        return this.animationEnd;
    }

    @Override
    public void setAnimationStartFromString(String startVal) {
        Complex d;
        this.animationStart = d = (Complex)this.stringToValueObject(startVal);
        this.animationStartString = startVal;
    }

    @Override
    public void setAnimationEndFromString(String endVal) {
        Complex d;
        this.animationEnd = d = (Complex)this.stringToValueObject(endVal);
        this.animationEndString = endVal;
    }

    @Override
    public String getAnimationStartAsString() {
        return this.animationStartString != null ? this.animationStartString : Util.toExternalString(this.animationStart);
    }

    @Override
    public String getAnimationEndAsString() {
        return this.animationEndString != null ? this.animationEndString : Util.toExternalString(this.animationEnd);
    }

    @Override
    public void setFractionComplete(double fractionComplete) {
        this.setValueObject(new Complex(this.animationStart.re + fractionComplete * (this.animationEnd.re - this.animationStart.re), this.animationStart.im + fractionComplete * (this.animationEnd.im - this.animationStart.im)));
    }

    @Override
    public boolean reallyAnimated() {
        return !this.animationStart.equals(this.animationEnd);
    }
}

