/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import vmm3d.core.Complex;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.Util;
import vmm3d.functions.ComplexExpression;
import vmm3d.functions.ParseError;

public class ComplexParam
extends Parameter {
    private Complex minimumValueForInput = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    private Complex maximumValueForInput = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public ComplexParam() {
        this(null, (Complex)null);
    }

    public ComplexParam(String name, Complex initialValue) {
        super(name, new Complex(initialValue));
    }

    public ComplexParam(String name, String valueAsString) throws NumberFormatException {
        super(name, valueAsString);
    }

    public void reset(Complex value) {
        this.reset(new Complex(value));
    }

    public void setValue(Complex val) {
        this.setValueObject(new Complex(val));
    }

    public Complex getValue() {
        Complex d = (Complex)this.getValueObject();
        if (d == null) {
            return new Complex(0.0, 0.0);
        }
        return d;
    }

    public void setDefaultValue(double val) {
        this.setDefaultValueObject(new Complex(val));
    }

    public void setValueAndDefault(Complex val) {
        Complex d = new Complex(val);
        this.setValueObject(d);
        this.setDefaultValueObject(d);
    }

    public Complex getDefaultValue() {
        Complex d = (Complex)this.getDefaultValueObject();
        if (d == null) {
            return new Complex();
        }
        return d;
    }

    public Complex getMaximumValueForInput() {
        return this.maximumValueForInput;
    }

    public void setMaximumValueForInput(Complex maximumValueForInput) {
        if (maximumValueForInput == null) {
            maximumValueForInput = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        this.maximumValueForInput = new Complex(maximumValueForInput);
    }

    public Complex getMinimumValueForInput() {
        return this.minimumValueForInput;
    }

    public void setMinimumValueForInput(Complex minimumValueForInput) {
        if (minimumValueForInput == null) {
            minimumValueForInput = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        this.minimumValueForInput = new Complex(minimumValueForInput);
    }

    @Override
    protected Object stringToValueObject(String str) throws NumberFormatException {
        ComplexExpression exp;
        try {
            exp = Util.parseComplexConstantExpression(str);
        }
        catch (ParseError e) {
            try {
                return Util.externalStringToValue(str, Complex.class);
            }
            catch (Exception exception) {
                throw new NumberFormatException(I18n.tr("vmm3d.core.ComplexParam.badExpression", str, e.getMessage()));
            }
        }
        Complex d = exp.value();
        if (Double.isNaN(d.re) || Double.isInfinite(d.re) || Double.isNaN(d.im) || Double.isInfinite(d.im)) {
            throw new NumberFormatException(I18n.tr("vmm3d.core.ComplexParam.undefined", str));
        }
        return d;
    }

    @Override
    protected String valueObjectToString(Object obj) {
        return Util.toExternalString(obj);
    }
}

