/*
 * Decompiled with CFR 0.152.
 */
package org.ea.javacnn.readers;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.ea.javacnn.readers.Reader;

public class MnistReader
implements Reader {
    private String labelFile;
    private String imageFile;
    private FileInputStream labelIO;
    private FileInputStream imageIO;
    private int labelSize;
    private int imageSize;
    private int imageX;
    private int imageY;

    private int readInt(FileInputStream is) throws Exception {
        byte[] int32Full = new byte[4];
        is.read(int32Full);
        ByteBuffer wrapped = ByteBuffer.wrap(int32Full);
        return wrapped.getInt();
    }

    @Override
    public int size() {
        return this.imageSize;
    }

    public MnistReader(String labelFile, String imageFile) {
        try {
            this.labelFile = labelFile;
            this.imageFile = imageFile;
            this.labelIO = new FileInputStream(labelFile);
            this.imageIO = new FileInputStream(imageFile);
            if (this.readInt(this.labelIO) != 2049) {
                throw new Exception("Label file header missing");
            }
            if (this.readInt(this.imageIO) != 2051) {
                throw new Exception("Image file header missing");
            }
            this.labelSize = this.readInt(this.labelIO);
            this.imageSize = this.readInt(this.imageIO);
            if (this.labelSize != this.imageSize) {
                throw new Exception("Labels and images don't match in number.");
            }
            this.imageY = this.readInt(this.imageIO);
            this.imageX = this.readInt(this.imageIO);
            System.out.println("LSZ " + this.labelSize + " ISZ " + this.imageSize + " Y " + this.imageY + " X " + this.imageX);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getMaxvalue() {
        return 255;
    }

    @Override
    public int numOfClasses() {
        return 10;
    }

    @Override
    public void reset() {
        try {
            this.labelIO.close();
            this.imageIO.close();
            this.labelIO = new FileInputStream(this.labelFile);
            this.imageIO = new FileInputStream(this.imageFile);
            this.readInt(this.labelIO);
            this.readInt(this.labelIO);
            this.readInt(this.imageIO);
            this.readInt(this.imageIO);
            this.readInt(this.imageIO);
            this.readInt(this.imageIO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int readNextLabel() {
        try {
            return this.labelIO.read();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public int[] readNextImage() throws Exception {
        int size = this.imageX * this.imageY;
        byte[] imageArray = new byte[size];
        Arrays.fill(imageArray, (byte)0);
        this.imageIO.read(imageArray, 0, size);
        int[] imageInts = new int[size];
        for (int i = 0; i < size; ++i) {
            imageInts[i] = imageArray[i];
        }
        return imageInts;
    }

    public static void main(String[] argv) {
        int i;
        MnistReader mr = new MnistReader("mnist/t10k-labels.idx1-ubyte", "mnist/t10k-images.idx3-ubyte");
        for (i = 0; i < 200; ++i) {
            System.out.print(mr.readNextLabel());
        }
        System.out.print(mr.readNextLabel());
        for (i = 0; i < 200; ++i) {
            try {
                mr.readNextImage();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Crash at " + i);
            }
        }
        try {
            int[] b = mr.readNextImage();
            for (int j = 0; j < b.length; ++j) {
                if (j % 28 == 0) {
                    System.out.println();
                }
                System.out.print((b[j] & 0xFF) + " ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getSizeX() {
        return this.imageX;
    }

    @Override
    public int getSizeY() {
        return this.imageY;
    }
}

