/*
 * Decompiled with CFR 0.152.
 */
package org.ea.javacnn.losslayers;

import org.ea.javacnn.data.DataBlock;
import org.ea.javacnn.data.OutputDefinition;
import org.ea.javacnn.losslayers.LossLayer;

public class RegressionLayer
extends LossLayer {
    public RegressionLayer(OutputDefinition def) {
        super(def);
    }

    @Override
    public DataBlock forward(DataBlock db, boolean training) {
        this.in_act = db;
        this.out_act = db;
        return db;
    }

    public double backward(double[] y) {
        DataBlock x = this.in_act;
        x.clearGradient();
        double loss = 0.0;
        for (int i = 0; i < this.out_depth; ++i) {
            double dy = x.getWeight(i) - y[i];
            x.setGradient(i, dy);
            loss += 0.5 * dy * dy;
        }
        return loss;
    }

    @Override
    public double backward(int y) {
        DataBlock x = this.in_act;
        x.clearGradient();
        double loss = 0.0;
        double dy = x.getWeight(0) - (double)y;
        x.setGradient(0, dy);
        return loss += 0.5 * dy * dy;
    }
}

