/*
 * Decompiled with CFR 0.152.
 */
package edu.hitsz.c102c.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ConcurenceRunner {
    private static final ExecutorService exec;
    public static final int cpuNum;

    public static void run(Runnable task) {
        exec.execute(task);
    }

    public static void stop() {
        exec.shutdown();
    }

    static {
        cpuNum = Runtime.getRuntime().availableProcessors();
        System.out.println("cpuNum:" + cpuNum);
        exec = Executors.newFixedThreadPool(cpuNum);
    }

    public static abstract class TaskManager {
        private int workLength;

        public TaskManager(int workLength) {
            this.workLength = workLength;
        }

        public void start() {
            int runCpu = cpuNum < this.workLength ? cpuNum : 1;
            final CountDownLatch gate = new CountDownLatch(runCpu);
            int fregLength = (this.workLength + runCpu - 1) / runCpu;
            for (int cpu = 0; cpu < runCpu; ++cpu) {
                final int start = cpu * fregLength;
                int tmp = (cpu + 1) * fregLength;
                final int end = tmp <= this.workLength ? tmp : this.workLength;
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        this.process(start, end);
                        gate.countDown();
                    }
                };
                ConcurenceRunner.run(task);
            }
            try {
                gate.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public abstract void process(int var1, int var2);
    }
}

