/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.ImageGetter;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ScriptImageGetter
implements ImageGetter {
    Object parent;
    String fname;

    public ScriptImageGetter(Object parent, String fname) {
        this.parent = parent;
        this.fname = fname;
    }

    private Vector<IoChunk> getOutputChunksFromProcess(Process p) throws IOException {
        int readBytes;
        int bufferSize = 10240;
        byte[] buffer = new byte[10240];
        Vector<IoChunk> chunkVec = new Vector<IoChunk>();
        BufferedInputStream reader = new BufferedInputStream(p.getInputStream());
        while ((readBytes = reader.read(buffer, 0, 10240)) != -1) {
            chunkVec.add(new IoChunk(buffer, readBytes));
        }
        return chunkVec;
    }

    private int getTotalSizeOfChunks(Vector<IoChunk> chunks) {
        int totalSize = 0;
        Enumeration<IoChunk> chunkEnum = chunks.elements();
        while (chunkEnum.hasMoreElements()) {
            totalSize += chunkEnum.nextElement().contents.length;
        }
        return totalSize;
    }

    private byte[] joinChunksToByteArr(Vector<IoChunk> chunks) {
        byte[] joined = new byte[this.getTotalSizeOfChunks(chunks)];
        int storeInd = 0;
        Enumeration<IoChunk> chunkEnum = chunks.elements();
        while (chunkEnum.hasMoreElements()) {
            byte[] stuff = chunkEnum.nextElement().contents;
            for (int i = 0; i < stuff.length; ++i) {
                joined[storeInd++] = stuff[i];
            }
        }
        return joined;
    }

    public byte[] getCommandOutput(String[] commandAndArgs) {
        Vector<IoChunk> chunks;
        try {
            Process p = Runtime.getRuntime().exec(commandAndArgs);
            chunks = this.getOutputChunksFromProcess(p);
            if (p.waitFor() != 0) {
                throw new IOException("Image getter script failed");
            }
            p.destroy();
        }
        catch (Exception ex) {
            return null;
        }
        return this.joinChunksToByteArr(chunks);
    }

    @Override
    public Image getImage(int scale) {
        String[] cmds = new String[]{"dexter_getImage", "-s", new Integer(scale).toString(), this.fname};
        return Toolkit.getDefaultToolkit().createImage(this.getCommandOutput(cmds));
    }

    @Override
    public Image getImage(int scale, Rectangle bbox) {
        String[] cmds = new String[]{"dexter_getImage", "-s", new Integer(scale).toString(), "-b", bbox.x + "," + bbox.y + "," + bbox.width + "," + bbox.height, this.fname};
        System.out.println("Acquiring image.");
        return Toolkit.getDefaultToolkit().createImage(this.getCommandOutput(cmds));
    }

    private class IoChunk {
        public byte[] contents;
        public int len;

        public IoChunk(byte[] contents, int len) {
            this.contents = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.contents[i] = contents[i];
            }
        }
    }
}

