/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.ImageWithPoints;
import debuxter.Recogniser;
import debuxter.RecogniserSettings;
import java.awt.Point;
import java.util.Vector;

class AutoAxisFinder
extends Recogniser {
    double tickRatio = 1.5;

    public AutoAxisFinder(ImageWithPoints parent, RecogniserSettings settings) {
        super(parent, settings);
    }

    @Override
    public synchronized boolean putCoordinate(Point p) {
        this.haveCoos = true;
        this.notify();
        return false;
    }

    @Override
    public boolean analyseIt() {
        return true;
    }

    protected int[] chooseLimits(Vector points) throws Exception {
        int i;
        int ct = 0;
        int leftpos = 0;
        int rightpos = 0;
        int left = this.px_w;
        int right = 0;
        int maxWeight = 0;
        int maxWeightPos = 0;
        if (points.isEmpty()) {
            throw new Exception("No ticks found");
        }
        for (i = 0; i < points.size(); ++i) {
            int[] pt = (int[])points.elementAt(i);
            if (pt[2] <= maxWeight) continue;
            maxWeight = pt[2];
            maxWeightPos = i;
        }
        int thresh = maxWeight - maxWeight / 3;
        for (i = 0; i < points.size(); ++i) {
            int[] pt = (int[])points.elementAt(i);
            if (pt[2] < thresh) continue;
            ++ct;
            if (pt[0] < left) {
                left = pt[0];
                leftpos = i;
            }
            if (pt[0] <= right) continue;
            right = pt[0];
            rightpos = i;
        }
        if (ct < 2) {
            points.removeElementAt(maxWeightPos);
            return this.chooseLimits(points);
        }
        return new int[]{leftpos, rightpos};
    }

    protected void lowerAxis() throws Exception {
        int lastweight;
        Vector<int[]> ticks = new Vector<int[]>();
        int tickStart = -1;
        int tickWeight = 0;
        int meanDenom = 0;
        int meanNumer = 0;
        int axisPos = 0;
        if (this.axisBottom == this.px_h) {
            return;
        }
        if (this.debug) {
            System.out.println("Lower Axis");
        }
        int xstart = this.axisLeft + (this.axisRight - this.axisLeft) / 30;
        int ind = xstart + this.axisBottom * this.px_w;
        while (this.pixels[ind] > this.blackThresh) {
            ind += this.px_w;
        }
        Point cp = new Point(ind % this.px_w, ind / this.px_w);
        int axisWeight = lastweight = this.findCB((int)(cp.x + cp.y * this.px_w)).x;
        int xlimit = this.axisRight - (this.axisRight - this.axisLeft) / 30;
        while (this.nextY(cp, cp.y, 1)) {
            ++cp.x;
            int thisweight = this.findCB((int)(cp.x + cp.y * this.px_w)).x;
            if (cp.x - xstart < 30 && (double)axisWeight > this.tickRatio * (double)thisweight) {
                axisWeight = thisweight;
            }
            if (tickStart == -1) {
                if ((double)thisweight >= this.tickRatio * (double)axisWeight) {
                    tickStart = cp.x;
                    tickWeight = thisweight;
                    meanNumer = thisweight * cp.x;
                    meanDenom = thisweight;
                } else if (thisweight < 3 * axisWeight / 2) {
                    axisPos = cp.y;
                }
            } else if ((double)thisweight < this.tickRatio * (double)axisWeight) {
                ticks.addElement(new int[]{(int)Math.round((double)meanNumer / (double)meanDenom), axisPos, tickWeight});
                tickStart = -1;
            } else {
                if (tickWeight < thisweight) {
                    tickWeight = thisweight;
                }
                meanNumer += thisweight * cp.x;
                meanDenom += thisweight;
            }
            lastweight = thisweight;
            if (cp.x <= xlimit) continue;
            break;
        }
        int[] inds = this.chooseLimits(ticks);
        int[] p1 = (int[])ticks.elementAt(inds[0]);
        int[] p2 = (int[])ticks.elementAt(inds[1]);
        this.parent.setGauge(new Point(p1[0], p1[1]), new Point(p2[0], p2[1]));
    }

    protected void leftAxis() throws Exception {
        int lastweight;
        Vector<int[]> ticks = new Vector<int[]>();
        int tickStart = -1;
        int tickWeight = 0;
        int meanNumer = 0;
        int meanDenom = 0;
        int axisPos = 0;
        if (this.axisLeft == 0) {
            return;
        }
        if (this.debug) {
            System.out.println("Left Axis");
        }
        int ystart = this.axisBottom - (this.axisBottom - this.axisTop) / 30;
        int ind = this.axisLeft + ystart * this.px_w;
        while (this.pixels[ind] > this.blackThresh) {
            --ind;
        }
        Point cp = new Point(ind % this.px_w, ind / this.px_w);
        int[] res = this.findxCB(cp.x + cp.y * this.px_w);
        int thisweight = res[0];
        int targx = res[3];
        int axisWeight = lastweight = thisweight;
        int ylimit = this.axisTop + (this.axisBottom - this.axisTop) / 30;
        while (this.nextX(cp, targx, -1)) {
            --cp.y;
            res = this.findxCB(cp.x + cp.y * this.px_w);
            thisweight = res[0];
            targx = res[3];
            if (ystart - cp.y < 30 && (double)axisWeight > this.tickRatio * (double)thisweight) {
                axisWeight = thisweight;
            }
            if (tickStart == -1) {
                if ((double)thisweight >= this.tickRatio * (double)axisWeight) {
                    tickStart = cp.y;
                    tickWeight = thisweight;
                    meanNumer = thisweight * cp.y;
                    meanDenom = thisweight;
                } else if (thisweight <= 3 * axisWeight / 2) {
                    axisPos = cp.x;
                }
            } else if ((double)thisweight < this.tickRatio * (double)axisWeight) {
                ticks.addElement(new int[]{(int)Math.round((double)meanNumer / (double)meanDenom), axisPos, tickWeight});
                tickStart = -1;
            } else {
                if (tickWeight < thisweight) {
                    tickWeight = thisweight;
                }
                meanNumer += thisweight * cp.y;
                meanDenom += thisweight;
            }
            lastweight = thisweight;
            if (cp.y >= ylimit) continue;
        }
        int[] inds = this.chooseLimits(ticks);
        int[] p1 = (int[])ticks.elementAt(inds[0]);
        int[] p2 = (int[])ticks.elementAt(inds[1]);
        this.parent.setGauge(new Point(p1[1], p1[0]), new Point(p2[1], p2[0]));
    }

    @Override
    public void recogniseIt() throws Exception {
        try {
            this.lowerAxis();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.leftAxis();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

