/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.xml;

import functionplotter.exception.AppException;
import functionplotter.xml.ErrorLogger;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtilities {
    private static final String XML_DECLARATION_PREFIX = "<?functionplotter.xml";
    private static ErrorLogger errorHandler;

    private XmlUtilities() {
    }

    public static ErrorLogger getErrorHandler() {
        if (errorHandler == null) {
            errorHandler = new ErrorLogger();
        }
        return errorHandler;
    }

    public static String escape(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\"': {
                return "&quot;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return Character.toString(c);
    }

    public static String escape(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            stringBuilder.append(XmlUtilities.escape(charSequence.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public static String getElementPath(Element element) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (element != null) {
            arrayList.add(element.getNodeName());
            object = element.getParentNode();
            element = object instanceof Element ? (Element)object : null;
        }
        object = new StringBuilder(arrayList.size() << 4);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ((StringBuilder)object).append((String)arrayList.get(i));
            if (i <= 0) continue;
            ((StringBuilder)object).append('.');
        }
        return ((StringBuilder)object).toString();
    }

    public static boolean hasChildren(Element element, int n) {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != n) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isXml(File file) throws FileNotFoundException, IOException, SecurityException {
        if (file.length() < (long)XML_DECLARATION_PREFIX.length()) {
            return false;
        }
        byte[] byArray = new byte[XML_DECLARATION_PREFIX.length()];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        return XML_DECLARATION_PREFIX.equals(new String(byArray, "UTF-8"));
    }

    public static DocumentBuilder createDocumentBuilder(boolean bl) throws AppException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setXIncludeAware(true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new AppException((AppException.Id)ErrorId.FAILED_TO_INSTANTIATE_DOCUMENT_BUILDER_FACTORY, (Throwable)factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AppException((AppException.Id)ErrorId.FAILED_TO_CREATE_DOCUMENT_BUILDER, (Throwable)parserConfigurationException);
        }
    }

    public static Document createDocument() throws AppException {
        return XmlUtilities.createDocumentBuilder(false).newDocument();
    }

    public static Document createDocument(byte[] byArray) throws AppException {
        return XmlUtilities.createDocument(byArray, null, false);
    }

    public static Document createDocument(byte[] byArray, URI uRI, boolean bl) throws AppException {
        InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
        inputSource.setEncoding("UTF-8");
        return XmlUtilities.createDocument(inputSource, uRI, bl);
    }

    public static Document createDocument(char[] cArray) throws AppException {
        return XmlUtilities.createDocument(cArray, null, false);
    }

    public static Document createDocument(char[] cArray, URI uRI, boolean bl) throws AppException {
        return XmlUtilities.createDocument(new InputSource(new CharArrayReader(cArray)), uRI, bl);
    }

    public static Document createDocument(String string) throws AppException {
        return XmlUtilities.createDocument(string, null, false);
    }

    public static Document createDocument(String string, URI uRI, boolean bl) throws AppException {
        return XmlUtilities.createDocument(new InputSource(new StringReader(string)), uRI, bl);
    }

    public static Document createDocument(InputStream inputStream) throws AppException {
        return XmlUtilities.createDocument(inputStream, null, false);
    }

    public static Document createDocument(InputStream inputStream, URI uRI, boolean bl) throws AppException {
        return XmlUtilities.createDocument(new InputSource(inputStream), uRI, bl);
    }

    public static Document createDocument(InputSource inputSource, URI uRI, boolean bl) throws AppException {
        try {
            if (uRI != null) {
                inputSource.setSystemId(uRI.toString());
            }
            DocumentBuilder documentBuilder = XmlUtilities.createDocumentBuilder(bl);
            XmlUtilities.getErrorHandler().clear();
            documentBuilder.setErrorHandler(XmlUtilities.getErrorHandler());
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new AppException((AppException.Id)ErrorId.ERROR_PARSING_FILE, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new AppException((AppException.Id)ErrorId.ERROR_PARSING_FILE, (Throwable)iOException);
        }
    }

    public static String getAttribute(Element element, String string) {
        return element.hasAttribute(string) ? element.getAttribute(string) : null;
    }

    public static String getAttribute(Element element, String string, String string2) {
        return element.hasAttributeNS(string, string2) ? element.getAttributeNS(string, string2) : null;
    }

    public static List<Element> getChildElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    public static Element findElement(Element element, String string) {
        return XmlUtilities.findElement(null, element, string, false);
    }

    public static Element findElement(Document document, String string) {
        return XmlUtilities.findElement(document, string, false);
    }

    public static Element findElement(Document document, String string, boolean bl) {
        return XmlUtilities.findElement(document, document.getDocumentElement(), string, bl);
    }

    public static Element findElement(Document document, Element element, String string, boolean bl) {
        int n;
        Node node = element;
        String[] stringArray = string.split("\\.", -1);
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            String string2 = stringArray[n];
            Element element2 = node;
            NodeList nodeList = node.getChildNodes();
            for (n2 = 0; !(n2 >= nodeList.getLength() || (node = nodeList.item(n2)).getNodeType() == 1 && node.getNodeName().equals(string2)); ++n2) {
            }
            if (n2 < nodeList.getLength()) continue;
            if (!bl) break;
            element2.appendChild(document.createElement(string2));
            node = element2.getLastChild();
        }
        return n < stringArray.length ? null : node;
    }

    public static void setNamespaceAttribute(Element element) {
        Object object;
        Object object2;
        String string = element.getNamespaceURI();
        if (!(string == null || (object2 = element.getParentNode()) != null && string.equals(object2.getNamespaceURI()))) {
            String string2 = element.getPrefix();
            object = string2 == null ? "xmlns" : "xmlns:" + string2;
            element.setAttribute((String)object, string);
        }
        object2 = element.getChildNodes();
        for (int i = 0; i < object2.getLength(); ++i) {
            object = object2.item(i);
            if (object.getNodeType() != 1) continue;
            XmlUtilities.setNamespaceAttribute((Element)object);
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        FAILED_TO_INSTANTIATE_DOCUMENT_BUILDER_FACTORY("Failed to instantiate a DOM document builder factory."),
        FAILED_TO_CREATE_DOCUMENT_BUILDER("Failed to create a DOM document builder."),
        ERROR_PARSING_FILE("An error occurred while parsing the file.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface AttrName {
        public static final String XMLNS = "xmlns";
    }
}

