/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import java.awt.FontMetrics;
import java.io.File;
import java.util.ArrayList;

public class TextUtilities {
    private static final String ELLIPSIS_STR = "...";
    private static final char ESCAPE_CHAR = '\\';
    private static final String ESCAPE_STR = Character.toString('\\');

    private TextUtilities() {
    }

    public static String[] splitString(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            char c2;
            if ((c2 = string.charAt(n++)) == '\\') {
                if (n >= string.length()) continue;
                stringBuilder.append(string.charAt(n++));
                continue;
            }
            if (c2 == c) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String escapeSeparator(String string, char c) {
        String string2 = Character.toString(c);
        return string.replace(ESCAPE_STR, ESCAPE_STR + ESCAPE_STR).replace(string2, ESCAPE_STR + string2);
    }

    public static String getLimitedWidthString(String string, FontMetrics fontMetrics, int n, boolean bl) {
        return TextUtilities.getLimitedWidthString(string, fontMetrics, n, bl, null);
    }

    public static String getLimitedWidthString(String string, FontMetrics fontMetrics, int n, boolean bl, boolean[] blArray) {
        if (blArray != null) {
            blArray[0] = false;
        }
        String string2 = null;
        if (string != null) {
            if (fontMetrics.stringWidth(string) > n) {
                n -= fontMetrics.stringWidth(ELLIPSIS_STR);
                char[] cArray = string.toCharArray();
                int n2 = cArray.length;
                if (bl) {
                    int n3 = 0;
                    while (++n3 < n2 && fontMetrics.charsWidth(cArray, n3, n2 - n3) > n) {
                    }
                    string2 = n2 - n3 > 0 ? ELLIPSIS_STR + new String(cArray, n3, n2 - n3) : ELLIPSIS_STR;
                } else {
                    while (--n2 > 0 && fontMetrics.charsWidth(cArray, 0, n2) > n) {
                    }
                    String string3 = string2 = n2 > 0 ? new String(cArray, 0, n2) + ELLIPSIS_STR : ELLIPSIS_STR;
                }
                if (blArray != null) {
                    blArray[0] = true;
                }
            } else {
                string2 = string;
            }
        }
        return string2;
    }

    public static String getLimitedWidthPathname(String string, FontMetrics fontMetrics, int n) {
        return TextUtilities.getLimitedWidthPathname(string, fontMetrics, n, File.separatorChar);
    }

    public static String getLimitedWidthPathname(String string, FontMetrics fontMetrics, int n, char c) {
        String string2 = null;
        if (string != null) {
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < string.length(); ++i) {
                int n3 = i;
                if ((i = string.indexOf(c, i)) < 0) {
                    i = string.length();
                }
                if (i <= n3) continue;
                arrayList.add(string.substring(n3, i));
            }
            StringBuilder stringBuilder = new StringBuilder(ELLIPSIS_STR);
            int n4 = 0;
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                stringBuilder.append(c);
                stringBuilder.append((String)arrayList.get(n2));
                if (fontMetrics.stringWidth(stringBuilder.toString()) > n) break;
                ++n4;
            }
            if (!arrayList.isEmpty() && n4 == 0) {
                int n5;
                char[] cArray = ((String)arrayList.get(arrayList.size() - 1)).toCharArray();
                for (n5 = 0; n5 < cArray.length && fontMetrics.charsWidth(cArray, n5, cArray.length - n5) > n; ++n5) {
                }
                string2 = new String(cArray, n5, cArray.length - n5);
            } else if (n4 == arrayList.size()) {
                string2 = string;
            } else {
                stringBuilder = new StringBuilder(ELLIPSIS_STR);
                for (n2 = arrayList.size() - n4; n2 < arrayList.size(); ++n2) {
                    stringBuilder.append(c);
                    stringBuilder.append((String)arrayList.get(n2));
                }
                string2 = stringBuilder.toString();
            }
        }
        return string2;
    }
}

