/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.exception.TempFileException;
import functionplotter.exception.TerminatedException;
import functionplotter.exception.UriException;
import functionplotter.util.FileAttributeUtilities;
import functionplotter.util.FileWritingMode;
import functionplotter.util.LineSeparator;
import functionplotter.util.ProgressListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TextFile {
    public static final String CHARSET_NAME_UTF8 = "UTF-8";
    private static final int BLOCK_LENGTH = 8192;
    private static final int URI_CONNECTION_TIMEOUT = 30000;
    private static final int URI_READ_TIMEOUT = 30000;
    private static final String TEMP_FILE_PREFIX = "_$_";
    private URI uri;
    private File file;
    private String charsetName;
    private List<ProgressListener> progressListeners;

    public TextFile(File file) throws IllegalArgumentException {
        this(file, Charset.defaultCharset().name());
    }

    public TextFile(File file, String string) throws IllegalArgumentException {
        if (file == null || string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.charsetName = string;
        this.progressListeners = new ArrayList<ProgressListener>();
    }

    public TextFile(URI uRI) throws NullPointerException {
        this(uRI, null);
    }

    public TextFile(URI uRI, String string) throws NullPointerException {
        if (uRI == null) {
            throw new NullPointerException();
        }
        this.uri = uRI;
        this.charsetName = string;
        this.progressListeners = new ArrayList<ProgressListener>();
    }

    public static StringBuilder read(File file) throws AppException {
        return new TextFile(file).read();
    }

    public static StringBuilder read(URI uRI) throws AppException {
        return new TextFile(uRI).read();
    }

    public static StringBuilder read(File file, String string) throws AppException {
        return new TextFile(file, string).read();
    }

    public static StringBuilder read(URI uRI, String string) throws AppException {
        return new TextFile(uRI, string).read();
    }

    public static StringBuffer readSync(File file) throws AppException {
        return new TextFile(file).readSync();
    }

    public static StringBuffer readSync(URI uRI) throws AppException {
        return new TextFile(uRI).readSync();
    }

    public static StringBuffer readSync(File file, String string) throws AppException {
        return new TextFile(file, string).readSync();
    }

    public static StringBuffer readSync(URI uRI, String string) throws AppException {
        return new TextFile(uRI, string).readSync();
    }

    public static String[] readLines(File file) throws AppException {
        return new TextFile(file).readLines();
    }

    public static String[] readLines(URI uRI) throws AppException {
        return new TextFile(uRI).readLines();
    }

    public static String[] readLines(File file, String string) throws AppException {
        return new TextFile(file, string).readLines();
    }

    public static String[] readLines(URI uRI, String string) throws AppException {
        return new TextFile(uRI, string).readLines();
    }

    public static String[] readLines(File file, int n) throws AppException {
        return new TextFile(file).readLines(n);
    }

    public static String[] readLines(URI uRI, int n) throws AppException {
        return new TextFile(uRI).readLines(n);
    }

    public static String[] readLines(File file, String string, int n) throws AppException {
        return new TextFile(file, string).readLines(n);
    }

    public static String[] readLines(URI uRI, String string, int n) throws AppException {
        return new TextFile(uRI, string).readLines(n);
    }

    public static void write(File file, CharSequence charSequence) throws AppException {
        new TextFile(file).write(charSequence, FileWritingMode.DIRECT);
    }

    public static void write(File file, String string, CharSequence charSequence) throws AppException {
        new TextFile(file, string).write(charSequence, FileWritingMode.DIRECT);
    }

    public static void write(File file, CharSequence charSequence, FileWritingMode fileWritingMode) throws AppException {
        new TextFile(file).write(charSequence, fileWritingMode);
    }

    public static void write(File file, String string, CharSequence charSequence, FileWritingMode fileWritingMode) throws AppException {
        new TextFile(file, string).write(charSequence, fileWritingMode);
    }

    public static EnumMap<LineSeparator, Integer> changeLineSeparators(StringBuilder stringBuilder, boolean bl) {
        EnumMap<LineSeparator, Integer> enumMap = null;
        int n = 0;
        int n2 = 0;
        int n3 = stringBuilder.length();
        if (bl) {
            int[] nArray = new int[LineSeparator.values().length];
            while (n < n3) {
                int n4;
                if ((n4 = stringBuilder.charAt(n++)) == 13) {
                    if (n < n3 && stringBuilder.charAt(n) == '\n') {
                        ++n;
                        int n5 = LineSeparator.CR_LF.ordinal();
                        nArray[n5] = nArray[n5] + 1;
                    } else {
                        int n6 = LineSeparator.CR.ordinal();
                        nArray[n6] = nArray[n6] + 1;
                    }
                    n4 = 10;
                } else if (n4 == 10) {
                    int n7 = LineSeparator.LF.ordinal();
                    nArray[n7] = nArray[n7] + 1;
                }
                stringBuilder.setCharAt(n2++, (char)n4);
            }
            enumMap = new EnumMap<LineSeparator, Integer>(LineSeparator.class);
            for (LineSeparator lineSeparator : LineSeparator.values()) {
                int n8 = nArray[lineSeparator.ordinal()];
                if (n8 <= 0) continue;
                enumMap.put(lineSeparator, new Integer(n8));
            }
        } else {
            while (n < n3) {
                char c;
                if ((c = stringBuilder.charAt(n++)) == '\r') {
                    if (n < n3 && stringBuilder.charAt(n) == '\n') {
                        ++n;
                    }
                    c = '\n';
                }
                stringBuilder.setCharAt(n2++, c);
            }
        }
        stringBuilder.setLength(n2);
        return enumMap;
    }

    public static EnumMap<LineSeparator, Integer> changeLineSeparators(StringBuffer stringBuffer, boolean bl) {
        EnumMap<LineSeparator, Integer> enumMap = null;
        int n = 0;
        int n2 = 0;
        int n3 = stringBuffer.length();
        if (bl) {
            int[] nArray = new int[LineSeparator.values().length];
            while (n < n3) {
                int n4;
                if ((n4 = stringBuffer.charAt(n++)) == 13) {
                    if (n < n3 && stringBuffer.charAt(n) == '\n') {
                        ++n;
                        int n5 = LineSeparator.CR_LF.ordinal();
                        nArray[n5] = nArray[n5] + 1;
                    } else {
                        int n6 = LineSeparator.CR.ordinal();
                        nArray[n6] = nArray[n6] + 1;
                    }
                    n4 = 10;
                } else if (n4 == 10) {
                    int n7 = LineSeparator.LF.ordinal();
                    nArray[n7] = nArray[n7] + 1;
                }
                stringBuffer.setCharAt(n2++, (char)n4);
            }
            enumMap = new EnumMap<LineSeparator, Integer>(LineSeparator.class);
            for (LineSeparator lineSeparator : LineSeparator.values()) {
                int n8 = nArray[lineSeparator.ordinal()];
                if (n8 <= 0) continue;
                enumMap.put(lineSeparator, new Integer(n8));
            }
        } else {
            while (n < n3) {
                char c;
                if ((c = stringBuffer.charAt(n++)) == '\r') {
                    if (n < n3 && stringBuffer.charAt(n) == '\n') {
                        ++n;
                    }
                    c = '\n';
                }
                stringBuffer.setCharAt(n2++, c);
            }
        }
        stringBuffer.setLength(n2);
        return enumMap;
    }

    public StringBuilder read() throws AppException {
        return (StringBuilder)(this.isFile() ? this.readFile(false, false) : this.readUri(false, false));
    }

    public StringBuffer readSync() throws AppException {
        return (StringBuffer)(this.isFile() ? this.readFile(false, true) : this.readUri(false, true));
    }

    public String[] readLines() throws AppException {
        return this.isFile() ? this.readLinesFile(false, 0) : this.readLinesUri(false, 0);
    }

    public String[] readLines(int n) throws AppException {
        return this.isFile() ? this.readLinesFile(false, n) : this.readLinesUri(false, n);
    }

    public void write(CharSequence charSequence, FileWritingMode fileWritingMode) throws AppException, IllegalStateException {
        if (!this.isFile()) {
            throw new IllegalStateException();
        }
        boolean bl = false;
        try {
            bl = this.file.exists();
        }
        catch (SecurityException securityException) {
            throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, this.file, securityException);
        }
        if (bl) {
            switch (fileWritingMode) {
                case DIRECT: {
                    this.writeDirect(charSequence, false);
                    break;
                }
                case USE_TEMP_FILE: {
                    this.writeUsingTempFile(charSequence, false, false);
                    break;
                }
                case USE_TEMP_FILE_PRESERVE_ATTRS: {
                    this.writeUsingTempFile(charSequence, false, true);
                }
            }
        } else {
            this.writeDirect(charSequence, false);
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    public ProgressListener[] getProgressListeners() {
        return this.progressListeners.toArray(new ProgressListener[this.progressListeners.size()]);
    }

    protected boolean isFile() {
        return this.file != null;
    }

    protected Object readFile(boolean bl, boolean bl2) throws AppException {
        if (this.file.length() >= Integer.MAX_VALUE) {
            throw new FileException((AppException.Id)ErrorId.FILE_IS_TOO_LONG, this.file);
        }
        int n = (int)this.file.length();
        FileInputStream fileInputStream = null;
        try {
            FileChannel fileChannel = null;
            try {
                fileInputStream = new FileInputStream(this.file);
                fileChannel = fileInputStream.getChannel();
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, this.file, securityException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, this.file, fileNotFoundException);
            }
            try {
                if (fileChannel.tryLock(0L, Long.MAX_VALUE, true) == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file, exception);
            }
            try {
                return this.read(fileInputStream, this.charsetName, n, bl, bl2);
            }
            catch (AppException appException) {
                throw new FileException(appException, this.file);
            }
        }
        catch (AppException appException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw appException;
        }
    }

    protected Object readUri(boolean bl, boolean bl2) throws AppException {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = this.openConnection();
            try {
                inputStream = uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                throw new UriException((AppException.Id)ErrorId.READING_FROM_URI_NOT_SUPPORTED, this.uri);
            }
            try {
                return this.read(inputStream, this.getCharsetName(uRLConnection), uRLConnection.getContentLength(), bl, bl2);
            }
            catch (AppException appException) {
                throw new UriException(appException, this.uri);
            }
        }
        catch (AppException appException) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw appException;
        }
    }

    protected String[] readLinesFile(boolean bl, int n) throws AppException {
        FileInputStream fileInputStream = null;
        try {
            FileChannel fileChannel = null;
            try {
                fileInputStream = new FileInputStream(this.file);
                fileChannel = fileInputStream.getChannel();
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, this.file, securityException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, this.file, fileNotFoundException);
            }
            try {
                if (fileChannel.tryLock(0L, Long.MAX_VALUE, true) == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file, exception);
            }
            try {
                return this.readLines(fileInputStream, this.charsetName, bl, n);
            }
            catch (AppException appException) {
                throw new FileException(appException, this.file);
            }
        }
        catch (AppException appException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw appException;
        }
    }

    protected String[] readLinesUri(boolean bl, int n) throws AppException {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = this.openConnection();
            try {
                inputStream = uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                throw new UriException((AppException.Id)ErrorId.READING_FROM_URI_NOT_SUPPORTED, this.uri);
            }
            try {
                return this.readLines(inputStream, this.getCharsetName(uRLConnection), bl, n);
            }
            catch (AppException appException) {
                throw new UriException(appException, this.uri);
            }
        }
        catch (AppException appException) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw appException;
        }
    }

    protected void writeDirect(CharSequence charSequence, boolean bl) throws AppException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            if (this.file.exists() && !this.file.canWrite()) {
                throw new FileException((AppException.Id)ErrorId.WRITING_NOT_PERMITTED, this.file);
            }
            FileChannel fileChannel = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                fileChannel = fileOutputStream.getChannel();
                OutputStream outputStream = bl ? new GZIPOutputStream(fileOutputStream) : fileOutputStream;
                outputStreamWriter = new OutputStreamWriter(outputStream, this.charsetName);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, this.file, securityException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AppException((AppException.Id)ErrorId.UNSUPPORTED_ENCODING, this.charsetName);
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, this.file, iOException);
            }
            try {
                if (fileChannel.tryLock() == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, this.file, exception);
            }
            try {
                this.writeText(charSequence, outputStreamWriter);
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.ERROR_WRITING_FILE, this.file, iOException);
            }
            try {
                outputStreamWriter.close();
                outputStreamWriter = null;
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, this.file, iOException);
            }
        }
        catch (AppException appException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw appException;
        }
    }

    protected void writeUsingTempFile(CharSequence charSequence, boolean bl, boolean bl2) throws AppException {
        File file = null;
        OutputStreamWriter outputStreamWriter = null;
        boolean bl3 = false;
        try {
            Object object;
            if (!this.file.isFile()) {
                throw new FileException((AppException.Id)ErrorId.NOT_A_FILE, this.file);
            }
            if (!this.file.canWrite()) {
                throw new FileException((AppException.Id)ErrorId.WRITING_NOT_PERMITTED, this.file);
            }
            try {
                file = File.createTempFile(TEMP_FILE_PREFIX, null, this.file.getAbsoluteFile().getParentFile());
            }
            catch (Exception exception) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_CREATE_TEMPORARY_FILE, (Throwable)exception);
            }
            FileChannel fileChannel = null;
            try {
                object = new FileOutputStream(file);
                fileChannel = ((FileOutputStream)object).getChannel();
                OutputStream outputStream = bl ? new GZIPOutputStream((OutputStream)object) : object;
                outputStreamWriter = new OutputStreamWriter(outputStream, this.charsetName);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file, securityException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AppException((AppException.Id)ErrorId.UNSUPPORTED_ENCODING, this.charsetName);
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, file, iOException);
            }
            try {
                if (fileChannel.tryLock() == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file, exception);
            }
            try {
                this.writeText(charSequence, outputStreamWriter);
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.ERROR_WRITING_FILE, file, iOException);
            }
            try {
                outputStreamWriter.close();
                outputStreamWriter = null;
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, file, iOException);
            }
            object = null;
            if (bl2) {
                try {
                    FileAttributeUtilities.copyAttributes(this.file, file);
                }
                catch (FileAttributeUtilities.AttributesException attributesException) {
                    object = attributesException;
                }
            }
            try {
                if (!this.file.delete()) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_DELETE_FILE, this.file);
                }
                bl3 = true;
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_DELETE_FILE, this.file, securityException);
            }
            try {
                if (!file.renameTo(this.file)) {
                    throw new TempFileException((AppException.Id)ErrorId.FAILED_TO_RENAME_FILE, this.file, file);
                }
            }
            catch (SecurityException securityException) {
                throw new TempFileException((AppException.Id)ErrorId.FAILED_TO_RENAME_FILE, this.file, (Throwable)securityException, file);
            }
            if (object != null) {
                throw object;
            }
        }
        catch (AppException appException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!bl3 && file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw appException;
        }
    }

    private URLConnection openConnection() throws AppException {
        URL uRL = null;
        try {
            uRL = this.uri.toURL();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UriException((AppException.Id)ErrorId.URI_IS_NOT_ABSOLUTE, this.uri);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UriException((AppException.Id)ErrorId.FAILED_TO_CONVERT_URI_TO_URL, this.uri, malformedURLException);
        }
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new UriException((AppException.Id)ErrorId.FAILED_TO_CONNECT_TO_URI, this.uri, iOException);
        }
        uRLConnection.setConnectTimeout(30000);
        uRLConnection.setReadTimeout(30000);
        return uRLConnection;
    }

    private String getCharsetName(URLConnection uRLConnection) {
        String string = this.charsetName;
        if (string == null && !Charset.isSupported(string = uRLConnection.getContentEncoding())) {
            string = CHARSET_NAME_UTF8;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private Object read(InputStream var1_1, String var2_2, int var3_3, boolean var4_4, boolean var5_5) throws AppException {
        var6_6 = null;
        try {
            try {
                var6_6 = new InputStreamReader(var4_4 != false ? new GZIPInputStream(var1_1) : var1_1, var2_2);
            }
            catch (UnsupportedEncodingException var7_7) {
                throw new AppException((AppException.Id)ErrorId.UNSUPPORTED_ENCODING, var2_2);
            }
            catch (IOException var7_8) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, (Throwable)var7_8);
            }
            var7_9 = null;
            try {
                var7_9 = new TextBuffer(var5_5, var3_3 < 0 ? 8192 : var3_3 + 1);
                try {
                    var8_11 = new char[8192];
                    while (true) {
                        for (ProgressListener var10_20 : this.progressListeners) {
                            if (!var10_20.isOperationTerminated()) continue;
                            throw new TerminatedException();
                        }
                        var9_17 = var6_6.read(var8_11);
                        if (var9_17 > 0) {
                            TextBuffer.access$100(var7_9, var8_11, var9_17);
                            var10_19 = var3_3 < 0 ? -1.0 : (double)TextBuffer.access$200(var7_9) / (double)var3_3;
                            var12_21 = this.progressListeners.iterator();
                            while (true) {
                                if (!var12_21.hasNext()) ** continue;
                                var13_22 = var12_21.next();
                                var13_22.setProgress(var10_19);
                            }
                        }
                        break;
                    }
                }
                catch (SocketTimeoutException var8_12) {
                    throw new AppException(ErrorId.TIMED_OUT_READING_FROM_URI);
                }
                catch (IOException var8_13) {
                    throw new AppException((AppException.Id)ErrorId.ERROR_READING_FILE, (Throwable)var8_13);
                }
            }
            catch (OutOfMemoryError var8_14) {
                throw new AppException(ErrorId.NOT_ENOUGH_MEMORY_TO_READ_FILE);
            }
            try {
                var6_6.close();
                var6_6 = null;
            }
            catch (IOException var8_15) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, (Throwable)var8_15);
            }
            return TextBuffer.access$300(var7_9);
        }
        catch (AppException var7_10) {
            try {
                if (var6_6 != null) {
                    var6_6.close();
                }
            }
            catch (IOException var8_16) {
                // empty catch block
            }
            throw var7_10;
        }
    }

    private String[] readLines(InputStream inputStream, String string, boolean bl, int n) throws AppException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(bl ? new GZIPInputStream(inputStream) : inputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AppException((AppException.Id)ErrorId.UNSUPPORTED_ENCODING, string);
            }
            catch (IOException iOException) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, (Throwable)iOException);
            }
            while (n == 0 || arrayList.size() < n) {
                try {
                    try {
                        for (ProgressListener progressListener : this.progressListeners) {
                            if (!progressListener.isOperationTerminated()) continue;
                            throw new TerminatedException();
                        }
                        String string2 = bufferedReader.readLine();
                        if (string2 != null) {
                            arrayList.add(string2);
                            double d = n == 0 ? -1.0 : (double)arrayList.size() / (double)n;
                            for (ProgressListener progressListener : this.progressListeners) {
                                progressListener.setProgress(d);
                            }
                            continue;
                        }
                        break;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        throw new AppException(ErrorId.TIMED_OUT_READING_FROM_URI);
                    }
                    catch (IOException iOException) {
                        throw new AppException((AppException.Id)ErrorId.ERROR_READING_FILE, (Throwable)iOException);
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new AppException(ErrorId.NOT_ENOUGH_MEMORY_TO_READ_FILE);
                }
            }
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, (Throwable)iOException);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (AppException appException) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw appException;
        }
    }

    private void writeText(CharSequence charSequence, OutputStreamWriter outputStreamWriter) throws IOException, TerminatedException {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            for (ProgressListener progressListener : this.progressListeners) {
                if (!progressListener.isOperationTerminated()) continue;
                throw new TerminatedException();
            }
            int n3 = Math.min(n2 + 8192, n);
            outputStreamWriter.append(charSequence, n2, n3);
            n2 = n3;
            for (ProgressListener progressListener : this.progressListeners) {
                progressListener.setProgress((double)n2 / (double)n);
            }
        }
    }

    private static class TextBuffer {
        private boolean sync;
        private StringBuilder nonSyncBuffer;
        private StringBuffer syncBuffer;

        private TextBuffer(boolean bl, int n) {
            this.sync = bl;
            if (bl) {
                this.syncBuffer = new StringBuffer(n);
            } else {
                this.nonSyncBuffer = new StringBuilder(n);
            }
        }

        private Object getBuffer() {
            return this.sync ? this.syncBuffer : this.nonSyncBuffer;
        }

        private int getLength() {
            return this.sync ? this.syncBuffer.length() : this.nonSyncBuffer.length();
        }

        private void append(char[] cArray, int n) {
            if (this.sync) {
                this.syncBuffer.append(cArray, 0, n);
            } else {
                this.nonSyncBuffer.append(cArray, 0, n);
            }
        }

        static /* synthetic */ void access$100(TextBuffer textBuffer, char[] cArray, int n) {
            textBuffer.append(cArray, n);
        }

        static /* synthetic */ int access$200(TextBuffer textBuffer) {
            return textBuffer.getLength();
        }

        static /* synthetic */ Object access$300(TextBuffer textBuffer) {
            return textBuffer.getBuffer();
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        FAILED_TO_OPEN_FILE("Failed to open the file."),
        FAILED_TO_CLOSE_FILE("Failed to close the file."),
        FAILED_TO_LOCK_FILE("Failed to lock the file."),
        ERROR_READING_FILE("An error occurred when reading the file."),
        ERROR_WRITING_FILE("An error occurred when writing the file."),
        FAILED_TO_CREATE_TEMPORARY_FILE("Failed to create a temporary file."),
        FAILED_TO_DELETE_FILE("Failed to delete the existing file."),
        FAILED_TO_RENAME_FILE("Failed to rename the temporary file to the specified filename."),
        FILE_ACCESS_NOT_PERMITTED("Access to the file was not permitted."),
        WRITING_NOT_PERMITTED("Writing to the file was not permitted."),
        NOT_A_FILE("The pathname does not specify a file."),
        NOT_ENOUGH_MEMORY_TO_READ_FILE("There was not enough memory to read the file."),
        UNSUPPORTED_ENCODING("This implementation of Java does not support the %1 character encoding."),
        FILE_IS_TOO_LONG("The file is too long to be read by this program."),
        URI_IS_NOT_ABSOLUTE("The URI is not absolute."),
        FAILED_TO_CONVERT_URI_TO_URL("Failed to convert the URI to a URL."),
        FAILED_TO_CONNECT_TO_URI("Failed to open a connection to the URI."),
        READING_FROM_URI_NOT_SUPPORTED("Reading from the URI is not supported."),
        TIMED_OUT_READING_FROM_URI("Timed out when reading from the URI.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

