/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.exception.TerminatedException;
import functionplotter.util.AbstractBinaryFile;
import functionplotter.util.FileWritingMode;
import functionplotter.util.ProgressListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class PngOutputFile
extends AbstractBinaryFile {
    private static final String PNG_STR = "png";
    private RenderedImage image;

    public PngOutputFile(File file, RenderedImage renderedImage) {
        super(file);
        this.image = renderedImage;
    }

    public static void write(File file, RenderedImage renderedImage) throws AppException {
        new PngOutputFile(file, renderedImage).write(FileWritingMode.DIRECT);
    }

    public static void write(File file, RenderedImage renderedImage, FileWritingMode fileWritingMode) throws AppException {
        new PngOutputFile(file, renderedImage).write(fileWritingMode);
    }

    @Override
    public void writeData(OutputStream outputStream) throws AppException {
        for (ProgressListener progressListener : this.progressListeners) {
            if (!progressListener.isOperationTerminated()) continue;
            throw new TerminatedException();
        }
        try {
            if (!ImageIO.write(this.image, PNG_STR, outputStream)) {
                throw new AppException(ErrorId.PNG_NOT_SUPPORTED);
            }
        }
        catch (IOException iOException) {
            throw new FileException((AppException.Id)ErrorId.ERROR_WRITING_FILE, this.file, iOException);
        }
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.setProgress(1.0);
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        ERROR_WRITING_FILE("An error occurred when writing the file."),
        PNG_NOT_SUPPORTED("This implementation of Java does not support the writing of PNG files.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

