/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.exception.AppException;
import functionplotter.gui.FButton;
import functionplotter.gui.FTextArea2;
import functionplotter.gui.GuiUtilities;
import functionplotter.util.KeyAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class NonEditableTextAreaDialog
extends JDialog
implements ActionListener {
    private static final int TEXT_AREA_VERTICAL_MARGIN = 2;
    private static final int TEXT_AREA_HORIZONTAL_MARGIN = 4;
    private static final String CLEAR_STR = "Clear";
    private static final String COPY_STR = "Copy";
    private static final String CLEAR_TOOLTIP_STR = "Clear text (Alt+X)";
    private static final String COPY_TOOLTIP_STR = "Copy text to clipboard (Alt+C)";
    private static final String CLIPBOARD_ERROR_STR = "Clipboard Error";
    private static final KeyAction.CommandMap[] KEY_COMMANDS = new KeyAction.CommandMap[]{new KeyAction.CommandMap(KeyStroke.getKeyStroke(27, 0), "close")};
    private static Map<String, Point> locations = new Hashtable<String, Point>();
    private String key;
    private boolean cleared;
    private JTextArea textArea;
    private JButton clearButton;
    private JButton copyButton;
    private JButton closeButton;

    protected NonEditableTextAreaDialog(Window window, String string, String string2, int n, int n2, String string3) {
        this(window, string, string2, n, n2, string3, false);
    }

    protected NonEditableTextAreaDialog(Window window, String string, String string2, int n, int n2, String string3, boolean bl) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        if (window != null) {
            this.setIconImages(window.getIconImages());
        }
        this.key = string2;
        this.textArea = new FTextArea2(string3);
        this.textArea.setEditable(false);
        this.textArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 22, 32);
        FontMetrics fontMetrics = this.textArea.getFontMetrics(this.textArea.getFont());
        int n3 = n * GuiUtilities.getCharWidth(48, fontMetrics);
        int n4 = n2 * fontMetrics.getHeight();
        jScrollPane.getViewport().setPreferredSize(new Dimension(n3, n4));
        GuiUtilities.setViewportBorder(jScrollPane, 2, 4);
        this.setTextAreaAttributes();
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 24, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 8, 3, 8));
        if (bl) {
            this.clearButton = new FButton(CLEAR_STR);
            this.clearButton.setMnemonic(88);
            this.clearButton.setToolTipText(CLEAR_TOOLTIP_STR);
            this.clearButton.setActionCommand("clear");
            this.clearButton.addActionListener(this);
            jPanel.add(this.clearButton);
        }
        this.copyButton = new FButton(COPY_STR);
        this.copyButton.setMnemonic(67);
        this.copyButton.setToolTipText(COPY_TOOLTIP_STR);
        this.copyButton.setActionCommand("copy");
        this.copyButton.addActionListener(this);
        jPanel.add(this.copyButton);
        this.closeButton = new FButton("Close");
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        jPanel.add(this.closeButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        int n5 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 0, 2, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        KeyAction.create((JComponent)jPanel2, 1, KEY_COMMANDS, (ActionListener)this);
        this.setContentPane(jPanel2);
        this.updateComponents();
        this.applyOrientation();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowEventHandler());
        this.setResizable(false);
        this.pack();
        Point point = locations.get(string2);
        if (point == null) {
            point = GuiUtilities.getComponentLocation((Component)this, window);
        }
        this.setLocation(point);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("clear")) {
            this.doClear();
        } else if (string.equals("copy")) {
            this.doCopy();
        } else if (string.equals("close")) {
            this.doClose();
        }
    }

    public boolean isCleared() {
        return this.cleared;
    }

    protected JTextArea getTextArea() {
        return this.textArea;
    }

    protected void setTextAreaAttributes() {
    }

    protected void applyOrientation() {
    }

    private void updateComponents() {
        if (this.textArea.getText().isEmpty()) {
            this.copyButton.setEnabled(false);
            this.closeButton.requestFocusInWindow();
        }
    }

    private void doClear() {
        if (this.clearButton != null) {
            this.textArea.setText(null);
            this.clearButton.setEnabled(false);
            this.cleared = true;
            this.updateComponents();
        }
    }

    private void doCopy() {
        StringSelection stringSelection = new StringSelection(this.textArea.getText());
        try {
            try {
                this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
            catch (IllegalStateException illegalStateException) {
                throw new AppException((AppException.Id)ErrorId.CLIPBOARD_UNAVAILABLE, (Throwable)illegalStateException);
            }
        }
        catch (AppException appException) {
            JOptionPane.showMessageDialog(this, appException, CLIPBOARD_ERROR_STR, 0);
        }
    }

    private void doClose() {
        locations.put(this.key, this.getLocation());
        this.setVisible(false);
        this.dispose();
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            NonEditableTextAreaDialog.this.doClose();
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        CLIPBOARD_UNAVAILABLE("The clipboard is currently unavailable.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface Command {
        public static final String CLEAR = "clear";
        public static final String COPY = "copy";
        public static final String CLOSE = "close";
    }
}

