/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.Colours;
import functionplotter.gui.TextRendering;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxRenderer
extends JComponent
implements ListCellRenderer {
    private static final int TOP_MARGIN = 1;
    private static final int BOTTOM_MARGIN = 1;
    private static final int LEADING_MARGIN = 3;
    private static final int TRAILING_MARGIN = 5;
    private int maxTextWidth;
    private int textWidth;
    private int textHeight;
    private String text;
    private boolean leftToRight;
    private Color backgroundColour;
    private Color foregroundColour;
    private Color selectionBackgroundColour;
    private Color selectionForegroundColour;

    public ComboBoxRenderer() {
        this.setOpaque(true);
        this.setFocusable(false);
    }

    public ComboBoxRenderer(int n) {
        this();
        this.maxTextWidth = n;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setBackground(bl ? (this.selectionBackgroundColour == null ? jList.getSelectionBackground() : this.selectionBackgroundColour) : (this.backgroundColour == null ? jList.getBackground() : this.backgroundColour));
        this.setForeground(bl ? (this.selectionForegroundColour == null ? jList.getSelectionForeground() : this.selectionForegroundColour) : (this.foregroundColour == null ? jList.getForeground() : this.foregroundColour));
        this.setFont(jList.getFont());
        this.text = object == null ? new String() : object.toString();
        this.leftToRight = jList.getComponentOrientation().isLeftToRight();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.textWidth = fontMetrics.stringWidth(this.text);
        if (this.maxTextWidth > 0 && this.textWidth > this.maxTextWidth) {
            int n2 = this.maxTextWidth - fontMetrics.stringWidth("...");
            char[] cArray = this.text.toCharArray();
            int n3 = cArray.length;
            while (n3 > 0 && this.textWidth > n2) {
                this.textWidth -= fontMetrics.charWidth(cArray[--n3]);
            }
            this.text = new String(cArray, 0, n3) + "...";
        }
        this.textHeight = fontMetrics.getHeight();
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.maxTextWidth > 0 ? this.maxTextWidth : this.textWidth;
        return new Dimension(3 + n + 5, 1 + this.textHeight + 1);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics = graphics.create();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        TextRendering.setHints((Graphics2D)graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.leftToRight ? 3 : this.getWidth() - 3 - fontMetrics.stringWidth(this.text);
        graphics.setColor(this.getForeground());
        graphics.drawString(this.text, n, 1 + fontMetrics.getAscent());
    }

    public void setDefaultColours() {
        this.backgroundColour = Colours.BACKGROUND;
        this.foregroundColour = Colours.FOREGROUND;
        this.selectionBackgroundColour = Colours.FOCUSED_SELECTION_BACKGROUND;
        this.selectionForegroundColour = Colours.FOCUSED_SELECTION_FOREGROUND;
    }

    public void setBackgroundColour(Color color) {
        this.backgroundColour = color;
    }

    public void setForegroundColour(Color color) {
        this.foregroundColour = color;
    }

    public void setSelectionBackgroundColour(Color color) {
        this.selectionBackgroundColour = color;
    }

    public void setSelectionForegroundColour(Color color) {
        this.selectionForegroundColour = color;
    }
}

