/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.util.InputModifiers;
import functionplotter.util.KeyAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractSpinner
extends JSpinner
implements ActionListener,
ChangeListener,
FocusListener,
MouseWheelListener {
    protected boolean alwaysUpdate;

    protected AbstractSpinner(SpinnerModel spinnerModel, boolean bl) {
        super(spinnerModel);
        this.alwaysUpdate = bl;
        this.addChangeListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("decrement.")) {
            this.doDecrement(string.substring("decrement.".length()));
        } else if (string.startsWith("increment.")) {
            this.doIncrement(string.substring("increment.".length()));
        } else if (string.equals("commitEdit")) {
            this.doCommitEdit();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateEditorValue();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.updateValue();
    }

    public abstract void updateValue();

    protected abstract void updateEditorValue();

    protected abstract void incrementValue(int var1);

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n;
        if (this.getEditor().isFocusOwner() && (n = this.getModifierFactor(InputModifiers.get(mouseWheelEvent))) != 0) {
            this.incrementValue(n * -mouseWheelEvent.getWheelRotation());
        }
    }

    protected int getModifierFactor(InputModifiers inputModifiers) {
        int n = 0;
        switch (inputModifiers) {
            case NONE: {
                n = 1;
                break;
            }
            case CTRL: {
                n = 10;
                break;
            }
            case SHIFT: {
                n = 100;
                break;
            }
            case CTRL_SHIFT: {
                n = 1000;
            }
        }
        return n;
    }

    protected void addEditorActions() {
        this.addIncDecAction(128);
        this.addIncDecAction(64);
        this.addIncDecAction(192);
    }

    private void addAction(int n, int n2, String string) {
        KeyAction.create(this.getEditor(), 0, KeyStroke.getKeyStroke(n, n2), string, this);
    }

    private void addIncDecAction(int n) {
        this.addAction(38, n, "increment." + n);
        this.addAction(40, n, "decrement." + n);
    }

    private void doDecrement(String string) {
        this.incrementValue(-this.getModifierFactor(InputModifiers.get(Integer.parseInt(string))));
    }

    private void doIncrement(String string) {
        this.incrementValue(this.getModifierFactor(InputModifiers.get(Integer.parseInt(string))));
    }

    private void doCommitEdit() {
        this.updateValue();
    }

    protected static interface Command {
        public static final String DECREMENT = "decrement.";
        public static final String INCREMENT = "increment.";
        public static final String COMMIT_EDIT = "commitEdit";
    }
}

