/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.AbstractSpinner;
import functionplotter.textfield.IntegerValueField;
import javax.swing.BorderFactory;
import javax.swing.SpinnerNumberModel;

public abstract class AbstractIntegerSpinner
extends AbstractSpinner {
    private static final int STEP_SIZE = 1;
    protected IntegerValueField editor;

    public AbstractIntegerSpinner(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public AbstractIntegerSpinner(int n, int n2, int n3, boolean bl) {
        super(new SpinnerNumberModel(n, n2, n3, 1), bl);
    }

    public AbstractIntegerSpinner(int n, int n2, int n3, IntegerValueField integerValueField) {
        this(n, n2, n3, integerValueField, false);
    }

    public AbstractIntegerSpinner(int n, int n2, int n3, IntegerValueField integerValueField, boolean bl) {
        this(n, n2, n3, bl);
        this.initEditor(integerValueField);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.editor == null ? super.requestFocusInWindow() : this.editor.requestFocusInWindow();
    }

    @Override
    public void updateValue() {
        try {
            int n = this.getEditorValue();
            int n2 = this.getBoundedValue(n);
            this.setIntValue(n2);
            if (this.alwaysUpdate || n != n2 || this.isEditorInvalid()) {
                this.setEditorValue(n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected void updateEditorValue() {
        this.setEditorValue(this.getIntValue());
    }

    @Override
    protected void incrementValue(int n) {
        long l = Math.min(Math.max(Integer.MIN_VALUE, (long)this.getIntValue() + (long)n), Integer.MAX_VALUE);
        this.setIntValue(this.getBoundedValue((int)l));
    }

    public int getIntValue() {
        return (Integer)this.getValue();
    }

    public void setIntValue(int n) {
        this.setValue(new Integer(n));
    }

    public void setMinimum(int n) {
        ((SpinnerNumberModel)this.getModel()).setMinimum(new Integer(n));
        this.setIntValue(this.getBoundedValue(this.getIntValue()));
    }

    public void setMaximum(int n) {
        ((SpinnerNumberModel)this.getModel()).setMaximum(new Integer(n));
        this.setIntValue(this.getBoundedValue(this.getIntValue()));
    }

    protected void initEditor(IntegerValueField integerValueField) {
        this.editor = integerValueField;
        integerValueField.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.setEditor(integerValueField);
        this.updateEditorValue();
        this.addEditorActions();
        integerValueField.setActionCommand("commitEdit");
        integerValueField.addActionListener(this);
        integerValueField.addFocusListener(this);
    }

    protected int getEditorValue() throws IllegalArgumentException {
        return this.editor.getValue();
    }

    protected void setEditorValue(int n) {
        this.editor.setValue(n);
    }

    protected boolean isEditorInvalid() {
        return false;
    }

    protected int getBoundedValue(int n) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
        int n2 = (Integer)spinnerNumberModel.getMinimum();
        int n3 = (Integer)spinnerNumberModel.getMaximum();
        return Math.min(Math.max(n2, n), n3);
    }
}

