/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.exception;

import functionplotter.util.StringUtilities;

public class AppException
extends Exception {
    private static final int DEFAULT_MAX_CAUSE_MESSAGE_LINE_LENGTH = 96;
    private static final String NO_ERROR_STR = "No error";
    private static int maxCauseMessageLineLength = 96;
    private Id id;
    private String[] substitutionStrs;

    public AppException() {
    }

    public AppException(String string) {
        this(new AnonymousId(string));
    }

    public AppException(String string, String string2) {
        this((Id)new AnonymousId(string), string2);
    }

    public AppException(String string, String[] stringArray) {
        this((Id)new AnonymousId(string), stringArray);
    }

    public AppException(String string, Throwable throwable) {
        this((Id)new AnonymousId(string), throwable);
    }

    public AppException(String string, Throwable throwable, String string2) {
        this((Id)new AnonymousId(string), throwable, string2);
    }

    public AppException(String string, Throwable throwable, String[] stringArray) {
        this((Id)new AnonymousId(string), throwable, stringArray);
    }

    public AppException(Id id) {
        super(AppException.getString(id));
        this.id = id;
    }

    public AppException(Id id, String string) {
        this(id);
        this.setSubstitutionString(string);
    }

    public AppException(Id id, String[] stringArray) {
        this(id);
        this.setSubstitutionStrings(stringArray);
    }

    public AppException(Id id, Throwable throwable) {
        super(AppException.getString(id), throwable);
        this.id = id;
    }

    public AppException(Id id, Throwable throwable, String string) {
        this(id, throwable);
        this.setSubstitutionString(string);
    }

    public AppException(Id id, Throwable throwable, String[] stringArray) {
        this(id, throwable);
        this.setSubstitutionStrings(stringArray);
    }

    public static int getMaxCauseMessageLineLength() {
        return maxCauseMessageLineLength;
    }

    public static String getString(Id id) {
        return id == null ? NO_ERROR_STR : id.getMessage();
    }

    public static void setMaxCauseMessageLineLength(int n) {
        maxCauseMessageLineLength = n;
    }

    protected static String createString(String string, String string2, String string3, String[] stringArray, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(stringArray == null ? string : StringUtilities.substitute(string, stringArray));
            if (string3 != null) {
                stringBuilder.append(string3);
            }
        }
        if (throwable != null) {
            String string4 = throwable.getMessage();
            if (string4 == null) {
                string4 = throwable.toString();
            }
            stringBuilder.append("\n[");
            int n = 0;
            while (n < string4.length()) {
                boolean bl = false;
                int n2 = n;
                int n3 = n + Math.max(1, maxCauseMessageLineLength);
                for (int i = n; i <= n3 || n2 == n; ++i) {
                    if (i == string4.length()) {
                        if (bl) break;
                        n2 = i;
                        break;
                    }
                    if (string4.charAt(i) == ' ') {
                        if (bl) continue;
                        bl = true;
                        n2 = i;
                        continue;
                    }
                    bl = false;
                }
                if (n2 - n > 0) {
                    stringBuilder.append(string4.substring(n, n2));
                }
                stringBuilder.append('\n');
                for (n = n2; n < string4.length() && string4.charAt(n) == ' '; ++n) {
                }
            }
            n = stringBuilder.length();
            while (--n >= 0 && Character.isWhitespace(stringBuilder.charAt(n))) {
            }
            stringBuilder.setLength(++n);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return AppException.createString(this.getMessage(), this.getPrefix(), this.getSuffix(), this.substitutionStrs, this.getCause());
    }

    public Id getId() {
        return this.id;
    }

    public String[] getSubstitutionStrings() {
        return this.substitutionStrs;
    }

    public void clearSubstitutionStrings() {
        this.substitutionStrs = null;
    }

    public void setSubstitutionStrings(String[] stringArray) {
        this.substitutionStrs = stringArray;
    }

    public void setSubstitutionString(String string) {
        this.substitutionStrs = new String[1];
        this.substitutionStrs[0] = string;
    }

    public void setSubstitutionDecValue(int n) {
        this.setSubstitutionString(Integer.toString(n));
    }

    protected String getPrefix() {
        return null;
    }

    protected String getSuffix() {
        return null;
    }

    protected static class AnonymousId
    implements Id {
        private String message;

        protected AnonymousId(String string) {
            this.message = string;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static interface Id {
        public String getMessage();
    }
}

