/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.AppConfig;
import functionplotter.AppConstants;
import functionplotter.AppFont;
import functionplotter.Function;
import functionplotter.FunctionDocument;
import functionplotter.PlotInterval;
import functionplotter.PlotPanel;
import functionplotter.SurrogateMinus;
import functionplotter.Util;
import functionplotter.exception.AppException;
import functionplotter.gui.Colours;
import functionplotter.gui.FButton;
import functionplotter.gui.FCheckBoxMenuItem;
import functionplotter.gui.FComboBox;
import functionplotter.gui.FLabel;
import functionplotter.gui.FMenuItem;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.SingleSelectionList;
import functionplotter.gui.TextRendering;
import functionplotter.util.InputModifiers;
import functionplotter.util.KeyAction;
import functionplotter.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FunctionView
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
SingleSelectionList.ModelListener {
    public static final int MIN_FUNCTION_LIST_NUM_COLUMNS = 8;
    public static final int MAX_FUNCTION_LIST_NUM_COLUMNS = 80;
    public static final int MIN_FUNCTION_LIST_NUM_ROWS = 1;
    public static final int MAX_FUNCTION_LIST_NUM_ROWS = 20;
    private static final int INTERVAL_EP_NUM_COLUMNS = 22;
    private static final String CURSOR_STR = "Cursor:";
    private static final String X_INTERVAL_STR = "x:";
    private static final String Y_INTERVAL_STR = "y:";
    private static final String TO_STR = "to";
    private static final String X_ZOOM_STR = "x zoom:";
    private static final String Y_ZOOM_STR = "y zoom:";
    private static final String[] ZOOM_FACTOR_STRS = new String[]{"1.1", "1.2", "1.25", "1.5", "2", "3", "4", "5", "10"};
    private static final String DEFAULT_ZOOM_FACTOR_STR = "1.5";
    private static final String[] COMMAND_MAP = new String[]{"editElement", "editFunction", "deleteElement", "confirmDeleteFunction", "deleteExElement", "deleteFunction", "moveElementUp", "moveFunctionUp", "moveElementDown", "moveFunctionDown", "dragElement", "moveFunction"};
    private static final KeyAction.ActionMap[] APPLET_VIEW_KEY_ACTIONS = new KeyAction.ActionMap[]{new KeyAction.ActionMap(KeyStroke.getKeyStroke(71, 128), FunctionDocument.Command.SHOW_GRID), new KeyAction.ActionMap(KeyStroke.getKeyStroke(90, 128), FunctionDocument.Command.UNDO), new KeyAction.ActionMap(KeyStroke.getKeyStroke(89, 128), FunctionDocument.Command.REDO)};
    private static final KeyAction.ActionMap[] PLOT_PANEL_KEY_ACTIONS = new KeyAction.ActionMap[]{new KeyAction.ActionMap(KeyStroke.getKeyStroke(37, 0), FunctionDocument.Command.SCROLL_LEFT), new KeyAction.ActionMap(KeyStroke.getKeyStroke(39, 0), FunctionDocument.Command.SCROLL_RIGHT), new KeyAction.ActionMap(KeyStroke.getKeyStroke(40, 0), FunctionDocument.Command.SCROLL_DOWN), new KeyAction.ActionMap(KeyStroke.getKeyStroke(38, 0), FunctionDocument.Command.SCROLL_UP), new KeyAction.ActionMap(KeyStroke.getKeyStroke(36, 0), FunctionDocument.Command.CENTRE_ON_ORIGIN)};
    private static Dimension plotSize;
    private static Dimension functionListSize;
    private static String xZoomFactorStr;
    private static String yZoomFactorStr;
    private static JPopupMenu popUpMenu;
    private FunctionDocument document;
    private PlotPanel plotPanel;
    private FunctionList functionList;
    private JScrollPane functionListScrollPane;
    private CoordinatesField coordinatesField;
    private EndpointField xLowerEndpointField;
    private EndpointField xUpperEndpointField;
    private EndpointField yLowerEndpointField;
    private EndpointField yUpperEndpointField;
    private JButton addButton;
    private JButton deleteButton;
    private JComboBox xZoomFactorComboBox;
    private JComboBox yZoomFactorComboBox;
    private Point mouseCursorLocation;
    private DragStart dragStart;

    public FunctionView(FunctionDocument functionDocument) {
        JComponent jComponent;
        FunctionButton functionButton;
        JComponent jComponent2;
        this.document = functionDocument;
        AppConfig appConfig = AppConfig.getInstance();
        if (plotSize == null) {
            plotSize = new Dimension(appConfig.getPlotSize());
        }
        if (functionListSize == null) {
            functionListSize = new Dimension(appConfig.getFunctionListSize());
        }
        Color color = appConfig.getBackgroundColour();
        this.plotPanel = new PlotPanel(functionDocument, FunctionView.plotSize.width + 1, FunctionView.plotSize.height + 1, appConfig.isShowGrid());
        this.plotPanel.setBackground(color);
        this.plotPanel.addChangeListener(this);
        this.plotPanel.addMouseListener(this);
        this.plotPanel.addMouseMotionListener(this);
        this.plotPanel.addMouseWheelListener(this);
        KeyAction.create((JComponent)this.plotPanel, 0, PLOT_PANEL_KEY_ACTIONS);
        this.functionList = new FunctionList(functionDocument, FunctionView.functionListSize.width, FunctionView.functionListSize.height);
        this.functionList.addActionListener(this);
        this.functionList.addListSelectionListener(this);
        this.functionList.addModelListener(this);
        this.functionList.addMouseListener(this);
        KeyAction.create((JComponent)this.functionList, 0, KeyStroke.getKeyStroke(67, 128), FunctionDocument.Command.COPY_FUNCTION);
        this.functionListScrollPane = new JScrollPane(this.functionList, FunctionView.functionListSize.height < 20 ? 22 : 21, 31);
        this.functionListScrollPane.setWheelScrollingEnabled(false);
        this.functionListScrollPane.getVerticalScrollBar().setFocusable(false);
        this.functionListScrollPane.getVerticalScrollBar().getModel().addChangeListener(this);
        this.functionList.setViewport(this.functionListScrollPane.getViewport());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jPanel.setBackground(color);
        int n = 0;
        FunctionButton.reset();
        this.addButton = new FunctionButton(FunctionDocument.Command.ADD_FUNCTION);
        this.addButton.setMnemonic(65);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        jPanel.add(this.addButton);
        FunctionButton functionButton2 = new FunctionButton(FunctionDocument.Command.EDIT_FUNCTION);
        functionButton2.setMnemonic(84);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(functionButton2, gridBagConstraints);
        jPanel.add(functionButton2);
        FunctionButton functionButton3 = new FunctionButton(FunctionDocument.Command.COPY_FUNCTION);
        functionButton3.setMnemonic(67);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(functionButton3, gridBagConstraints);
        jPanel.add(functionButton3);
        if (App.getInstance().isApplet()) {
            jComponent2 = GuiUtilities.createFiller(8, 1);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            jPanel.add(jComponent2);
            functionButton = new FunctionButton(FunctionDocument.Command.UNDO);
            functionButton.setMnemonic(85);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(functionButton, gridBagConstraints);
            jPanel.add(functionButton);
        }
        n = 0;
        jComponent2 = new FunctionButton(FunctionDocument.Command.HIDE_SHOW_FUNCTION);
        ((AbstractButton)jComponent2).setMnemonic(72);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jPanel.add(jComponent2);
        this.deleteButton = new FunctionButton(FunctionDocument.Command.DELETE_FUNCTION);
        this.deleteButton.setMnemonic(68);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.deleteButton, gridBagConstraints);
        jPanel.add(this.deleteButton);
        functionButton = new FunctionButton(FunctionDocument.Command.CLEAR_FUNCTIONS);
        functionButton.setMnemonic(76);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(functionButton, gridBagConstraints);
        jPanel.add(functionButton);
        if (App.getInstance().isApplet()) {
            jComponent = GuiUtilities.createFiller(8, 1);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
            FunctionButton functionButton4 = new FunctionButton(FunctionDocument.Command.REDO);
            functionButton4.setMnemonic(82);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(functionButton4, gridBagConstraints);
            jPanel.add(functionButton4);
        }
        FunctionButton.updateWidth();
        this.updateButtons();
        jComponent = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jComponent, 4);
        jComponent.setBackground(color);
        int n2 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        gridBagLayout.setConstraints(this.functionListScrollPane, gridBagConstraints);
        jComponent.add(this.functionListScrollPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jComponent.add(jPanel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel2);
        jPanel2.setBackground(color);
        n = 0;
        FLabel fLabel = new FLabel(CURSOR_STR);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel, gridBagConstraints);
        jPanel2.add(fLabel);
        this.coordinatesField = new CoordinatesField();
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.coordinatesField, gridBagConstraints);
        jPanel2.add(this.coordinatesField);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel3);
        jPanel3.setBackground(color);
        n = 0;
        FLabel fLabel2 = new FLabel(X_INTERVAL_STR);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel2, gridBagConstraints);
        jPanel3.add(fLabel2);
        this.xLowerEndpointField = new EndpointField(22);
        this.xLowerEndpointField.setActionCommand("setXInterval");
        this.xLowerEndpointField.addActionListener(this);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.xLowerEndpointField, gridBagConstraints);
        jPanel3.add(this.xLowerEndpointField);
        FLabel fLabel3 = new FLabel(TO_STR);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagLayout.setConstraints(fLabel3, gridBagConstraints);
        jPanel3.add(fLabel3);
        this.xUpperEndpointField = new EndpointField(22);
        this.xUpperEndpointField.setActionCommand("setXInterval");
        this.xUpperEndpointField.addActionListener(this);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.xUpperEndpointField, gridBagConstraints);
        jPanel3.add(this.xUpperEndpointField);
        n = 0;
        FLabel fLabel4 = new FLabel(Y_INTERVAL_STR);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel4, gridBagConstraints);
        jPanel3.add(fLabel4);
        this.yLowerEndpointField = new EndpointField(22);
        this.yLowerEndpointField.setActionCommand("setYInterval");
        this.yLowerEndpointField.addActionListener(this);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.yLowerEndpointField, gridBagConstraints);
        jPanel3.add(this.yLowerEndpointField);
        FLabel fLabel5 = new FLabel(TO_STR);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagLayout.setConstraints(fLabel5, gridBagConstraints);
        jPanel3.add(fLabel5);
        this.yUpperEndpointField = new EndpointField(22);
        this.yUpperEndpointField.setActionCommand("setYInterval");
        this.yUpperEndpointField.addActionListener(this);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.yUpperEndpointField, gridBagConstraints);
        jPanel3.add(this.yUpperEndpointField);
        this.updateIntervalFields();
        JPanel jPanel4 = new JPanel(new GridLayout(0, 3, 1, 1));
        GuiUtilities.setPaddedLineBorder((JComponent)jPanel4, 4);
        Color color2 = GuiUtilities.scaleColourBrightness(color, 0.9375f);
        jPanel4.setBackground(color2);
        jPanel4.add(GuiUtilities.createFiller());
        jPanel4.add(new ScrollButton(FunctionDocument.Command.SCROLL_UP));
        jPanel4.add(GuiUtilities.createFiller());
        jPanel4.add(new ScrollButton(FunctionDocument.Command.SCROLL_LEFT));
        jPanel4.add(new ScrollButton(FunctionDocument.Command.CENTRE_ON_ORIGIN));
        jPanel4.add(new ScrollButton(FunctionDocument.Command.SCROLL_RIGHT));
        jPanel4.add(GuiUtilities.createFiller());
        jPanel4.add(new ScrollButton(FunctionDocument.Command.SCROLL_DOWN));
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBackground(color);
        n = 0;
        FLabel fLabel6 = new FLabel(X_ZOOM_STR);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel6, gridBagConstraints);
        jPanel5.add(fLabel6);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 0, 4, 0));
        GuiUtilities.setPaddedLineBorder((JComponent)jPanel6, 4);
        jPanel6.setBackground(color2);
        jPanel6.add(new ZoomButton(FunctionDocument.Command.X_ZOOM_IN));
        jPanel6.add(new ZoomButton(FunctionDocument.Command.X_ZOOM_OUT));
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel5.add(jPanel6);
        this.xZoomFactorComboBox = new FComboBox(ZOOM_FACTOR_STRS);
        this.xZoomFactorComboBox.setSelectedItem(xZoomFactorStr);
        this.xZoomFactorComboBox.setActionCommand("selectXZoomFactor");
        this.xZoomFactorComboBox.addActionListener(this);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.xZoomFactorComboBox, gridBagConstraints);
        jPanel5.add(this.xZoomFactorComboBox);
        JPanel jPanel7 = new JPanel(gridBagLayout);
        jPanel7.setBackground(color);
        n = 0;
        FLabel fLabel7 = new FLabel(Y_ZOOM_STR);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel7, gridBagConstraints);
        jPanel7.add(fLabel7);
        JPanel jPanel8 = new JPanel(new GridLayout(1, 0, 4, 0));
        GuiUtilities.setPaddedLineBorder((JComponent)jPanel8, 4);
        jPanel8.setBackground(color2);
        jPanel8.add(new ZoomButton(FunctionDocument.Command.Y_ZOOM_IN));
        jPanel8.add(new ZoomButton(FunctionDocument.Command.Y_ZOOM_OUT));
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jPanel8, gridBagConstraints);
        jPanel7.add(jPanel8);
        this.yZoomFactorComboBox = new FComboBox(ZOOM_FACTOR_STRS);
        this.yZoomFactorComboBox.setSelectedItem(yZoomFactorStr);
        this.yZoomFactorComboBox.setActionCommand("selectYZoomFactor");
        this.yZoomFactorComboBox.addActionListener(this);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.yZoomFactorComboBox, gridBagConstraints);
        jPanel7.add(this.yZoomFactorComboBox);
        JPanel jPanel9 = new JPanel(gridBagLayout);
        jPanel9.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        jPanel9.setBackground(color);
        n2 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel9.add(jPanel5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel9.add(jPanel7);
        JPanel jPanel10 = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder((JComponent)jPanel10, 4, 6);
        jPanel10.setBackground(color);
        n = 0;
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel10.add(jPanel4);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jPanel9, gridBagConstraints);
        jPanel10.add(jPanel9);
        JPanel jPanel11 = new JPanel(gridBagLayout);
        jPanel11.setBackground(color);
        n2 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel11.add(jComponent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel11.add(jPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel11.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel10, gridBagConstraints);
        jPanel11.add(jPanel10);
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setBackground(color);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.plotPanel, gridBagConstraints);
        this.add(this.plotPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagLayout.setConstraints(jPanel11, gridBagConstraints);
        this.add(jPanel11);
        App.applyOrientationByLocale(this);
        jPanel4.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.addMouseListener(this);
        KeyAction.create(this, 1, KeyStroke.getKeyStroke(525, 0), "showPopUpMenu", this);
        if (App.getInstance().isApplet()) {
            KeyAction.create((JComponent)this, 1, APPLET_VIEW_KEY_ACTIONS);
        }
    }

    public static double getXZoomFactor() {
        return Double.parseDouble(xZoomFactorStr);
    }

    public static double getYZoomFactor() {
        return Double.parseDouble(yZoomFactorStr);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = Util.mapString(COMMAND_MAP, actionEvent.getActionCommand());
            if (string.equals("editFunction")) {
                this.doEditFunction();
            } else if (string.equals("deleteFunction")) {
                this.doDeleteFunction();
            } else if (string.equals("confirmDeleteFunction")) {
                this.doConfirmDeleteFunction();
            } else if (string.equals("moveFunctionUp")) {
                this.doMoveFunctionUp();
            } else if (string.equals("moveFunctionDown")) {
                this.doMoveFunctionDown();
            } else if (string.equals("moveFunction")) {
                this.doMoveFunction();
            } else if (string.equals("setXInterval")) {
                this.doSetXInterval();
            } else if (string.equals("setYInterval")) {
                this.doSetYInterval();
            } else if (string.equals("selectXZoomFactor")) {
                this.doSelectXZoomFactor();
            } else if (string.equals("selectYZoomFactor")) {
                this.doSelectYZoomFactor();
            } else if (string.equals("showPopUpMenu")) {
                this.doShowPopUpMenu();
            }
        }
        catch (AppException appException) {
            App.getInstance().showErrorMessage("FuncPlotter", appException);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.plotPanel) {
            this.updateIntervalFields();
            this.updateMouseCursorCoords();
        } else if (object == this.functionListScrollPane.getVerticalScrollBar().getModel() && !this.functionListScrollPane.getVerticalScrollBar().getValueIsAdjusting() && !this.functionList.isDragging()) {
            this.functionList.snapViewPosition();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateButtons();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.plotPanel) {
            this.updateMouseCursorCoords(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.plotPanel) {
            this.updateMouseCursorCoords((MouseEvent)null);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent() == this.plotPanel) {
            this.dragStart = new DragStart(mouseEvent.getX(), mouseEvent.getY(), this.document.getXInterval(), this.document.getYInterval());
            this.plotPanel.setCursor(true);
        }
        this.showPopUpMenu(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.dragStart != null) {
            this.setIntervals(mouseEvent, true);
            this.dragStart = null;
            this.plotPanel.setCursor(false);
        }
        this.showPopUpMenu(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragStart != null) {
            this.setIntervals(mouseEvent, false);
        }
        this.updateMouseCursorCoords(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateMouseCursorCoords(mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        FunctionDocument.Command command = null;
        InputModifiers inputModifiers = InputModifiers.get(mouseWheelEvent);
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            n = -n;
            switch (inputModifiers) {
                case NONE: {
                    command = FunctionDocument.Command.SCROLL_UP;
                    break;
                }
                case CTRL: {
                    command = FunctionDocument.Command.SCROLL_RIGHT;
                }
            }
        } else {
            switch (inputModifiers) {
                case NONE: {
                    command = FunctionDocument.Command.SCROLL_DOWN;
                    break;
                }
                case CTRL: {
                    command = FunctionDocument.Command.SCROLL_LEFT;
                }
            }
        }
        if (command != null) {
            while (--n >= 0) {
                command.execute();
            }
        }
    }

    @Override
    public void modelChanged(SingleSelectionList.ModelEvent modelEvent) {
        this.updatePlot();
    }

    public PlotPanel getPlotPanel() {
        return this.plotPanel;
    }

    public FunctionList getFunctionList() {
        return this.functionList;
    }

    public int getSelectedIndex() {
        return this.functionList.getSelectedIndex();
    }

    public void setDefaultFocus() {
        if (this.document.hasFunctions()) {
            this.functionList.setSelectedIndex(0);
            this.functionList.requestFocusInWindow();
        } else {
            this.addButton.requestFocusInWindow();
        }
    }

    public void updatePlot() {
        this.plotPanel.repaint();
    }

    public void updateFunctionList() {
        this.functionList.repaint();
    }

    public void updateButtons() {
        this.document.updateCommands();
        Util.moveFocus(SwingUtilities.getWindowAncestor(this));
    }

    public void updateXInterval() {
        this.updateXIntervalFields();
        this.plotPanel.setXInterval(this.document.getXInterval());
        this.updateMouseCursorCoords();
    }

    public void updateYInterval() {
        this.updateYIntervalFields();
        this.plotPanel.setYInterval(this.document.getYInterval());
        this.updateMouseCursorCoords();
    }

    public void updateIntervals() {
        this.updateIntervalFields();
        this.plotPanel.setIntervals(this.document.getXInterval(), this.document.getYInterval());
        this.updateMouseCursorCoords();
    }

    public void showMouseCursorCoords(boolean bl) {
        this.updateMouseCursorCoords(bl ? this.mouseCursorLocation : (Point)null);
    }

    private void updateMouseCursorCoords() {
        this.updateMouseCursorCoords(this.mouseCursorLocation);
    }

    private void updateMouseCursorCoords(Point point) {
        Point2D.Double double_;
        String string = null;
        String string2 = null;
        Point2D.Double double_2 = double_ = point == null ? null : this.plotPanel.pointToCoords(point);
        if (double_ != null) {
            string = this.document.getXInterval().coordToString(double_.x);
            string2 = this.document.getYInterval().coordToString(double_.y);
        }
        this.coordinatesField.setText(string, string2);
    }

    private void updateMouseCursorCoords(MouseEvent mouseEvent) {
        this.mouseCursorLocation = mouseEvent == null ? null : mouseEvent.getPoint();
        this.updateMouseCursorCoords();
    }

    private void updateXIntervalFields() {
        PlotInterval plotInterval = this.document.getXInterval();
        this.xLowerEndpointField.setText(plotInterval.getLowerEndpointString());
        this.xUpperEndpointField.setText(plotInterval.getUpperEndpointString());
    }

    private void updateYIntervalFields() {
        PlotInterval plotInterval = this.document.getYInterval();
        this.yLowerEndpointField.setText(plotInterval.getLowerEndpointString());
        this.yUpperEndpointField.setText(plotInterval.getUpperEndpointString());
    }

    private void updateIntervalFields() {
        this.updateXIntervalFields();
        this.updateYIntervalFields();
    }

    private void setIntervals(MouseEvent mouseEvent, boolean bl) {
        double d = -this.plotPanel.getXScrollIncrement(mouseEvent.getX() - this.dragStart.x);
        double d2 = this.dragStart.xInterval.getLowerEndpoint() + d;
        double d3 = this.dragStart.xInterval.getUpperEndpoint() + d;
        d = this.plotPanel.getYScrollIncrement(mouseEvent.getY() - this.dragStart.y);
        double d4 = this.dragStart.yInterval.getLowerEndpoint() + d;
        double d5 = this.dragStart.yInterval.getUpperEndpoint() + d;
        if (bl || d2 != this.document.getXInterval().getLowerEndpoint() || d4 != this.document.getYInterval().getLowerEndpoint()) {
            FunctionDocument.Command command = FunctionDocument.Command.SET_INTERVALS;
            command.putValue("xInterval", new PlotInterval(d2, d3));
            command.putValue("yInterval", new PlotInterval(d4, d5));
            command.putValue("end", new Boolean(bl));
            command.execute();
        }
    }

    private void showPopUpMenu(MouseEvent mouseEvent) {
        if (mouseEvent == null || mouseEvent.isPopupTrigger()) {
            int n;
            Component component;
            if (popUpMenu == null) {
                popUpMenu = new JPopupMenu();
                popUpMenu.add(new FMenuItem(FunctionDocument.Command.ADD_FUNCTION));
                popUpMenu.add(new FMenuItem(FunctionDocument.Command.EDIT_FUNCTION));
                popUpMenu.add(new FMenuItem(FunctionDocument.Command.COPY_FUNCTION));
                popUpMenu.add(new FMenuItem(FunctionDocument.Command.HIDE_SHOW_FUNCTION));
                popUpMenu.add(new FMenuItem(FunctionDocument.Command.DELETE_FUNCTION));
                popUpMenu.add(new FMenuItem(FunctionDocument.Command.CLEAR_FUNCTIONS));
                popUpMenu.addSeparator();
                popUpMenu.add(new FCheckBoxMenuItem(FunctionDocument.Command.SHOW_GRID));
                if (App.getInstance().isApplet()) {
                    popUpMenu.addSeparator();
                    popUpMenu.add(new FMenuItem(FunctionDocument.Command.UNDO));
                    popUpMenu.add(new FMenuItem(FunctionDocument.Command.REDO));
                }
                App.applyOrientationByLocale(popUpMenu);
            }
            this.document.updateCommands();
            boolean bl = popUpMenu.getComponentOrientation().isLeftToRight();
            Component component2 = component = mouseEvent == null ? this : mouseEvent.getComponent();
            int n2 = mouseEvent == null ? (bl ? 0 : this.getWidth()) : (n = mouseEvent.getX());
            if (!bl) {
                n -= FunctionView.popUpMenu.getPreferredSize().width;
            }
            int n3 = mouseEvent == null ? 0 : mouseEvent.getY();
            popUpMenu.show(component, n, n3);
        }
    }

    private void doEditFunction() {
        FunctionDocument.Command.EDIT_FUNCTION.execute();
    }

    private void doDeleteFunction() {
        FunctionDocument.Command.DELETE_FUNCTION.execute();
    }

    private void doConfirmDeleteFunction() {
        FunctionDocument.Command.CONFIRM_DELETE_FUNCTION.execute();
    }

    private void doMoveFunctionUp() {
        FunctionDocument.Command command = FunctionDocument.Command.MOVE_FUNCTION;
        command.putValue("index", new Integer(this.functionList.getSelectedIndex() - 1));
        command.execute();
    }

    private void doMoveFunctionDown() {
        FunctionDocument.Command command = FunctionDocument.Command.MOVE_FUNCTION;
        command.putValue("index", new Integer(this.functionList.getSelectedIndex() + 2));
        command.execute();
    }

    private void doMoveFunction() {
        FunctionDocument.Command command = FunctionDocument.Command.MOVE_FUNCTION;
        command.putValue("index", new Integer(this.functionList.getDragEndIndex()));
        command.execute();
    }

    private void doSetXInterval() throws AppException {
        double d;
        try {
            try {
                d = this.xLowerEndpointField.getValue().doubleValue();
                if (d < -1.0E100 || d > 1.0E100) {
                    throw new AppException(ErrorId.X_LOWER_ENDPOINT_OUT_OF_BOUNDS);
                }
                if (PlotInterval.hasTooManySignificantDigits(this.xLowerEndpointField.getText())) {
                    throw new AppException(ErrorId.X_LOWER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(ErrorId.INVALID_X_LOWER_ENDPOINT);
            }
        }
        catch (AppException appException) {
            GuiUtilities.setFocus(this.xLowerEndpointField);
            throw appException;
        }
        try {
            try {
                d = this.xUpperEndpointField.getValue().doubleValue();
                if (d < -1.0E100 || d > 1.0E100) {
                    throw new AppException(ErrorId.X_UPPER_ENDPOINT_OUT_OF_BOUNDS);
                }
                if (PlotInterval.hasTooManySignificantDigits(this.xUpperEndpointField.getText())) {
                    throw new AppException(ErrorId.X_UPPER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(ErrorId.INVALID_X_UPPER_ENDPOINT);
            }
            if (this.xLowerEndpointField.getValue().doubleValue() >= this.xUpperEndpointField.getValue().doubleValue()) {
                throw new AppException(ErrorId.X_ENDPOINTS_OUT_OF_ORDER);
            }
        }
        catch (AppException appException) {
            GuiUtilities.setFocus(this.xUpperEndpointField);
            throw appException;
        }
        FunctionDocument.Command command = FunctionDocument.Command.SET_X_INTERVAL;
        command.putValue("xInterval", new PlotInterval(this.xLowerEndpointField.getText(), this.xUpperEndpointField.getText()));
        command.execute();
    }

    private void doSetYInterval() throws AppException {
        double d;
        try {
            try {
                d = this.yLowerEndpointField.getValue().doubleValue();
                if (d < -1.0E100 || d > 1.0E100) {
                    throw new AppException(ErrorId.Y_LOWER_ENDPOINT_OUT_OF_BOUNDS);
                }
                if (PlotInterval.hasTooManySignificantDigits(this.yLowerEndpointField.getText())) {
                    throw new AppException(ErrorId.Y_LOWER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(ErrorId.INVALID_Y_LOWER_ENDPOINT);
            }
        }
        catch (AppException appException) {
            GuiUtilities.setFocus(this.yLowerEndpointField);
            throw appException;
        }
        try {
            try {
                d = this.yUpperEndpointField.getValue().doubleValue();
                if (d < -1.0E100 || d > 1.0E100) {
                    throw new AppException(ErrorId.Y_UPPER_ENDPOINT_OUT_OF_BOUNDS);
                }
                if (PlotInterval.hasTooManySignificantDigits(this.yUpperEndpointField.getText())) {
                    throw new AppException(ErrorId.Y_UPPER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(ErrorId.INVALID_Y_UPPER_ENDPOINT);
            }
            if (this.yLowerEndpointField.getValue().doubleValue() >= this.yUpperEndpointField.getValue().doubleValue()) {
                throw new AppException(ErrorId.Y_ENDPOINTS_OUT_OF_ORDER);
            }
        }
        catch (AppException appException) {
            GuiUtilities.setFocus(this.yUpperEndpointField);
            throw appException;
        }
        FunctionDocument.Command command = FunctionDocument.Command.SET_Y_INTERVAL;
        command.putValue("yInterval", new PlotInterval(this.yLowerEndpointField.getText(), this.yUpperEndpointField.getText()));
        command.execute();
    }

    private void doSelectXZoomFactor() {
        xZoomFactorStr = this.xZoomFactorComboBox.getSelectedItem().toString();
    }

    private void doSelectYZoomFactor() {
        yZoomFactorStr = this.yZoomFactorComboBox.getSelectedItem().toString();
    }

    private void doShowPopUpMenu() {
        this.showPopUpMenu(null);
    }

    static {
        xZoomFactorStr = DEFAULT_ZOOM_FACTOR_STR;
        yZoomFactorStr = DEFAULT_ZOOM_FACTOR_STR;
    }

    private static class DragStart {
        int x;
        int y;
        PlotInterval xInterval;
        PlotInterval yInterval;

        private DragStart(int n, int n2, PlotInterval plotInterval, PlotInterval plotInterval2) {
            this.x = n;
            this.y = n2;
            this.xInterval = plotInterval;
            this.yInterval = plotInterval2;
        }
    }

    private static class EndpointField
    extends SurrogateMinus.Field {
        private static final int NUM_COLUMNS = 12;
        private static final String VALID_CHARS = "+.0123456789E";

        private EndpointField(int n) {
            super(n, 12);
        }

        @Override
        protected int getColumnWidth() {
            return GuiUtilities.getCharWidth(48, this.getFontMetrics(this.getFont())) + 1;
        }

        @Override
        protected String translateInsertString(String string, int n) {
            return super.translateInsertString(string, n).toUpperCase();
        }

        @Override
        protected boolean acceptCharacter(char c, int n) {
            return this.isMinusCharacter(c) || VALID_CHARS.indexOf(c) >= 0;
        }

        public BigDecimal getValue() throws NumberFormatException {
            return new BigDecimal(this.getText());
        }
    }

    private static class CoordinatesField
    extends JComponent {
        private static final int NUM_ROWS = 2;
        private static final int TOP_MARGIN = 3;
        private static final int BOTTOM_MARGIN = 3;
        private static final int LEADING_MARGIN = 5;
        private static final int TRAILING_MARGIN = 5;
        private static final int GAP = 8;
        private static final Color BACKGROUND_COLOUR = new Color(208, 224, 224);
        private static final Color FOREGROUND_COLOUR = Color.BLACK;
        private static final Color X_Y_BACKGROUND_COLOUR = new Color(192, 208, 208);
        private static final Color BORDER_COLOUR = Colours.LINE_BORDER;
        private static final String BASE_STR = "-.E-000";
        private int width;
        private int height;
        private int charWidth;
        private char minusChar;
        private String text1;
        private String text2;

        private CoordinatesField() {
            AppFont.TEXT_FIELD.apply(this);
            this.minusChar = SurrogateMinus.getMinusChar(this.getFont());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.charWidth = Math.max(GuiUtilities.getCharWidth(120, fontMetrics), GuiUtilities.getCharWidth(121, fontMetrics));
            char[] cArray = StringUtilities.createCharArray('0', 12);
            int n = fontMetrics.stringWidth(this.convertString(BASE_STR)) + fontMetrics.charsWidth(cArray, 0, cArray.length);
            this.width = 5 + this.charWidth + 8 + n + 5;
            this.height = 3 + 2 * fontMetrics.getHeight() + 3;
            this.setOpaque(true);
            this.setFocusable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            graphics = graphics.create();
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(BACKGROUND_COLOUR);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n2 = bl ? 0 : this.getWidth() - 5 - this.charWidth - 4;
            graphics.setColor(X_Y_BACKGROUND_COLOUR);
            graphics.fillRect(n2, rectangle.y, 5 + this.charWidth + 4, rectangle.height);
            TextRendering.setHints((Graphics2D)graphics);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = bl ? 5 : 4;
            int n4 = 3 + fontMetrics.getAscent();
            int n5 = n4 + fontMetrics.getHeight();
            graphics.setColor(FOREGROUND_COLOUR);
            graphics.drawString("x", n2 += n3, n4);
            graphics.drawString("y", n2, n5);
            if (this.text1 != null) {
                n = bl ? n2 + this.charWidth + 8 : n2 - 8 - fontMetrics.stringWidth(this.text1);
                graphics.drawString(this.text1, n, n4);
            }
            if (this.text2 != null) {
                n = bl ? n2 + this.charWidth + 8 : n2 - 8 - fontMetrics.stringWidth(this.text2);
                graphics.drawString(this.text2, n, n5);
            }
            graphics.setColor(BORDER_COLOUR);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        public void setText(String string, String string2) {
            this.text1 = this.convertString(string);
            this.text2 = this.convertString(string2);
            this.repaint();
        }

        private String convertString(String string) {
            return SurrogateMinus.minusToSurrogate(string, this.minusChar);
        }
    }

    private static class ZoomButton
    extends JButton {
        private static final Insets MARGINS = new Insets(1, 1, 1, 1);

        private ZoomButton(Action action) {
            super(action);
            this.setMargin(MARGINS);
        }
    }

    private static class ScrollButton
    extends JButton {
        private static final Insets MARGINS = new Insets(1, 1, 1, 1);

        private ScrollButton(Action action) {
            super(action);
            this.setMargin(MARGINS);
        }
    }

    private static class FunctionButton
    extends FButton {
        private static final Insets APPLICATION_MARGINS = new Insets(2, 8, 2, 8);
        private static final Insets APPLET_MARGINS = new Insets(2, 6, 2, 6);
        private static List<FunctionButton> instances;

        private FunctionButton(Action action) {
            super(action);
            this.setMargin(App.getInstance().isApplet() ? APPLET_MARGINS : APPLICATION_MARGINS);
            if (instances == null) {
                instances = new ArrayList<FunctionButton>();
            }
            instances.add(this);
        }

        public static void reset() {
            if (instances != null) {
                instances.clear();
            }
        }

        public static void updateWidth() {
            int n = 0;
            for (FunctionButton functionButton : instances) {
                int n2 = functionButton.getPreferredSize().width;
                if (n >= n2) continue;
                n = n2;
            }
            for (FunctionButton functionButton : instances) {
                functionButton.setPreferredSize(new Dimension(n, functionButton.getPreferredSize().height));
            }
        }
    }

    private static class FunctionListItemIcon
    implements Icon {
        private static final int WIDTH = 20;
        private static final int HEIGHT = 12;
        private static final Color BORDER_COLOUR = Color.GRAY;
        private Color colour;
        private boolean visible;

        private FunctionListItemIcon(Color color, boolean bl) {
            this.colour = color;
            this.visible = bl;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.visible) {
                graphics.setColor(BORDER_COLOUR);
                graphics.drawRect(n, n2, 19, 11);
                graphics.setColor(this.colour);
                graphics.fillRect(n + 1, n2 + 1, 18, 10);
            }
        }
    }

    public static class FunctionList
    extends SingleSelectionList<Function> {
        private static final int VERTICAL_MARGIN = 1;
        private static final int HORIZONTAL_MARGIN = 3;
        private static final int ICON_TEXT_GAP = 4;
        private Popup popUp;
        private char minusChar = SurrogateMinus.getMinusChar(this.getFont());

        private FunctionList(FunctionDocument functionDocument, int n, int n2) {
            super(n, n2, AppFont.MAIN.getFont(), functionDocument);
            this.setRowHeight(2 + Math.max(this.getFontMetrics(this.getFont()).getHeight(), 12));
            this.setExtraWidth(24);
            this.setHorizontalMargin(3);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            int n = this.getRowHeight();
            int n2 = mouseEvent.getY() / n;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && InputModifiers.get(mouseEvent).isControl() && n2 >= 0 && n2 < this.getNumElements()) {
                String string = this.convertString(((Function)this.getElement(n2)).toString());
                if (this.getFontMetrics(this.getFont()).stringWidth(string) > this.getColumns() * this.getColumnWidth()) {
                    PopUpComponent popUpComponent = new PopUpComponent(string, n + 2, this.getBackground());
                    int n3 = popUpComponent.getPreferredSize().width;
                    boolean bl = this.getComponentOrientation().isLeftToRight();
                    int n4 = bl ? 23 : this.getWidth() - n3 - 3 - 20;
                    Point point = new Point(n4, n2 * n - 1);
                    SwingUtilities.convertPointToScreen(point, this);
                    Rectangle rectangle = GuiUtilities.getVirtualScreenBounds(this);
                    n4 = bl ? Math.min(point.x, rectangle.x + rectangle.width - n3) : Math.max(rectangle.x, point.x);
                    this.popUp = PopupFactory.getSharedInstance().getPopup(this, popUpComponent, n4, point.y);
                    this.popUp.show();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.hidePopUp();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (this.isDragging()) {
                this.hidePopUp();
            }
        }

        @Override
        protected void drawElement(Graphics graphics, int n) {
            int n2;
            graphics = graphics.create();
            Function function = (Function)this.getElement(n);
            boolean bl = this.getComponentOrientation().isLeftToRight();
            FunctionListItemIcon functionListItemIcon = new FunctionListItemIcon(function.getColour(), function.isVisible());
            int n3 = bl ? this.getHorizontalMargin() : this.getWidth() - this.getHorizontalMargin() - functionListItemIcon.getIconWidth();
            int n4 = this.getRowHeight();
            int n5 = n * n4;
            int n6 = n5 + (n4 - functionListItemIcon.getIconHeight()) / 2;
            functionListItemIcon.paintIcon(this, graphics, n3, n6);
            String string = this.convertString(function.toString());
            TextRendering.setHints((Graphics2D)graphics);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = this.getColumns() * this.getColumnWidth();
            if (n2 > n7) {
                n7 -= fontMetrics.stringWidth("...");
                char[] cArray = string.toCharArray();
                int n8 = cArray.length;
                for (n2 = fontMetrics.stringWidth(string); n8 > 0 && n2 > n7; n2 -= fontMetrics.charWidth(cArray[--n8])) {
                }
                string = new String(cArray, 0, n8) + "...";
            }
            int n9 = bl ? functionListItemIcon.getIconWidth() + 4 : -(4 + fontMetrics.stringWidth(string));
            n6 = n5 + GuiUtilities.getBaselineOffset(n4, fontMetrics);
            graphics.setColor(this.getForegroundColour(n));
            graphics.drawString(string, n3 += n9, n6);
        }

        private void hidePopUp() {
            if (this.popUp != null) {
                this.popUp.hide();
                this.popUp = null;
            }
        }

        private String convertString(String string) {
            return SurrogateMinus.minusToSurrogate(string, this.minusChar);
        }

        private static class PopUpComponent
        extends JComponent {
            private static final int HORIZONTAL_MARGIN = 4;
            private static final Color TEXT_COLOUR = Color.BLACK;
            private static final Color BORDER_COLOUR = Colours.LINE_BORDER;
            private String text;
            private int width;
            private int height;
            private Color backgroundColour;

            private PopUpComponent(String string, int n, Color color) {
                this.text = string;
                this.height = n;
                this.backgroundColour = color;
                AppFont.MAIN.apply(this);
                this.width = 8 + this.getFontMetrics(this.getFont()).stringWidth(string);
                this.setOpaque(true);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.width, this.height);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                graphics = graphics.create();
                graphics.setColor(this.backgroundColour);
                graphics.fillRect(0, 0, this.width, this.height);
                TextRendering.setHints((Graphics2D)graphics);
                graphics.setColor(TEXT_COLOUR);
                graphics.drawString(this.text, 4, GuiUtilities.getBaselineOffset(this.height, graphics.getFontMetrics()));
                graphics.setColor(BORDER_COLOUR);
                graphics.drawRect(0, 0, this.width - 1, this.height - 1);
            }
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        INVALID_X_LOWER_ENDPOINT("The lower endpoint of the x interval is invalid."),
        X_LOWER_ENDPOINT_OUT_OF_BOUNDS("The lower endpoint of the x interval must be between -1.0E100 and 1.0E100."),
        X_LOWER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS("The lower endpoint of the x interval must not have more than 12 significant digits."),
        INVALID_X_UPPER_ENDPOINT("The upper endpoint of the x interval is invalid."),
        X_UPPER_ENDPOINT_OUT_OF_BOUNDS("The upper endpoint of the x interval must be between -1.0E100 and 1.0E100."),
        X_UPPER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS("The upper endpoint of the x interval must not have more than 12 significant digits."),
        X_ENDPOINTS_OUT_OF_ORDER("The upper endpoint of the x interval is less than or equal to the lower endpoint."),
        INVALID_Y_LOWER_ENDPOINT("The lower endpoint of the y interval is invalid."),
        Y_LOWER_ENDPOINT_OUT_OF_BOUNDS("The lower endpoint of the y interval must be between -1.0E100 and 1.0E100."),
        Y_LOWER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS("The lower endpoint of the y interval must not have more than 12 significant digits."),
        INVALID_Y_UPPER_ENDPOINT("The upper endpoint of the y interval is invalid."),
        Y_UPPER_ENDPOINT_OUT_OF_BOUNDS("The upper endpoint of the y interval must be between -1.0E100 and 1.0E100."),
        Y_UPPER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS("The upper endpoint of the y interval must not have more than 12 significant digits."),
        Y_ENDPOINTS_OUT_OF_ORDER("The upper endpoint of the y interval is less than or equal to the lower endpoint.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface Command {
        public static final String EDIT_FUNCTION = "editFunction";
        public static final String DELETE_FUNCTION = "deleteFunction";
        public static final String CONFIRM_DELETE_FUNCTION = "confirmDeleteFunction";
        public static final String MOVE_FUNCTION_UP = "moveFunctionUp";
        public static final String MOVE_FUNCTION_DOWN = "moveFunctionDown";
        public static final String MOVE_FUNCTION = "moveFunction";
        public static final String SET_X_INTERVAL = "setXInterval";
        public static final String SET_Y_INTERVAL = "setYInterval";
        public static final String SELECT_X_ZOOM_FACTOR = "selectXZoomFactor";
        public static final String SELECT_Y_ZOOM_FACTOR = "selectYZoomFactor";
        public static final String SHOW_POP_UP_MENU = "showPopUpMenu";
    }
}

