/*
 * Decompiled with CFR 0.152.
 */
package ucar.tests;

import java.io.IOException;
import ucar.multiarray.ArrayMultiArray;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;
import ucar.multiarray.SliceMap;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Schema;
import ucar.netcdf.UnlimitedDimension;
import ucar.netcdf.Variable;

public class TestNetcdf {
    public static String MultiArrayToString(MultiArray ma) {
        StringBuffer buf = new StringBuffer();
        int rank = ma.getRank();
        if (rank > 0) {
            buf.append("{\n\t");
            int[] dims = ma.getLengths();
            int last = dims[0] - 1;
            for (int ii = 0; ii <= last; ++ii) {
                MultiArrayProxy inner = new MultiArrayProxy(ma, new SliceMap(0, ii));
                buf.append(TestNetcdf.MultiArrayToString(inner));
                if (ii == last) continue;
                buf.append(", ");
            }
            buf.append("\n}");
        } else {
            try {
                buf.append(ma.get(null));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        int[] extent;
        int[] origin;
        NetcdfFile nc;
        String fname = args.length == 0 ? new String("t.nc") : args[args.length - 1];
        System.out.print("path: ");
        System.out.println(fname);
        try {
            Schema schema = new Schema();
            schema.put(new ProtoVariable("t1", Integer.TYPE, (Dimension[])null));
            UnlimitedDimension timeD = new UnlimitedDimension("time");
            Dimension latD = new Dimension("lat", 45);
            Dimension lonD = new Dimension("lon", 90);
            Dimension hgtD = new Dimension("level", 12);
            schema.put(new ProtoVariable(timeD.getName(), Double.TYPE, timeD));
            schema.put(new ProtoVariable(latD.getName(), Byte.TYPE, latD));
            schema.put(new ProtoVariable(lonD.getName(), Short.TYPE, lonD));
            schema.put(new ProtoVariable(hgtD.getName(), Integer.TYPE, hgtD));
            Dimension[] Tdims = new Dimension[]{timeD, hgtD, latD, lonD};
            ProtoVariable temperatureV = new ProtoVariable("temperature", Float.TYPE, Tdims);
            AttributeSet Vattrs = temperatureV.getAttributes();
            Vattrs.put(new Attribute("units", "degree_Celsius"));
            double[] vr = new double[]{-100.0, 200.0};
            Vattrs.put(new Attribute("valid_range", vr));
            Vattrs.put(new Attribute("missing_value", new Double(-999.0)));
            Vattrs.put(new Attribute("_FillValue", -9999.0));
            schema.put(temperatureV);
            schema.putAttribute(new Attribute("conventions", "none"));
            NetcdfFile nc2 = new NetcdfFile(fname, true, true, schema);
            int nlats = latD.getLength();
            byte[] lats = new byte[nlats];
            byte lat = (byte)(-nlats / 2);
            int ii = 0;
            while (ii < nlats) {
                lats[ii] = lat;
                ++ii;
                lat = (byte)(lat + 1);
            }
            int[] origin2 = new int[]{0};
            nc2.get(latD.getName()).copyin(origin2, new ArrayMultiArray(lats));
            int nlons = lonD.getLength();
            short[] lons = new short[nlons];
            short lon = (short)(-(nlons / 2 - 1));
            ii = 0;
            while (ii < nlons) {
                lons[ii] = lon;
                ++ii;
                lon = (short)(lon + 1);
            }
            origin = new int[]{0};
            nc2.get(lonD.getName()).copyin(origin, new ArrayMultiArray(lons));
            int[] hgts = new int[]{1000, 925, 850, 700, 500, 400, 300, 250, 200, 150, 100, 50};
            int[] origin3 = new int[]{0};
            nc2.get(hgtD.getName()).copyin(origin3, new ArrayMultiArray(hgts));
            Variable tao = nc2.get(timeD.getName());
            double time = 0.0;
            int[] index = new int[]{0, 0, 0, 0};
            while (index[0] < 5) {
                if (index[0] == 1) {
                    nc2.setFill(false);
                }
                tao.setDouble(index, time);
                if (index[0] == 1) {
                    nc2.setFill(true);
                }
                index[0] = index[0] + 1;
                time += 60.0;
            }
            nc2.close();
        }
        catch (Exception ee) {
            System.out.println(ee);
        }
        try {
            nc = new NetcdfFile(fname, false);
            System.out.println(nc);
            Variable timeV = nc.get("time");
            origin = new int[timeV.getRank()];
            extent = timeV.getLengths();
            MultiArray times = timeV.copyout(origin, extent);
            System.out.println(TestNetcdf.MultiArrayToString(times));
            nc.close();
        }
        catch (Exception ee) {
            System.out.println(ee);
        }
        try {
            fname = new String("test.nc");
            nc = new NetcdfFile(fname, false);
            System.out.println(nc);
            Variable ma = nc.get("Float");
            origin = new int[]{1, 1, 1};
            extent = new int[]{2, 3, 6};
            MultiArray flts = ma.copyout(origin, extent);
            nc.close();
            Schema sc2 = new Schema(nc);
            NetcdfFile clone = new NetcdfFile("clone.nc", true, true, sc2);
            ma = clone.get(ma.getName());
            ma.copyin(origin, flts);
            MultiArray cflts = ma.copyout(origin, extent);
            System.out.println(TestNetcdf.MultiArrayToString(cflts));
            MultiArrayImpl cflts2 = new MultiArrayImpl(extent, ma.toArray(new float[36], origin, extent));
            System.out.println(TestNetcdf.MultiArrayToString(cflts2));
        }
        catch (Exception ee) {
            System.out.println(ee);
        }
    }
}

