/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import ucar.multiarray.IndexIterator;

final class OffsetDualIndexIterator
extends IndexIterator {
    private final int[] offset;
    private final int[] offsetCounter;

    OffsetDualIndexIterator(int[] theOffset, int[] theLimits) {
        super(theLimits);
        this.offset = theOffset;
        this.offsetCounter = (int[])this.offset.clone();
    }

    public void incr() {
        int digit = this.counter.length - 1;
        if (digit < 0) {
            ++this.ncycles;
            return;
        }
        while (digit >= 0) {
            int n = digit;
            this.offsetCounter[n] = this.offsetCounter[n] + 1;
            int n2 = digit;
            this.counter[n2] = this.counter[n2] + 1;
            if (this.counter[digit] < this.limits[digit]) break;
            this.counter[digit] = 0;
            this.offsetCounter[digit] = this.offset[digit];
            if (digit == 0) {
                ++this.ncycles;
                break;
            }
            --digit;
        }
    }

    public int[] offsetValue() {
        return this.offsetCounter;
    }
}

