/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.ClipMap;
import ucar.multiarray.IndexMap;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;

public class MultiArrayProxy
implements MultiArray {
    private final MultiArray delegate_;
    private final IndexMap im_;
    private final int[] dlengths_;

    public MultiArrayProxy(MultiArray delegate, IndexMap im) {
        this.delegate_ = delegate;
        this.im_ = im;
        this.dlengths_ = this.delegate_.getLengths();
        this.im_.setLengths(this.dlengths_);
    }

    public Class getComponentType() {
        return this.delegate_.getComponentType();
    }

    public int getRank() {
        return this.im_.getRank();
    }

    public int[] getLengths() {
        if (this.isUnlimited()) {
            System.arraycopy(this.delegate_.getLengths(), 0, this.dlengths_, 0, this.dlengths_.length);
        }
        int[] lengths = new int[this.getRank()];
        return this.im_.getLengths(lengths);
    }

    public boolean isUnlimited() {
        return this.delegate_.isUnlimited();
    }

    public boolean isScalar() {
        return 0 == this.getRank();
    }

    public Object get(int[] index) throws IOException {
        return this.delegate_.get(this.map(index));
    }

    public boolean getBoolean(int[] index) throws IOException {
        return this.delegate_.getBoolean(this.map(index));
    }

    public char getChar(int[] index) throws IOException {
        return this.delegate_.getChar(this.map(index));
    }

    public byte getByte(int[] index) throws IOException {
        return this.delegate_.getByte(this.map(index));
    }

    public short getShort(int[] index) throws IOException {
        return this.delegate_.getShort(this.map(index));
    }

    public int getInt(int[] index) throws IOException {
        return this.delegate_.getInt(this.map(index));
    }

    public long getLong(int[] index) throws IOException {
        return this.delegate_.getLong(this.map(index));
    }

    public float getFloat(int[] index) throws IOException {
        return this.delegate_.getFloat(this.map(index));
    }

    public double getDouble(int[] index) throws IOException {
        return this.delegate_.getDouble(this.map(index));
    }

    public void set(int[] index, Object value) throws IOException {
        this.delegate_.set(this.map(index), value);
    }

    public void setBoolean(int[] index, boolean value) throws IOException {
        this.delegate_.setBoolean(this.map(index), value);
    }

    public void setChar(int[] index, char value) throws IOException {
        this.delegate_.setChar(this.map(index), value);
    }

    public void setByte(int[] index, byte value) throws IOException {
        this.delegate_.setByte(this.map(index), value);
    }

    public void setShort(int[] index, short value) throws IOException {
        this.delegate_.setShort(this.map(index), value);
    }

    public void setInt(int[] index, int value) throws IOException {
        this.delegate_.setInt(this.map(index), value);
    }

    public void setLong(int[] index, long value) throws IOException {
        this.delegate_.setLong(this.map(index), value);
    }

    public void setFloat(int[] index, float value) throws IOException {
        this.delegate_.setFloat(this.map(index), value);
    }

    public void setDouble(int[] index, double value) throws IOException {
        this.delegate_.setDouble(this.map(index), value);
    }

    public MultiArray copyout(int[] origin, int[] shape) throws IOException {
        int rank = this.getRank();
        if (origin.length != rank || shape.length != rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        MultiArrayImpl data = new MultiArrayImpl(this.getComponentType(), shape);
        AbstractAccessor.copyO(this, origin, data, shape);
        return data;
    }

    public void copyin(int[] origin, MultiArray data) throws IOException {
        int rank = this.getRank();
        if (origin.length != rank || data.getRank() != rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (data.getComponentType() != this.getComponentType()) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(data, data.getLengths(), this, origin);
    }

    public Object getStorage() {
        return this.delegate_.getStorage();
    }

    public Object toArray() throws IOException {
        return this.toArray(null, null, null);
    }

    public Object toArray(Object dst, int[] origin, int[] shape) throws IOException {
        int rank = this.getRank();
        if (origin == null) {
            origin = new int[rank];
        } else if (origin.length != rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] shp = null;
        if (shape == null) {
            shp = this.getLengths();
        } else if (shape.length == rank) {
            shp = (int[])shape.clone();
        } else {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] products = new int[rank];
        int length = MultiArrayImpl.numberOfElements(shp, products);
        dst = MultiArrayImpl.fixDest(dst, length, this.getComponentType());
        MultiArrayImpl data = new MultiArrayImpl(shp, products, dst);
        AbstractAccessor.copyO(this, origin, data, shp);
        return dst;
    }

    private synchronized int[] map(int[] index) {
        this.im_.setInput(index);
        return this.im_.getTransformed(new int[this.im_.getOutputLength()]);
    }

    public static void main(String[] args) {
        System.out.println(">>  " + System.currentTimeMillis());
        int[] shape = new int[]{48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        for (int ii = 0; ii < size; ++ii) {
            Array.setInt(delegate.storage, ii, ii);
        }
        ClipMap im = new ClipMap(0, 4, 40);
        MultiArrayProxy src = new MultiArrayProxy(delegate, im);
        int[] clip = new int[]{32, 64};
        int[] origin = new int[]{4, 0};
        MultiArray ma = null;
        try {
            ma = src.copyout(origin, clip);
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[]{0, 0}));
            System.out.println(ma.getInt(new int[]{1, 0}));
            System.out.println(ma.getInt(new int[]{lengths[0] - 1, lengths[1] - 1}));
        }
        catch (IOException ee) {
            // empty catch block
        }
        MultiArrayImpl destD = new MultiArrayImpl(Integer.TYPE, shape);
        im = new ClipMap(0, 8, 36);
        MultiArrayProxy dest = new MultiArrayProxy(destD, im);
        try {
            origin = new int[]{0, 0};
            dest.copyin(origin, ma);
            System.out.println("***Rank  " + dest.getRank());
            int[] lengths = dest.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(destD.getInt(new int[]{0, 0}));
            System.out.println(destD.getInt(new int[]{7, 63}));
            System.out.println(destD.getInt(new int[]{8, 0}));
            System.out.println(destD.getInt(new int[]{8, 63}));
            System.out.println(destD.getInt(new int[]{9, 0}));
            System.out.println(destD.getInt(new int[]{39, 0}));
            System.out.println(destD.getInt(new int[]{40, 0}));
            System.out.println(destD.getInt(new int[]{47, 63}));
        }
        catch (IOException ee) {
            // empty catch block
        }
    }
}

