/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class UnitedKingdom
extends Calendar {
    public UnitedKingdom() {
        this(Market.Settlement);
    }

    public UnitedKingdom(Market market) {
        switch (market) {
            case Settlement: {
                this.impl = new SettlementImpl();
                break;
            }
            case Exchange: {
                this.impl = new ExchangeImpl();
                break;
            }
            case Metals: {
                this.impl = new MetalsImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class MetalsImpl
    extends Calendar.WesternImpl {
        private MetalsImpl() {
        }

        @Override
        public String name() {
            return "London metals exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.January || dd == em - 3 || dd == em || d <= 7 && w == Weekday.Monday && m == Month.May || d >= 25 && w == Weekday.Monday && m == Month.May && y != 2002 || d >= 25 && w == Weekday.Monday && m == Month.August || (d == 25 || d == 27 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December || (d == 26 || d == 28 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December || (d == 3 || d == 4) && m == Month.June && y == 2002 || d == 5 && m == Month.June && y == 2012 || d == 29 && m == Month.April && y == 2011) && (d != 31 || m != Month.December || y != 1999);
        }
    }

    private final class ExchangeImpl
    extends Calendar.WesternImpl {
        private ExchangeImpl() {
        }

        @Override
        public String name() {
            return "London stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.January || dd == em - 3 || dd == em || d <= 7 && w == Weekday.Monday && m == Month.May || d >= 25 && w == Weekday.Monday && m == Month.May && y != 2002 || d >= 25 && w == Weekday.Monday && m == Month.August || (d == 25 || d == 27 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December || (d == 26 || d == 28 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December || (d == 3 || d == 4) && m == Month.June && y == 2002 || d == 5 && m == Month.June && y == 2012 || d == 29 && m == Month.April && y == 2011) && (d != 31 || m != Month.December || y != 1999);
        }
    }

    private final class SettlementImpl
    extends Calendar.WesternImpl {
        private SettlementImpl() {
        }

        @Override
        public String name() {
            return "UK settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.January || dd == em - 3 || dd == em || d <= 7 && w == Weekday.Monday && m == Month.May || d >= 25 && w == Weekday.Monday && m == Month.May && y != 2002 || d >= 25 && w == Weekday.Monday && m == Month.August || (d == 25 || d == 27 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December || (d == 26 || d == 28 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December || (d == 3 || d == 4) && m == Month.June && y == 2002 || d == 5 && m == Month.June && y == 2012 || d == 29 && m == Month.April && y == 2011) && (d != 31 || m != Month.December || y != 1999);
        }
    }

    public static enum Market {
        Settlement,
        Exchange,
        Metals;

    }
}

