/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class SouthKorea
extends Calendar {
    public SouthKorea() {
        this(Market.KRX);
    }

    public SouthKorea(Market m) {
        switch (m) {
            case Settlement: {
                this.impl = new SettlementImpl();
                break;
            }
            case KRX: {
                this.impl = new KrxImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private class KrxImpl
    extends SettlementImpl {
        private KrxImpl() {
        }

        @Override
        public String name() {
            return "South-Korea exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            if (!super.isBusinessDay(date)) {
                return false;
            }
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            return !(d == 31 && m == Month.December && y == 2004 || d == 30 && m == Month.December && y == 2005 || d == 29 && m == Month.December && y == 2006) && (d != 31 || m != Month.December || y != 2007);
        }
    }

    private class SettlementImpl
    extends Calendar.Impl {
        private SettlementImpl() {
        }

        @Override
        public String name() {
            return "South-Korean settlement";
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Saturday || w == Weekday.Sunday;
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 1 && m == Month.March || d == 5 && m == Month.April && y <= 2005 || d == 1 && m == Month.May || d == 5 && m == Month.May || d == 6 && m == Month.June || d == 17 && m == Month.July && y <= 2007 || d == 15 && m == Month.August || d == 3 && m == Month.October || d == 25 && m == Month.December || (d == 21 || d == 22 || d == 23) && m == Month.January && y == 2004 || (d == 8 || d == 9 || d == 10) && m == Month.February && y == 2005 || (d == 28 || d == 29 || d == 30) && m == Month.January && y == 2006 || d == 19 && m == Month.February && y == 2007 || (d == 6 || d == 7 || d == 8) && m == Month.February && y == 2008 || (d == 25 || d == 26 || d == 27) && m == Month.January && y == 2009 || (d == 13 || d == 14 || d == 15) && m == Month.February && y == 2010 || d == 15 && m == Month.April && y == 2004 || d == 31 && m == Month.May && y == 2006 || d == 19 && m == Month.December && y == 2007 || d == 9 && m == Month.April && y == 2008 || d == 26 && m == Month.May && y == 2004 || d == 15 && m == Month.May && y == 2005 || d == 5 && m == Month.May && y == 2006 || d == 24 && m == Month.May && y == 2007 || d == 12 && m == Month.May && y == 2008 || d == 2 && m == Month.May && y == 2009 || d == 21 && m == Month.May && y == 2010 || (d == 27 || d == 28 || d == 29) && m == Month.September && y == 2004 || (d == 17 || d == 18 || d == 19) && m == Month.September && y == 2005 || (d == 5 || d == 6 || d == 7) && m == Month.October && y == 2006 || (d == 24 || d == 25 || d == 26) && m == Month.September && y == 2007 || (d == 13 || d == 14 || d == 15) && m == Month.September && y == 2008 || (d == 2 || d == 3 || d == 4) && m == Month.October && y == 2009) && (d != 21 && d != 22 && d != 23 || m != Month.September || y != 2010);
        }
    }

    public static enum Market {
        Settlement,
        KRX;

    }
}

