/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Brazil
extends Calendar {
    public Brazil() {
        this(Market.SETTLEMENT);
    }

    public Brazil(Market market) {
        switch (market) {
            case SETTLEMENT: {
                this.impl = new SettlementImpl();
                break;
            }
            case BOVESPA: {
                this.impl = new ExchangeImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class ExchangeImpl
    extends Calendar.WesternImpl {
        private ExchangeImpl() {
        }

        @Override
        public String name() {
            return "BOVESPA";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            int dd = date.dayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 25 && m == Month.January || d == 21 && m == Month.April || d == 1 && m == Month.May || d == 9 && m == Month.July || d == 20 && m == Month.November && y >= 2007 || d == 24 && m == Month.December || d == 25 && m == Month.December || dd == em - 3 || dd == em - 49 || dd == em - 48 || dd == em + 59) && (m != Month.December || d != 31 && (d < 29 || w != Weekday.Friday));
        }
    }

    private final class SettlementImpl
    extends Calendar.WesternImpl {
        private SettlementImpl() {
        }

        @Override
        public String name() {
            return "Brazil";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            int dd = date.dayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 21 && m == Month.April || d == 1 && m == Month.May || d == 7 && m == Month.September || d == 12 && m == Month.October || d == 2 && m == Month.November || d == 15 && m == Month.November || d == 25 && m == Month.December || dd == em - 3 || dd == em - 49 || dd == em - 48) && dd != em + 59;
        }
    }

    public static enum Market {
        SETTLEMENT,
        BOVESPA;

    }
}

