/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Australia
extends Calendar {
    public Australia() {
        this.impl = new AustraliaImpl();
    }

    private final class AustraliaImpl
    extends Calendar.WesternImpl {
        private AustraliaImpl() {
        }

        @Override
        public String name() {
            return "Australia";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || (d == 26 || (d == 27 || d == 28) && w == Weekday.Monday) && m == Month.January || dd == em - 3 || dd == em || (d == 25 || d == 26 && w == Weekday.Monday) && m == Month.April || d > 7 && d <= 14 && w == Weekday.Monday && m == Month.June || d <= 7 && w == Weekday.Monday && m == Month.August || d <= 7 && w == Weekday.Monday && m == Month.October || (d == 25 || d == 27 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December) && (d != 26 && (d != 28 || w != Weekday.Monday && w != Weekday.Tuesday) || m != Month.December);
        }
    }
}

