/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.util.ArrayList;
import java.util.Iterator;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.lang.iterators.Iterables;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.matrixutilities.Array;

public class TimeGrid {
    private final Array times;
    private final Array dt;
    private final Array mandatoryTimes;

    public TimeGrid() {
        this.times = null;
        this.dt = null;
        this.mandatoryTimes = null;
    }

    public TimeGrid(@Time @NonNegative double end, @NonNegative int steps) {
        QL.require(end > 0.0, "negative times not allowed");
        double dt = end / (double)steps;
        this.times = new Array(steps + 1);
        for (int i = 0; i <= steps; ++i) {
            this.times.set(i, dt * (double)i);
        }
        this.mandatoryTimes = new Array(1).fill(end);
        this.dt = new Array(steps).fill(dt);
    }

    public TimeGrid(@Time @NonNegative Array mandatoryTimes) {
        int i;
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("This constructor is not available yet");
        }
        this.mandatoryTimes = mandatoryTimes;
        this.mandatoryTimes.sort();
        QL.require(mandatoryTimes.first() < 0.0, "negative times not allowed");
        ArrayList<Double> unique = new ArrayList<Double>();
        double prev = this.mandatoryTimes.get(0);
        unique.add(prev);
        for (i = 1; i < this.mandatoryTimes.size(); ++i) {
            double curr = this.mandatoryTimes.get(i);
            if (!Closeness.isCloseEnough(prev, curr)) {
                unique.add(curr);
            }
            prev = curr;
        }
        this.times = new Array(unique.size());
        i = 0;
        Iterator iterator = Iterables.unmodifiableIterable(unique.iterator()).iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            this.times.set(i, d);
            ++i;
        }
        this.dt = this.times.adjacentDifference();
    }

    @NonNegative
    public int index(@Time @NonNegative double t) {
        int k;
        int j;
        int i = this.closestIndex(t);
        if (Closeness.isCloseEnough(t, this.times.get(i))) {
            return i;
        }
        if (t < this.front()) {
            throw new IllegalArgumentException("using inadequate time grid: all nodes are later than the required time t = " + t + " (earliest node is t1 = " + this.times.first() + ")");
        }
        if (t > this.back()) {
            throw new IllegalArgumentException("using inadequate time grid: all nodes are earlier than the required time t = " + t + " (latest node is t1 = " + this.back() + ")");
        }
        if (t > this.times.get(i)) {
            j = i;
            k = i + 1;
        } else {
            j = i - 1;
            k = i;
        }
        throw new IllegalArgumentException("using inadequate time grid: the nodes closest to the required time t = " + t + " are t1 = " + this.times.get(j) + " and t2 = " + this.times.get(k));
    }

    @NonNegative
    public int closestIndex(@Time @NonNegative double t) {
        double dt2;
        int size = this.times.size();
        int result = this.times.lowerBound(t);
        if (result == 0) {
            return 0;
        }
        if (result == size) {
            return size - 1;
        }
        double dt1 = this.times.get(result) - t;
        if (dt1 < (dt2 = t - this.times.get(result - 1))) {
            return result;
        }
        return result - 1;
    }

    @Time
    public double closestTime(@Time @NonNegative double t) {
        return this.times.get(this.closestIndex(t));
    }

    public final Array mandatoryTimes() {
        return this.mandatoryTimes.clone();
    }

    public double dt(int i) {
        return this.dt.get(i);
    }

    public double get(int i) {
        return this.times.get(i);
    }

    public double at(int i) {
        return this.times.get(i);
    }

    public int size() {
        return this.times.size();
    }

    public boolean empty() {
        return this.times.size() == 0;
    }

    public double begin() {
        return this.times.first();
    }

    public double end() {
        return this.times.last();
    }

    public double front() {
        return this.times.first();
    }

    public double back() {
        return this.times.last();
    }
}

