/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import org.jquantlib.lang.exceptions.LibraryException;

public enum Frequency {
    NoFrequency(-1),
    Once(0),
    Annual(1),
    Semiannual(2),
    EveryFourthMonth(3),
    Quarterly(4),
    Bimonthly(6),
    Monthly(12),
    EveryFourthWeek(13),
    Biweekly(26),
    Weekly(52),
    Daily(365),
    OtherFrequency(999);

    private final int enumValue;

    private Frequency(int frequency) {
        this.enumValue = frequency;
    }

    public static Frequency valueOf(int value) {
        switch (value) {
            case -1: {
                return NoFrequency;
            }
            case 0: {
                return Once;
            }
            case 1: {
                return Annual;
            }
            case 2: {
                return Semiannual;
            }
            case 3: {
                return EveryFourthMonth;
            }
            case 4: {
                return Quarterly;
            }
            case 6: {
                return Bimonthly;
            }
            case 12: {
                return Monthly;
            }
            case 13: {
                return EveryFourthWeek;
            }
            case 26: {
                return Biweekly;
            }
            case 52: {
                return Weekly;
            }
            case 365: {
                return Daily;
            }
            case 999: {
                return OtherFrequency;
            }
        }
        throw new LibraryException("value must be one of -1,0,1,2,3,4,6,12,13,26,52,365,999");
    }

    public int toInteger() {
        return this.enumValue;
    }
}

