/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.ActualActual;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.daycounters.Thirty360;
import org.jquantlib.indexes.BMAIndex;
import org.jquantlib.indexes.Euribor;
import org.jquantlib.indexes.Euribor3M;
import org.jquantlib.indexes.Euribor6M;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.indexes.ibor.JPYLibor;
import org.jquantlib.indexes.ibor.USDLibor;
import org.jquantlib.instruments.BMASwap;
import org.jquantlib.instruments.ForwardRateAgreement;
import org.jquantlib.instruments.MakeVanillaSwap;
import org.jquantlib.instruments.Position;
import org.jquantlib.instruments.VanillaSwap;
import org.jquantlib.instruments.bonds.FixedRateBond;
import org.jquantlib.math.interpolations.CubicInterpolation;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.factories.BackwardFlat;
import org.jquantlib.math.interpolations.factories.Cubic;
import org.jquantlib.math.interpolations.factories.Linear;
import org.jquantlib.math.interpolations.factories.LogCubic;
import org.jquantlib.math.interpolations.factories.LogLinear;
import org.jquantlib.pricingengines.bond.DiscountingBondEngine;
import org.jquantlib.pricingengines.swap.DiscountingSwapEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.Bootstrap;
import org.jquantlib.termstructures.IterativeBootstrap;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.BMASwapRateHelper;
import org.jquantlib.termstructures.yieldcurves.DepositRateHelper;
import org.jquantlib.termstructures.yieldcurves.Discount;
import org.jquantlib.termstructures.yieldcurves.FixedRateBondHelper;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.termstructures.yieldcurves.ForwardRate;
import org.jquantlib.termstructures.yieldcurves.FraRateHelper;
import org.jquantlib.termstructures.yieldcurves.PiecewiseYieldCurve;
import org.jquantlib.termstructures.yieldcurves.SwapRateHelper;
import org.jquantlib.termstructures.yieldcurves.Traits;
import org.jquantlib.termstructures.yieldcurves.ZeroYield;
import org.jquantlib.testsuite.util.Flag;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.MakeSchedule;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.time.calendars.Japan;
import org.jquantlib.time.calendars.JointCalendar;
import org.jquantlib.time.calendars.Target;
import org.junit.Ignore;
import org.junit.Test;

public class PiecewiseYieldCurveTest {
    private final Datum[] depositData = new Datum[]{new Datum(1, TimeUnit.Weeks, 4.559), new Datum(1, TimeUnit.Months, 4.581), new Datum(2, TimeUnit.Months, 4.573), new Datum(3, TimeUnit.Months, 4.557), new Datum(6, TimeUnit.Months, 4.496), new Datum(9, TimeUnit.Months, 4.49)};
    private final Datum[] fraData = new Datum[]{new Datum(1, TimeUnit.Months, 4.581), new Datum(2, TimeUnit.Months, 4.573), new Datum(3, TimeUnit.Months, 4.557), new Datum(6, TimeUnit.Months, 4.496), new Datum(9, TimeUnit.Months, 4.49)};
    private final Datum[] swapData = new Datum[]{new Datum(1, TimeUnit.Years, 4.54), new Datum(2, TimeUnit.Years, 4.63), new Datum(3, TimeUnit.Years, 4.75), new Datum(4, TimeUnit.Years, 4.86), new Datum(5, TimeUnit.Years, 4.99), new Datum(6, TimeUnit.Years, 5.11), new Datum(7, TimeUnit.Years, 5.23), new Datum(8, TimeUnit.Years, 5.33), new Datum(9, TimeUnit.Years, 5.41), new Datum(10, TimeUnit.Years, 5.47), new Datum(12, TimeUnit.Years, 5.6), new Datum(15, TimeUnit.Years, 5.75), new Datum(20, TimeUnit.Years, 5.89), new Datum(25, TimeUnit.Years, 5.95), new Datum(30, TimeUnit.Years, 5.96)};
    private final BondDatum[] bondData = new BondDatum[]{new BondDatum(6, TimeUnit.Months, 5, Frequency.Semiannual, 4.75, 101.32), new BondDatum(1, TimeUnit.Years, 3, Frequency.Semiannual, 2.75, 100.59), new BondDatum(2, TimeUnit.Years, 5, Frequency.Semiannual, 5.0, 105.65), new BondDatum(5, TimeUnit.Years, 11, Frequency.Semiannual, 5.5, 113.61), new BondDatum(10, TimeUnit.Years, 11, Frequency.Semiannual, 3.75, 104.07)};
    private final Datum[] bmaData = new Datum[]{new Datum(1, TimeUnit.Years, 67.56), new Datum(2, TimeUnit.Years, 68.0), new Datum(3, TimeUnit.Years, 68.25), new Datum(4, TimeUnit.Years, 68.5), new Datum(5, TimeUnit.Years, 68.81), new Datum(7, TimeUnit.Years, 69.5), new Datum(10, TimeUnit.Years, 70.44), new Datum(15, TimeUnit.Years, 71.69), new Datum(20, TimeUnit.Years, 72.69), new Datum(30, TimeUnit.Years, 73.81)};

    public PiecewiseYieldCurveTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    private <T extends Traits, I extends Interpolation.Interpolator, B extends Bootstrap> void testCurveConsistency(Class<T> classT, Class<I> classI, Class<B> classB, CommonVars vars) {
        Interpolation.Interpolator interpolator;
        try {
            interpolator = (Interpolation.Interpolator)classI.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.testCurveConsistency(classT, classI, classB, vars, interpolator, 1.0E-9);
    }

    private <T extends Traits, I extends Interpolation.Interpolator, B extends Bootstrap> void testCurveConsistency(Class<T> classT, Class<I> classI, Class<B> classB, CommonVars vars, Interpolation.Interpolator interpolator) {
        this.testCurveConsistency(classT, classI, classB, vars, interpolator, 1.0E-9);
    }

    private <T extends Traits, I extends Interpolation.Interpolator, B extends Bootstrap> void testCurveConsistency(Class<T> classT, Class<I> classI, Class<B> classB, CommonVars vars, Interpolation.Interpolator interpolator, double tolerance) {
        int i;
        vars.termStructure = new PiecewiseYieldCurve<T, I, B>(classT, classI, classB, vars.settlement, vars.instruments, new Actual360(), new Handle[0], new Date[0], 1.0E-12, interpolator);
        RelinkableHandle<YieldTermStructure> curveHandle = new RelinkableHandle<YieldTermStructure>();
        curveHandle.linkTo(vars.termStructure);
        for (int i2 = 0; i2 < vars.deposits; ++i2) {
            double expectedRate = this.depositData[i2].rate / 100.0;
            Euribor index = new Euribor(new Period(this.depositData[i2].n, this.depositData[i2].units), curveHandle);
            double estimatedRate = index.fixing(vars.today);
            if (!(Math.abs(expectedRate - estimatedRate) > tolerance)) continue;
            throw new RuntimeException(String.format("%d %s %s %s %f %s %f", this.depositData[i2].n, this.depositData[i2].units == TimeUnit.Weeks ? "week(s)" : "month(s)", " deposit:", "\n    estimated rate: ", estimatedRate, "\n    expected rate:  ", expectedRate));
        }
        Euribor6M euribor6m = new Euribor6M(curveHandle);
        for (i = 0; i < vars.swaps; ++i) {
            double expectedRate = this.swapData[i].rate / 100.0;
            Period tenor = new Period(this.swapData[i].n, this.swapData[i].units);
            VanillaSwap swap = new MakeVanillaSwap(tenor, euribor6m, 0.0).withEffectiveDate(vars.settlement).withFixedLegDayCount(vars.fixedLegDayCounter).withFixedLegTenor(new Period(vars.fixedLegFrequency)).withFixedLegConvention(vars.fixedLegConvention).withFixedLegTerminationDateConvention(vars.fixedLegConvention).value();
            double estimatedRate = swap.fairRate();
            double error = Math.abs(expectedRate - estimatedRate);
            if (!(error > tolerance)) continue;
            throw new RuntimeException(String.format("%d %s %s %f %s %f %s %f %s %f", this.swapData[i].n, " year(s) swap:\n", "\n estimated rate: ", estimatedRate, "\n expected rate:  ", expectedRate, "\n error:          ", error, "\n tolerance:      ", tolerance));
        }
        vars.termStructure = new PiecewiseYieldCurve<T, I, B>(classT, classI, classB, vars.settlement, vars.bondHelpers, new Actual360(), new Handle[0], new Date[0], 1.0E-12, interpolator);
        curveHandle.linkTo(vars.termStructure);
        for (i = 0; i < vars.bonds; ++i) {
            Date maturity = vars.calendar.advance(vars.today, this.bondData[i].n, this.bondData[i].units);
            Date issue = vars.calendar.advance(maturity, -this.bondData[i].length, TimeUnit.Years);
            double[] coupons = new double[]{this.bondData[i].coupon / 100.0};
            FixedRateBond bond = new FixedRateBond(vars.bondSettlementDays, 100.0, vars.schedules[i], coupons, vars.bondDayCounter, vars.bondConvention, vars.bondRedemption, issue);
            DiscountingBondEngine bondEngine = new DiscountingBondEngine(curveHandle);
            bond.setPricingEngine(bondEngine);
            double expectedPrice = this.bondData[i].price;
            double estimatedPrice = bond.cleanPrice();
            double error = Math.abs(expectedPrice - estimatedPrice);
            if (!(error > tolerance)) continue;
            throw new RuntimeException(String.format("#%d %s %s %f %s %f %s %f", i + 1, " bond failure:", "\n  estimated price: ", estimatedPrice, "\n  expected price:  ", expectedPrice, "\n  error:           ", error));
        }
        vars.termStructure = new PiecewiseYieldCurve<T, I, B>(classT, classI, classB, vars.settlement, vars.fraHelpers, new Actual360(), new Handle[0], new Date[0], 1.0E-12, interpolator);
        curveHandle.linkTo(vars.termStructure);
        Euribor3M euribor3m = new Euribor3M(curveHandle);
        for (int i3 = 0; i3 < vars.fras; ++i3) {
            Date end;
            double expectedRate = this.fraData[i3].rate / 100.0;
            Date start = vars.calendar.advance(vars.settlement, this.fraData[i3].n, this.fraData[i3].units, euribor3m.businessDayConvention(), euribor3m.endOfMonth());
            ForwardRateAgreement fra = new ForwardRateAgreement(start, end = vars.calendar.advance(start, 3, TimeUnit.Months, euribor3m.businessDayConvention(), euribor3m.endOfMonth()), Position.Long, this.fraData[i3].rate / 100.0, 100.0, euribor3m, curveHandle);
            double estimatedRate = fra.forwardRate().rate();
            if (!(Math.abs(expectedRate - estimatedRate) > tolerance)) continue;
            throw new RuntimeException(String.format("#%d %s %s %f %s %f", i3 + 1, " FRA failure:", "\n  estimated rate: ", estimatedRate, "\n  expected rate:  ", expectedRate));
        }
    }

    private <T extends Traits, I extends Interpolation.Interpolator, B extends Bootstrap> void testBMACurveConsistency(Class<T> classT, Class<I> classI, Class<B> classB, CommonVars vars) {
        Interpolation.Interpolator interpolator;
        try {
            interpolator = (Interpolation.Interpolator)classI.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.testCurveConsistency(classT, classI, classB, vars, interpolator, 1.0E-9);
    }

    private <T extends Traits, I extends Interpolation.Interpolator, B extends Bootstrap> void testBMACurveConsistency(Class<T> classT, Class<I> classI, Class<B> classB, CommonVars vars, Interpolation.Interpolator interpolator) {
        this.testCurveConsistency(classT, classI, classB, vars, interpolator, 1.0E-9);
    }

    private <T extends Traits, I extends Interpolation.Interpolator, B extends Bootstrap> void testBMACurveConsistency(Class<T> classT, Class<I> classI, Class<B> classB, CommonVars vars, Interpolation.Interpolator interpolator, double tolerance) {
        vars.calendar = new JointCalendar(new BMAIndex().fixingCalendar(), new USDLibor(new Period(3, TimeUnit.Months)).fixingCalendar(), JointCalendar.JointCalendarRule.JoinHolidays);
        vars.today = vars.calendar.adjust(Date.todaysDate());
        new Settings().setEvaluationDate(vars.today);
        vars.settlement = vars.calendar.advance(vars.today, vars.settlementDays, TimeUnit.Days);
        Handle<YieldTermStructure> riskFreeCurve = new Handle<YieldTermStructure>(new FlatForward(vars.settlement, 0.04, (DayCounter)new Actual360()));
        BMAIndex bmaIndex = new BMAIndex();
        USDLibor liborIndex = new USDLibor(new Period(3, TimeUnit.Months), riskFreeCurve);
        for (int i = 0; i < vars.bmas; ++i) {
            Handle<Quote> f = new Handle<Quote>(vars.fractions[i]);
            vars.bmaHelpers[i] = new BMASwapRateHelper(f, new Period(this.bmaData[i].n, this.bmaData[i].units), vars.settlementDays, vars.calendar, new Period(vars.bmaFrequency), vars.bmaConvention, vars.bmaDayCounter, bmaIndex, liborIndex);
        }
        Weekday w = vars.today.weekday();
        Date lastWednesday = w.ordinal() >= 4 ? vars.today.sub(w.ordinal() - 4) : vars.today.add(4 - w.ordinal() - 7);
        Date lastFixing = bmaIndex.fixingCalendar().adjust(lastWednesday);
        bmaIndex.addFixing(lastFixing, 0.03);
        vars.termStructure = new PiecewiseYieldCurve<T, I, B>(classT, classI, classB, vars.settlement, vars.bmaHelpers, new Actual360(), new Handle[0], new Date[0], 1.0E-12, interpolator);
        RelinkableHandle<YieldTermStructure> curveHandle = new RelinkableHandle<YieldTermStructure>();
        curveHandle.linkTo(vars.termStructure);
        BMAIndex bma = new BMAIndex(curveHandle);
        USDLibor libor3m = new USDLibor(new Period(3, TimeUnit.Months), riskFreeCurve);
        for (int i = 0; i < vars.bmas; ++i) {
            Period tenor = new Period(this.bmaData[i].n, this.bmaData[i].units);
            Schedule bmaSchedule = new MakeSchedule(vars.settlement, vars.settlement.add(tenor), new Period(vars.bmaFrequency), bma.fixingCalendar(), vars.bmaConvention).backwards().schedule();
            Schedule liborSchedule = new MakeSchedule(vars.settlement, vars.settlement.add(tenor), libor3m.tenor(), libor3m.fixingCalendar(), libor3m.businessDayConvention()).endOfMonth(libor3m.endOfMonth()).backwards().schedule();
            BMASwap swap = new BMASwap(BMASwap.Type.Payer, 100.0, liborSchedule, 0.75, 0.0, libor3m, libor3m.dayCounter(), bmaSchedule, bma, vars.bmaDayCounter);
            swap.setPricingEngine(new DiscountingSwapEngine(libor3m.termStructure()));
            double expectedFraction = this.bmaData[i].rate / 100.0;
            double estimatedFraction = swap.fairLiborFraction();
            double error = Math.abs(expectedFraction - estimatedFraction);
            if (!(error > tolerance)) continue;
            throw new RuntimeException(String.format("%d %s %s %f %s %f %s %f %s %f", this.bmaData[i].n, " year(s) BMA swap:\n", "\n estimated libor fraction: ", estimatedFraction, "\n expected libor fraction:  ", expectedFraction, "\n error:          ", error, "\n tolerance:      ", tolerance));
        }
    }

    @Ignore
    @Test
    public void testLogCubicDiscountConsistency() {
        QL.info("Testing consistency of piecewise-log-cubic discount curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(Discount.class, LogCubic.class, IterativeBootstrap.class, vars, new LogCubic(CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0));
    }

    @Ignore
    @Test
    public void testLogLinearDiscountConsistency() {
        QL.info("Testing consistency of piecewise-log-linear discount curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(Discount.class, LogLinear.class, IterativeBootstrap.class, vars);
        this.testBMACurveConsistency(Discount.class, LogLinear.class, IterativeBootstrap.class, vars);
    }

    @Ignore
    @Test
    public void testLinearDiscountConsistency() {
        QL.info("Testing consistency of piecewise-linear discount curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(Discount.class, Linear.class, IterativeBootstrap.class, vars);
        this.testBMACurveConsistency(Discount.class, Linear.class, IterativeBootstrap.class, vars);
    }

    @Ignore
    @Test
    public void testLogLinearZeroConsistency() {
        QL.info("Testing consistency of piecewise-log-linear zero-yield curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(ZeroYield.class, LogLinear.class, IterativeBootstrap.class, vars);
        this.testBMACurveConsistency(ZeroYield.class, LogLinear.class, IterativeBootstrap.class, vars);
    }

    @Ignore
    @Test
    public void testLinearZeroConsistency() {
        QL.info("Testing consistency of piecewise-linear zero-yield curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(ZeroYield.class, Linear.class, IterativeBootstrap.class, vars);
        this.testBMACurveConsistency(ZeroYield.class, Linear.class, IterativeBootstrap.class, vars);
    }

    @Ignore
    @Test
    public void testSplineZeroConsistency() {
        QL.info("Testing consistency of piecewise-cubic zero-yield curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(ZeroYield.class, Cubic.class, IterativeBootstrap.class, vars, new Cubic(CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0));
        this.testBMACurveConsistency(ZeroYield.class, Cubic.class, IterativeBootstrap.class, vars, new Cubic(CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0));
    }

    @Ignore
    @Test
    public void testLinearForwardConsistency() {
        QL.info("Testing consistency of piecewise-linear forward-rate curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(ForwardRate.class, Linear.class, IterativeBootstrap.class, vars);
        this.testBMACurveConsistency(ForwardRate.class, Linear.class, IterativeBootstrap.class, vars);
    }

    @Ignore
    @Test
    public void testFlatForwardConsistency() {
        QL.info("Testing consistency of piecewise-flat forward-rate curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(ForwardRate.class, BackwardFlat.class, IterativeBootstrap.class, vars);
        this.testBMACurveConsistency(ForwardRate.class, BackwardFlat.class, IterativeBootstrap.class, vars);
    }

    @Ignore
    @Test
    public void testSplineForwardConsistency() {
        QL.info("Testing consistency of piecewise-cubic forward-rate curve...");
        CommonVars vars = new CommonVars();
        this.testCurveConsistency(ForwardRate.class, Cubic.class, IterativeBootstrap.class, vars, new Cubic(CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0));
        this.testBMACurveConsistency(ForwardRate.class, Cubic.class, IterativeBootstrap.class, vars, new Cubic(CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0));
    }

    @Ignore
    @Test
    public void testObservability() {
        QL.info("Testing observability of piecewise yield curve...");
        CommonVars vars = new CommonVars();
        vars.termStructure = new PiecewiseYieldCurve<Discount, LogLinear, IterativeBootstrap>(Discount.class, LogLinear.class, IterativeBootstrap.class, vars.settlementDays, vars.calendar, vars.instruments, new Actual360());
        Flag f = new Flag();
        vars.termStructure.addObserver(f);
        for (int i = 0; i < vars.deposits + vars.swaps; ++i) {
            double testTime = new Actual360().yearFraction(vars.settlement, vars.instruments[i].latestDate());
            double discount = vars.termStructure.discount(testTime);
            f.lower();
            vars.rates[i].setValue(vars.rates[i].value() * 1.01);
            if (!f.isUp()) {
                throw new RuntimeException("Observer was not notified of underlying rate change");
            }
            if (vars.termStructure.discount(testTime, true) == discount) {
                throw new RuntimeException("rate change did not trigger recalculation");
            }
            vars.rates[i].setValue(vars.rates[i].value() / 1.01);
        }
        f.lower();
        new Settings().setEvaluationDate(vars.calendar.advance(vars.today, 15, TimeUnit.Days));
        if (!f.isUp()) {
            throw new RuntimeException("Observer was not notified of date change");
        }
    }

    @Ignore
    @Test
    public void testLiborFixing() {
        QL.info("Testing use of today's LIBOR fixings in swap curve...");
        CommonVars vars = new CommonVars();
        RateHelper[] swapHelpers = new RateHelper[vars.swaps];
        Euribor6M euribor6m = new Euribor6M();
        for (int i = 0; i < vars.swaps; ++i) {
            Handle<Quote> r = new Handle<Quote>(vars.rates[i + vars.deposits]);
            swapHelpers[i] = new SwapRateHelper(r, new Period(this.swapData[i].n, this.swapData[i].units), vars.calendar, vars.fixedLegFrequency, vars.fixedLegConvention, vars.fixedLegDayCounter, (IborIndex)euribor6m);
        }
        vars.termStructure = new PiecewiseYieldCurve<Discount, LogLinear, IterativeBootstrap>(Discount.class, LogLinear.class, IterativeBootstrap.class, vars.settlement, swapHelpers, new Actual360());
        Handle<YieldTermStructure> curveHandle = new Handle<YieldTermStructure>(vars.termStructure);
        Euribor6M index = new Euribor6M(curveHandle);
        for (int i = 0; i < vars.swaps; ++i) {
            Period tenor = new Period(this.swapData[i].n, this.swapData[i].units);
            VanillaSwap swap = new MakeVanillaSwap(tenor, index, 0.0).withEffectiveDate(vars.settlement).withFixedLegDayCount(vars.fixedLegDayCounter).withFixedLegTenor(new Period(vars.fixedLegFrequency)).withFixedLegConvention(vars.fixedLegConvention).withFixedLegTerminationDateConvention(vars.fixedLegConvention).value();
            double expectedRate = this.swapData[i].rate / 100.0;
            double estimatedRate = swap.fairRate();
            double tolerance = 1.0E-9;
            if (!(Math.abs(expectedRate - estimatedRate) > 1.0E-9)) continue;
            throw new RuntimeException(String.format("%s %d %s %s %f %s %s %f", "before LIBOR fixing:\n", this.swapData[i].n, " year(s) swap:\n", "    estimated rate: ", estimatedRate, "\n", "    expected rate:  ", expectedRate));
        }
        Flag f = new Flag();
        vars.termStructure.addObserver(f);
        f.lower();
        index.addFixing(vars.today, 0.0425);
        if (!f.isUp()) {
            throw new RuntimeException("Observer was not notified of rate fixing");
        }
        for (int i = 0; i < vars.swaps; ++i) {
            Period tenor = new Period(this.swapData[i].n, this.swapData[i].units);
            VanillaSwap swap = new MakeVanillaSwap(tenor, index, 0.0).withEffectiveDate(vars.settlement).withFixedLegDayCount(vars.fixedLegDayCounter).withFixedLegTenor(new Period(vars.fixedLegFrequency)).withFixedLegConvention(vars.fixedLegConvention).withFixedLegTerminationDateConvention(vars.fixedLegConvention).value();
            double expectedRate = this.swapData[i].rate / 100.0;
            double estimatedRate = swap.fairRate();
            double tolerance = 1.0E-9;
            if (!(Math.abs(expectedRate - estimatedRate) > 1.0E-9)) continue;
            throw new RuntimeException(String.format("%s %d %s %s %f %s %s %f", "after LIBOR fixing:\n", this.swapData[i].n, " year(s) swap:\n", "    estimated rate: ", estimatedRate, "\n", "    expected rate:  ", expectedRate));
        }
    }

    @Ignore
    @Test
    public void testJpyLibor() {
        QL.info("Testing bootstrap over JPY LIBOR swaps...");
        CommonVars vars = new CommonVars();
        vars.today = new Date(4, Month.October, 2007);
        new Settings().setEvaluationDate(vars.today);
        vars.calendar = new Japan();
        vars.settlement = vars.calendar.advance(vars.today, vars.settlementDays, TimeUnit.Days);
        vars.rates = new SimpleQuote[vars.swaps];
        for (int i = 0; i < vars.swaps; ++i) {
            vars.rates[i] = new SimpleQuote(this.swapData[i].rate / 100.0);
        }
        vars.instruments = new RateHelper[vars.swaps];
        JPYLibor index = new JPYLibor(new Period(6, TimeUnit.Months));
        for (int i = 0; i < vars.swaps; ++i) {
            Handle<Quote> r = new Handle<Quote>(vars.rates[i]);
            vars.instruments[i] = new SwapRateHelper(r, new Period(this.swapData[i].n, this.swapData[i].units), vars.calendar, vars.fixedLegFrequency, vars.fixedLegConvention, vars.fixedLegDayCounter, (IborIndex)index);
        }
        vars.termStructure = new PiecewiseYieldCurve<Discount, LogLinear, IterativeBootstrap>(Discount.class, LogLinear.class, IterativeBootstrap.class, vars.settlement, vars.instruments, new Actual360(), new Handle[0], new Date[0], 1.0E-12);
        RelinkableHandle<YieldTermStructure> curveHandle = new RelinkableHandle<YieldTermStructure>();
        curveHandle.linkTo(vars.termStructure);
        JPYLibor jpylibor6m = new JPYLibor(new Period(6, TimeUnit.Months), curveHandle);
        for (int i = 0; i < vars.swaps; ++i) {
            Period tenor = new Period(this.swapData[i].n, this.swapData[i].units);
            VanillaSwap swap = new MakeVanillaSwap(tenor, jpylibor6m, 0.0).withEffectiveDate(vars.settlement).withFixedLegDayCount(vars.fixedLegDayCounter).withFixedLegTenor(new Period(vars.fixedLegFrequency)).withFixedLegConvention(vars.fixedLegConvention).withFixedLegTerminationDateConvention(vars.fixedLegConvention).withFixedLegCalendar(vars.calendar).withFloatingLegCalendar(vars.calendar).value();
            double expectedRate = this.swapData[i].rate / 100.0;
            double estimatedRate = swap.fairRate();
            double error = Math.abs(expectedRate - estimatedRate);
            double tolerance = 1.0E-9;
            if (!(error > 1.0E-9)) continue;
            throw new RuntimeException(String.format("%d %s %s %f %s %f %s %f %s %f", this.swapData[i].n, " year(s) swap:\n", "\n estimated rate: ", estimatedRate, "\n expected rate:  ", expectedRate, "\n error:          ", error, "\n tolerance:      ", 1.0E-9));
        }
    }

    private class CommonVars {
        public Calendar calendar = new Target();
        public final int settlementDays;
        public Date today = this.calendar.adjust(Date.todaysDate());
        public Date settlement;
        public final BusinessDayConvention fixedLegConvention;
        public final Frequency fixedLegFrequency;
        public final DayCounter fixedLegDayCounter;
        public final int bondSettlementDays;
        public final DayCounter bondDayCounter;
        public final BusinessDayConvention bondConvention;
        public final double bondRedemption;
        public final Frequency bmaFrequency;
        public final BusinessDayConvention bmaConvention;
        public final DayCounter bmaDayCounter;
        public final int deposits;
        public final int fras;
        public final int swaps;
        public final int bonds;
        public final int bmas;
        public SimpleQuote[] rates;
        public final SimpleQuote[] fraRates;
        public final SimpleQuote[] prices;
        public final SimpleQuote[] fractions;
        public RateHelper[] instruments;
        public final RateHelper[] fraHelpers;
        public final RateHelper[] bondHelpers;
        public final RateHelper[] bmaHelpers;
        public final Schedule[] schedules;
        public YieldTermStructure termStructure;

        public CommonVars() {
            int i;
            Handle<Quote> r;
            int i2;
            int i3;
            this.settlementDays = 2;
            new Settings().setEvaluationDate(this.today);
            this.settlement = this.calendar.advance(this.today, this.settlementDays, TimeUnit.Days);
            this.fixedLegConvention = BusinessDayConvention.Unadjusted;
            this.fixedLegFrequency = Frequency.Annual;
            this.fixedLegDayCounter = new Thirty360();
            this.bondSettlementDays = 3;
            this.bondDayCounter = new ActualActual(ActualActual.Convention.Bond);
            this.bondConvention = BusinessDayConvention.Following;
            this.bondRedemption = 100.0;
            this.bmaFrequency = Frequency.Quarterly;
            this.bmaConvention = BusinessDayConvention.Following;
            this.bmaDayCounter = new ActualActual(ActualActual.Convention.Bond);
            this.deposits = PiecewiseYieldCurveTest.this.depositData.length;
            this.fras = PiecewiseYieldCurveTest.this.fraData.length;
            this.swaps = PiecewiseYieldCurveTest.this.swapData.length;
            this.bonds = PiecewiseYieldCurveTest.this.bondData.length;
            this.bmas = PiecewiseYieldCurveTest.this.bmaData.length;
            this.rates = new SimpleQuote[this.deposits + this.swaps];
            this.fraRates = new SimpleQuote[this.fras];
            this.fractions = new SimpleQuote[this.bmas];
            this.prices = new SimpleQuote[this.bonds];
            for (i3 = 0; i3 < this.deposits; ++i3) {
                this.rates[i3] = new SimpleQuote(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).depositData[i3].rate / 100.0);
            }
            for (i3 = 0; i3 < this.swaps; ++i3) {
                this.rates[i3 + this.deposits] = new SimpleQuote(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).swapData[i3].rate / 100.0);
            }
            for (i3 = 0; i3 < this.fras; ++i3) {
                this.fraRates[i3] = new SimpleQuote(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).fraData[i3].rate / 100.0);
            }
            for (i3 = 0; i3 < this.bonds; ++i3) {
                this.prices[i3] = new SimpleQuote(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).bondData[i3].price);
            }
            for (i3 = 0; i3 < this.bmas; ++i3) {
                this.fractions[i3] = new SimpleQuote(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).bmaData[i3].rate / 100.0);
            }
            this.instruments = new RateHelper[this.deposits + this.swaps];
            this.fraHelpers = new RateHelper[this.fras];
            this.bondHelpers = new RateHelper[this.bonds];
            this.schedules = new Schedule[this.bonds];
            this.bmaHelpers = new RateHelper[this.bmas];
            Euribor euribor6m = new Euribor(new Period(6, TimeUnit.Months), new Handle<YieldTermStructure>());
            for (i2 = 0; i2 < this.deposits; ++i2) {
                r = new Handle<Quote>(this.rates[i2]);
                this.instruments[i2] = new DepositRateHelper(r, new Period(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).depositData[i2].n, ((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).depositData[i2].units), euribor6m.fixingDays(), this.calendar, euribor6m.businessDayConvention(), euribor6m.endOfMonth(), euribor6m.dayCounter());
            }
            for (i2 = 0; i2 < this.swaps; ++i2) {
                r = new Handle<SimpleQuote>(this.rates[i2 + this.deposits]);
                this.instruments[i2 + this.deposits] = new SwapRateHelper(r, new Period(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).swapData[i2].n, ((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).swapData[i2].units), this.calendar, this.fixedLegFrequency, this.fixedLegConvention, this.fixedLegDayCounter, (IborIndex)euribor6m);
            }
            Euribor euribor3m = new Euribor(new Period(3, TimeUnit.Months), new Handle<YieldTermStructure>());
            for (i = 0; i < this.fras; ++i) {
                Handle<Quote> r2 = new Handle<Quote>(this.fraRates[i]);
                this.fraHelpers[i] = new FraRateHelper(r2, ((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).fraData[i].n, ((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).fraData[i].n + 3, euribor3m.fixingDays(), euribor3m.fixingCalendar(), euribor3m.businessDayConvention(), euribor3m.endOfMonth(), euribor3m.dayCounter());
            }
            for (i = 0; i < this.bonds; ++i) {
                Handle<Quote> p = new Handle<Quote>(this.prices[i]);
                Date maturity = this.calendar.advance(this.today, ((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).bondData[i].n, ((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).bondData[i].units);
                Date issue = this.calendar.advance(maturity, -((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).bondData[i].length, TimeUnit.Years);
                double[] coupons = new double[]{((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).bondData[i].coupon / 100.0};
                this.schedules[i] = new Schedule(issue, maturity, new Period(((PiecewiseYieldCurveTest)PiecewiseYieldCurveTest.this).bondData[i].frequency), this.calendar, this.bondConvention, this.bondConvention, DateGeneration.Rule.Backward, false, new Date(), new Date());
                this.bondHelpers[i] = new FixedRateBondHelper(p, this.bondSettlementDays, this.bondRedemption, this.schedules[i], coupons, this.bondDayCounter, this.bondConvention, this.bondRedemption, issue);
            }
        }
    }

    private static class BondDatum {
        public final int n;
        public final TimeUnit units;
        public final int length;
        public final Frequency frequency;
        public final double coupon;
        public final double price;

        public BondDatum(int n, TimeUnit units, int length, Frequency frequency, double coupon, double price) {
            this.n = n;
            this.units = units;
            this.length = length;
            this.frequency = frequency;
            this.coupon = coupon;
            this.price = price;
        }
    }

    private static class Datum {
        public final int n;
        public final TimeUnit units;
        public final double rate;

        public Datum(int n, TimeUnit units, double rate) {
            this.n = n;
            this.units = units;
            this.rate = rate;
        }
    }
}

