/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.operators;

import org.jquantlib.QL;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;
import org.junit.Assert;
import org.junit.Test;

public class TridiagonalOperatorTest {
    public TridiagonalOperatorTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testSolveFor() {
        Array low = new Array(2);
        Array mid = new Array(3);
        Array high = new Array(2);
        low.set(0, 11.0);
        low.set(1, 1.0);
        mid.set(0, 12.0);
        mid.set(1, 10.0);
        mid.set(2, 3.0);
        high.set(0, 7.0);
        high.set(1, 9.0);
        TridiagonalOperator t = new TridiagonalOperator(low, mid, high);
        Array rhs = new Array(3);
        rhs.set(0, 7.0);
        rhs.set(1, 8.0);
        rhs.set(2, 7.0);
        Array solved = t.solveFor(rhs);
        Array expected = new Array(new double[]{20.0, -33.285714285714285, 13.428571428571429});
        for (int i = 0; i < 3; ++i) {
            double error = Math.abs(solved.get(i) - expected.get(i));
            if (!(error > 1.0E-15)) continue;
            Assert.fail((String)(" TridiagonalOperator expected:\n { 20, -33.2857, 13.4286 } \n got: " + solved.get(0) + "\n" + "  " + solved.get(1) + "\n" + "  " + solved.get(2)));
        }
    }
}

