/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.money;

import org.jquantlib.QL;
import org.jquantlib.currencies.America;
import org.jquantlib.currencies.Europe;
import org.jquantlib.currencies.ExchangeRate;
import org.jquantlib.currencies.ExchangeRateManager;
import org.jquantlib.currencies.Money;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.Rounding;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MoneyTest {
    public MoneyTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        QL.info("see testsuite.money.cpp/hpp");
    }

    @Ignore
    @Test
    public void testBaseCurrency() {
        QL.info("Testing money arithmetic with conversion to base currency...");
        Europe.EURCurrency EUR = new Europe.EURCurrency();
        Europe.GBPCurrency GBP = new Europe.GBPCurrency();
        America.USDCurrency USD = new America.USDCurrency();
        Money m1 = Money.multiple(50000.0, GBP);
        Money m2 = Money.multiple(100000.0, EUR);
        Money m3 = Money.multiple(500000.0, USD);
        ExchangeRateManager.getInstance().clear();
        ExchangeRate eur_usd = new ExchangeRate(EUR, USD, 1.2042);
        ExchangeRate eur_gbp = new ExchangeRate(EUR, GBP, 0.6612);
        ExchangeRateManager.getInstance().add(eur_usd);
        ExchangeRateManager.getInstance().add(eur_gbp);
        Money.conversionType = Money.ConversionType.BaseCurrencyConversion;
        Money.baseCurrency = EUR;
        Money calculated0 = m1.mul(3.0);
        Money calculated1 = m2.mul(2.5);
        Money calculated2 = m3.div(5.0);
        Money calculated3 = calculated0.add(calculated1).sub(calculated2);
        QL.info("Calculated value: " + calculated3.value());
        Rounding round = Money.baseCurrency.rounding();
        double x = round.operator(m1.value() * 3.0 / eur_gbp.rate()) + 2.5 * m2.value() - round.operator(m3.value() / (5.0 * eur_usd.rate()));
        QL.info("Expected value: " + x);
        Money expected = new Money(x, EUR);
        Assert.assertTrue((boolean)Closeness.isClose(calculated3.value(), expected.value()));
        if (!calculated3.equals(expected)) {
            Assert.fail((String)("Wrong result: \n    expected:   " + expected + "\n" + "    calculated: " + calculated3));
        }
        QL.info("testBaseCurrency done!");
    }

    @Ignore
    @Test
    public void testNone() {
        QL.info("Testing money arithmetic without conversions...");
        Europe.EURCurrency EUR = new Europe.EURCurrency();
        Money m1 = Money.multiple(50000.0, EUR);
        Money m2 = Money.multiple(100000.0, EUR);
        Money m3 = Money.multiple(500000.0, EUR);
        Money.conversionType = Money.ConversionType.NoConversion;
        Money calculated0 = m1.mul(3.0);
        Money calculated1 = m2.mul(2.5);
        Money calculated2 = m3.div(5.0);
        Money calculated3 = calculated0.add(calculated1).sub(calculated2);
        QL.info("Calculated value: " + calculated3.value());
        double x = m1.value() * 3.0 + 2.5 * m2.value() - m3.value() / 5.0;
        QL.info("Expected value: " + x);
        Money expected = new Money(x, EUR);
        if (!calculated3.equals(expected)) {
            Assert.fail((String)("Wrong result: \n    expected:   " + expected + "\n" + "    calculated: " + calculated3));
        }
        QL.info("testNone done!");
    }
}

