/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.solvers1D;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.Derivative;
import org.jquantlib.math.solvers1D.Newton;
import org.junit.Assert;
import org.junit.Test;

public class NewtonTest {
    public NewtonTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testNewton() {
        double accuracy = 1.0E-15;
        double guess = 1.5;
        double xMin = 0.0;
        double xMax = 3.0;
        Newton newt = new Newton();
        Derivative f = new Derivative(){

            @Override
            public double op(double x) {
                return x * x - 1.0;
            }

            @Override
            public double derivative(double x) {
                return 2.0 * x;
            }
        };
        double root = newt.solve(f, 1.0E-15, 1.5, 0.0, 3.0);
        if (Math.abs(1.0 - root) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but root is: " + root));
        }
        if (newt.getMaxEvaluations() != 100) {
            Assert.fail((String)("expected: 100 but was: " + newt.getMaxEvaluations()));
        }
        if (Math.abs(1.0 - (root = newt.solve(f, 1.0E-15, 0.01, 0.1))) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but root is: " + root));
        }
        if (newt.getNumEvaluations() != 10) {
            Assert.fail((String)("expected: 10 but was: " + newt.getNumEvaluations()));
        }
    }
}

